/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.RandUtils;
import org.bouncycastle.pqc.math.linearalgebra.Vector;
import org.bouncycastle.util.Arrays;

public class GF2Vector
extends Vector {
    private int[] v;

    public GF2Vector(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative length.");
        }
        this.length = n;
        this.v = new int[n + 31 >> 5];
    }

    public GF2Vector(int n, SecureRandom secureRandom) {
        this.length = n;
        int n2 = n + 31 >> 5;
        this.v = new int[n2];
        int n3 = n2 - 1;
        while (n3 >= 0) {
            this.v[n3] = secureRandom.nextInt();
            --n3;
        }
        int n4 = n & 0x1F;
        if (n4 != 0) {
            int n5 = n2 - 1;
            this.v[n5] = this.v[n5] & (1 << n4) - 1;
        }
    }

    public GF2Vector(int n, int n2, SecureRandom secureRandom) {
        if (n2 > n) {
            throw new ArithmeticException("The hamming weight is greater than the length of vector.");
        }
        this.length = n;
        int n3 = n + 31 >> 5;
        this.v = new int[n3];
        int[] nArray = new int[n];
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = n4;
            ++n4;
        }
        int n5 = n;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = RandUtils.nextInt(secureRandom, n5);
            this.setBit(nArray[n7]);
            nArray[n7] = nArray[--n5];
            ++n6;
        }
    }

    public GF2Vector(int n, int[] nArray) {
        if (n < 0) {
            throw new ArithmeticException("negative length");
        }
        this.length = n;
        int n2 = n + 31 >> 5;
        if (nArray.length != n2) {
            throw new ArithmeticException("length mismatch");
        }
        this.v = IntUtils.clone(nArray);
        int n3 = n & 0x1F;
        if (n3 != 0) {
            int n4 = n2 - 1;
            this.v[n4] = this.v[n4] & (1 << n3) - 1;
        }
    }

    public GF2Vector(GF2Vector gF2Vector) {
        this.length = gF2Vector.length;
        this.v = IntUtils.clone(gF2Vector.v);
    }

    protected GF2Vector(int[] nArray, int n) {
        this.v = nArray;
        this.length = n;
    }

    public static GF2Vector OS2VP(int n, byte[] byArray) {
        if (n < 0) {
            throw new ArithmeticException("negative length");
        }
        int n2 = n + 7 >> 3;
        if (byArray.length > n2) {
            throw new ArithmeticException("length mismatch");
        }
        return new GF2Vector(n, LittleEndianConversions.toIntArray(byArray));
    }

    public byte[] getEncoded() {
        int n = this.length + 7 >> 3;
        return LittleEndianConversions.toByteArray(this.v, n);
    }

    public int[] getVecArray() {
        return this.v;
    }

    public int getHammingWeight() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.v.length) {
            int n3 = this.v[n2];
            int n4 = 0;
            while (n4 < 32) {
                int n5 = n3 & 1;
                if (n5 != 0) {
                    ++n;
                }
                n3 >>>= 1;
                ++n4;
            }
            ++n2;
        }
        return n;
    }

    public boolean isZero() {
        int n = this.v.length - 1;
        while (n >= 0) {
            if (this.v[n] != 0) {
                return false;
            }
            --n;
        }
        return true;
    }

    public int getBit(int n) {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return (this.v[n2] & 1 << n3) >>> n3;
    }

    public void setBit(int n) {
        if (n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = n >> 5;
        this.v[n2] = this.v[n2] | 1 << (n & 0x1F);
    }

    public Vector add(Vector vector) {
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        GF2Vector gF2Vector = (GF2Vector)vector;
        if (this.length != gF2Vector.length) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = IntUtils.clone(((GF2Vector)vector).v);
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = n;
            nArray[n2] = nArray[n2] ^ this.v[n];
            --n;
        }
        return new GF2Vector(this.length, nArray);
    }

    public Vector multiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (this.length != nArray.length) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Vector gF2Vector = new GF2Vector(this.length);
        int n = 0;
        while (n < nArray.length) {
            int n2 = this.v[nArray[n] >> 5] & 1 << (nArray[n] & 0x1F);
            if (n2 != 0) {
                int n3 = n >> 5;
                gF2Vector.v[n3] = gF2Vector.v[n3] | 1 << (n & 0x1F);
            }
            ++n;
        }
        return gF2Vector;
    }

    public GF2Vector extractVector(int[] nArray) {
        int n = nArray.length;
        if (nArray[n - 1] > this.length) {
            throw new ArithmeticException("invalid index set");
        }
        GF2Vector gF2Vector = new GF2Vector(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.v[nArray[n2] >> 5] & 1 << (nArray[n2] & 0x1F);
            if (n3 != 0) {
                int n4 = n2 >> 5;
                gF2Vector.v[n4] = gF2Vector.v[n4] | 1 << (n2 & 0x1F);
            }
            ++n2;
        }
        return gF2Vector;
    }

    public GF2Vector extractLeftVector(int n) {
        if (n > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (n == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector gF2Vector = new GF2Vector(n);
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        System.arraycopy(this.v, 0, gF2Vector.v, 0, n2);
        if (n3 != 0) {
            gF2Vector.v[n2] = this.v[n2] & (1 << n3) - 1;
        }
        return gF2Vector;
    }

    public GF2Vector extractRightVector(int n) {
        if (n > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (n == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector gF2Vector = new GF2Vector(n);
        int n2 = this.length - n >> 5;
        int n3 = this.length - n & 0x1F;
        int n4 = n + 31 >> 5;
        int n5 = n2;
        if (n3 != 0) {
            int n6 = 0;
            while (n6 < n4 - 1) {
                gF2Vector.v[n6] = this.v[n5++] >>> n3 | this.v[n5] << 32 - n3;
                ++n6;
            }
            gF2Vector.v[n4 - 1] = this.v[n5++] >>> n3;
            if (n5 < this.v.length) {
                int n7 = n4 - 1;
                gF2Vector.v[n7] = gF2Vector.v[n7] | this.v[n5] << 32 - n3;
            }
        } else {
            System.arraycopy(this.v, n2, gF2Vector.v, 0, n4);
        }
        return gF2Vector;
    }

    public GF2mVector toExtensionFieldVector(GF2mField gF2mField) {
        int n = gF2mField.getDegree();
        if (this.length % n != 0) {
            throw new ArithmeticException("conversion is impossible");
        }
        int n2 = this.length / n;
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            int n5 = gF2mField.getDegree() - 1;
            while (n5 >= 0) {
                int n6 = n3 >>> 5;
                int n7 = n3 & 0x1F;
                int n8 = this.v[n6] >>> n7 & 1;
                if (n8 == 1) {
                    int n9 = n4;
                    nArray[n9] = nArray[n9] ^ 1 << n5;
                }
                ++n3;
                --n5;
            }
            --n4;
        }
        return new GF2mVector(gF2mField, nArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2Vector)) {
            return false;
        }
        GF2Vector gF2Vector = (GF2Vector)object;
        return this.length == gF2Vector.length && IntUtils.equals(this.v, gF2Vector.v);
    }

    public int hashCode() {
        int n = this.length;
        n = n * 31 + Arrays.hashCode(this.v);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.length) {
            int n2;
            int n3;
            int n4;
            if (n != 0 && (n & 0x1F) == 0) {
                stringBuffer.append(' ');
            }
            if ((n4 = this.v[n3 = n >> 5] & 1 << (n2 = n & 0x1F)) == 0) {
                stringBuffer.append('0');
            } else {
                stringBuffer.append('1');
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

