/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.io.Serializable;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class iASBrokerAdmin {
    public static final String DEFAULT_ADMIN_USERNAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWD = "admin";
    private QueueConnectionFactory qcf;
    private QueueConnection connection;
    private QueueSession session;
    private Queue requestQueue;
    private TemporaryQueue replyQueue;
    private QueueSender sender;
    protected QueueReceiver receiver;
    private int timeout = 5000;

    public iASBrokerAdmin(String host, String port) {
        try {
            this.qcf = new QueueConnectionFactory();
            this.qcf.setConnectionType("ADMIN");
            this.qcf.setProperty("imqBrokerHostName", host);
            this.qcf.setProperty("imqBrokerHostPort", port);
            this.connection = this.qcf.createQueueConnection("admin", "admin");
            this.connection.start();
            this.session = this.connection.createQueueSession(false, 2);
            this.requestQueue = this.session.createQueue("__JMQAdmin");
            this.replyQueue = this.session.createTemporaryQueue();
            this.sender = this.session.createSender(this.requestQueue);
            this.sender.setDeliveryMode(1);
            this.receiver = this.session.createReceiver((Queue)this.replyQueue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendHelloMessage() throws BrokerAdminException {
        ObjectMessage mesg = null;
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo((Destination)this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 28);
            this.sender.send((Message)mesg);
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
    }

    public void receiveHelloReplyMessage() throws BrokerAdminException {
        Message mesg = null;
        try {
            mesg = this.receiver.receive((long)this.timeout);
            mesg.acknowledge();
            this.checkReplyTypeStatus(mesg, 29, "HELLO_REPLY");
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
    }

    public void sendGetDestinationsMessage() throws BrokerAdminException {
        ObjectMessage mesg = null;
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo((Destination)this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 20);
            this.sender.send((Message)mesg);
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
    }

    public Vector receiveGetDestinationsReplyMessage() throws BrokerAdminException {
        ObjectMessage mesg = null;
        try {
            mesg = (ObjectMessage)this.receiver.receive((long)this.timeout);
            mesg.acknowledge();
            this.checkReplyTypeStatus((Message)mesg, 21, "GET_DESTINATIONS_REPLY");
            Serializable obj = mesg.getObject();
            if (obj != null && obj instanceof Vector) {
                return (Vector)obj;
            }
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
        return null;
    }

    public void sendCreateDestinationMessage(DestinationInfo dstInfo) throws BrokerAdminException {
        ObjectMessage mesg = null;
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo((Destination)this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 10);
            mesg.setObject((Serializable)dstInfo);
            this.sender.send((Message)mesg);
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
    }

    public void receiveCreateDestinationReplyMessage() throws BrokerAdminException {
        Message mesg = null;
        try {
            mesg = this.receiver.receive((long)this.timeout);
            mesg.acknowledge();
            this.checkReplyTypeStatus(mesg, 11, "CREATE_DESTINATION_REPLY");
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
    }

    public void sendShutdownMessage() throws BrokerAdminException {
        ObjectMessage mesg = null;
        try {
            mesg = this.session.createObjectMessage();
            mesg.setJMSReplyTo((Destination)this.replyQueue);
            mesg.setIntProperty("JMQMessageType", 38);
            this.sender.send((Message)mesg);
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
    }

    public void receiveShutdownReplyMessage() throws BrokerAdminException {
        Message mesg = null;
        try {
            mesg = this.receiver.receive((long)this.timeout);
            this.checkReplyTypeStatus(mesg, 39, "SHUTDOWN_REPLY");
        }
        catch (JMSException jmse) {
        }
        catch (Exception e) {
            BrokerAdminException bae = new BrokerAdminException(0);
            bae.setLinkedException(e);
            throw bae;
        }
    }

    public void close() {
        try {
            this.sender.close();
            this.receiver.close();
            this.session.close();
            this.connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkReplyTypeStatus(Message mesg, int msgType, String msgTypeString) {
        int actualMsgType = -1;
        int actualReplyStatus = -1;
        if (mesg == null && msgType == 39) {
            return;
        }
        try {
            actualMsgType = mesg.getIntProperty("JMQMessageType");
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        try {
            actualReplyStatus = mesg.getIntProperty("JMQStatus");
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        if (msgType == actualMsgType && actualReplyStatus == 200) {
            return;
        }
        System.out.println("Error occurred while checking the reply.");
        System.exit(1);
    }
}

