/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryDestination;
import com.sun.messaging.jms.IllegalStateException;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

abstract class Consumer {
    private static final String DMQ = "mq.sys.dmq";
    protected String messageSelector = null;
    protected ConnectionImpl connection = null;
    protected Long interestId = null;
    protected Integer destType = null;
    protected boolean durable = false;
    protected boolean noLocal = false;
    protected javax.jms.Destination destination = null;
    private String destName = null;
    protected String durableName = null;
    protected String sharedSubscriptionName = null;
    protected boolean shared = false;
    protected boolean debug = Debug.debug;
    private boolean isRegistered = false;
    protected boolean isClosed = false;
    protected int prefetchMaxMsgCount = 100;
    protected int prefetchThresholdPercent = 50;
    protected boolean noprefetch = false;
    protected int acknowledgeMode = -1;
    protected boolean isDMQConsumer = false;

    public Consumer(ConnectionImpl connection, javax.jms.Destination dest, String messageSelector, boolean noLocal) throws JMSException {
        if (dest == null) {
            String errorString = AdministeredObject.cr.getKString("C4050", "null");
            InvalidDestinationException jmse = new InvalidDestinationException(errorString, "C4050");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
        this.messageSelector = messageSelector;
        this.connection = connection;
        this.destination = dest;
        this.noLocal = noLocal;
        this.checkConsumerCreation();
        this.prefetchMaxMsgCount = connection.prefetchMaxMsgCount;
        this.prefetchThresholdPercent = connection.prefetchThresholdPercent;
        boolean bl = this.noprefetch = !connection.consumerFlowLimitPrefetch;
        if (dest instanceof Queue) {
            String tmpdn = ((Queue)dest).getQueueName();
            if (tmpdn.equals(DMQ)) {
                this.isDMQConsumer = true;
            }
            this.destName = "Q:" + tmpdn;
        } else {
            this.destName = dest instanceof Topic ? "T:" + ((Topic)dest).getTopicName() : dest.toString();
        }
    }

    public Consumer(ConnectionImpl connection, javax.jms.Destination dest, String messageSelector) throws JMSException {
        this(connection, dest, messageSelector, false);
    }

    public Consumer(ConnectionImpl connection, javax.jms.Destination dest) throws JMSException {
        this(connection, dest, null, false);
    }

    protected void registerInterest() throws JMSException {
        this.connection.addInterest(this);
        this.isRegistered = true;
    }

    protected void deregisterInterest() throws JMSException {
        this.connection.removeInterest(this);
        FlowControl fc = this.connection.getReadChannel().flowControl;
        fc.removeConsumerFlowControl(this);
        this.isRegistered = false;
    }

    protected void checkConsumerCreation() throws JMSException {
        TemporaryDestination.checkTemporaryDestinationConsumerAllowed(this.connection, this.destination);
    }

    protected abstract void onMessage(MessageImpl var1) throws JMSException;

    protected abstract Long getReadQueueId();

    protected Long getInterestId() {
        return this.interestId;
    }

    protected void setInterestId(Long id) {
        this.interestId = id;
    }

    protected Integer getDestType() {
        return this.destType;
    }

    protected void setDestType(Integer destType) {
        this.destType = destType;
    }

    protected boolean getIsRegistered() {
        return this.isRegistered;
    }

    protected void setDurable(boolean flag) {
        this.durable = flag;
    }

    protected boolean getDurable() {
        return this.durable;
    }

    protected void setShared(boolean flag) {
        this.shared = flag;
    }

    protected boolean getShared() {
        return this.shared;
    }

    protected void setNoLocal(boolean flag) {
        this.noLocal = flag;
    }

    protected boolean getNoLocal() throws JMSException {
        return this.noLocal;
    }

    protected void setMessageSelector(String selector) throws JMSException {
        this.messageSelector = selector;
    }

    protected javax.jms.Destination getDestination() {
        return this.destination;
    }

    protected String getDestName() {
        return this.destName;
    }

    protected void setDurableName(String name) {
        this.durableName = name;
    }

    protected String getDurableName() {
        return this.durableName;
    }

    protected void setSharedSubscriptionName(String name) {
        this.sharedSubscriptionName = name;
    }

    protected String getSharedSubscriptionName() {
        return this.sharedSubscriptionName;
    }

    protected ConnectionImpl getConnection() {
        return this.connection;
    }

    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this.messageSelector;
    }

    protected void checkState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4063");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4063");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
    }

    public void setPrefetchMaxMsgCount(int prefetchMaxMsgCount) {
        this.prefetchMaxMsgCount = prefetchMaxMsgCount;
    }

    public int getPrefetchMaxMsgCount() {
        return this.prefetchMaxMsgCount;
    }

    public void setPrefetchThresholdPercent(int prefetchThresholdPercent) {
        this.prefetchThresholdPercent = prefetchThresholdPercent;
    }

    public int getPrefetchThresholdPercent() {
        return this.prefetchThresholdPercent;
    }

    protected void dump(PrintStream ps) {
        ps.println("Interest ID: " + this.interestId);
        ps.println("is durable: " + this.durable);
        if (this.durable) {
            ps.println("durableName: " + this.durableName);
        }
        if (this.sharedSubscriptionName != null) {
            ps.println("sharedSubscriptionName: " + this.sharedSubscriptionName);
        }
        ps.println("is registered: " + this.isRegistered);
        ps.println("destination: " + this.destination);
    }

    protected Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("consumerID", String.valueOf(this.interestId));
        ht.put("noLocal", String.valueOf(this.noLocal));
        ht.put("Destination Class", this.destination.getClass().getName());
        if (this.destination instanceof Destination) {
            ht.put("Destination", ((Destination)this.destination).getName());
        }
        if (this.messageSelector != null) {
            ht.put("selector", String.valueOf(this.messageSelector));
        }
        ht.put("durable", String.valueOf(this.durable));
        if (this.durable) {
            ht.put("durableName", String.valueOf(this.durableName));
        }
        if (this.sharedSubscriptionName != null) {
            ht.put("sharedSubscriptionName", String.valueOf(this.sharedSubscriptionName));
        }
        ht.put("isRegistered", String.valueOf(this.isRegistered));
        ht.put("isClosed", String.valueOf(this.isClosed));
        ht.put("FlowControl", this.connection.getReadChannel().flowControl.getDebugState(this));
        return ht;
    }

    public String toString() {
        return "ConsumerID: " + this.interestId + ", ConnectionID=" + this.connection.getConnectionID();
    }
}

