/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQMessageConsumer;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ReceiveQueue;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageListener;

public class MessageConsumerImpl
extends Consumer
implements MQMessageConsumer,
Traceable {
    protected MessageListener messageListener = null;
    protected SessionImpl session = null;
    protected ReceiveQueue receiveQueue = null;
    private boolean syncReadFlag = true;
    protected SysMessageID lastDeliveredID = null;
    protected boolean lastDeliveredIDInTransaction = false;
    private boolean pendingPrefetch = false;

    public MessageConsumerImpl(SessionImpl session, javax.jms.Destination dest, String messageSelector, boolean noLocal) throws JMSException {
        super(session.getConnection(), dest, messageSelector, noLocal);
        this.session = session;
        this.init();
    }

    public MessageConsumerImpl(SessionImpl session, javax.jms.Destination dest) throws JMSException {
        super(session.getConnection(), dest);
        this.session = session;
    }

    protected void init() throws JMSException {
        try {
            this.checkConsumerCreation();
            this.receiveQueue = new ReceiveQueue();
            if (!this.session.getTransacted()) {
                this.acknowledgeMode = this.session.acknowledgeMode;
            }
            this.addInterest();
            if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I300");
            }
        }
        catch (JMSException jmse) {
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    @Override
    protected void setInterestId(Long id) {
        this.lastDeliveredID = null;
        this.lastDeliveredIDInTransaction = false;
        this.pendingPrefetch = false;
        super.setInterestId(id);
    }

    private void addInterest() throws JMSException {
        this.session.checkConsumerCreation();
        this.registerInterest();
    }

    private void removeInterest() throws JMSException {
        this.session.removeMessageConsumer(this);
        this.deregisterInterest();
    }

    private synchronized void setSyncReadFlag(boolean flag) {
        this.syncReadFlag = flag;
    }

    protected synchronized boolean getSyncReadFlag() {
        return this.syncReadFlag;
    }

    protected void checkReceive() throws JMSException {
        JMSException jmse;
        String errorString;
        this.checkState();
        if (!this.getSyncReadFlag()) {
            errorString = AdministeredObject.cr.getKString("C4032");
            jmse = new JMSException(errorString, "C4032");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (this.session.failoverOccurred && this.session.acknowledgeMode == 2) {
            errorString = AdministeredObject.cr.getKString("C4106");
            jmse = new JMSException(errorString, "C4106");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.session.checkFailOver();
    }

    protected void stop() {
        this.receiveQueue.stop();
    }

    protected void stopNoWait() {
        this.receiveQueue.stopNoWait();
    }

    protected void start() {
        this.receiveQueue.start();
    }

    protected SessionQueue getReceiveQueue() {
        return this.receiveQueue;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    @Override
    protected Long getReadQueueId() {
        return this.session.getSessionId();
    }

    @Override
    protected void onMessage(MessageImpl message) throws JMSException {
        if (this.getSyncReadFlag()) {
            this.receiveQueue.enqueueNotify(message);
        } else if (this.receiveQueue.isEmpty()) {
            this.deliverAndAcknowledge(message);
        } else {
            this.receiveQueue.enqueueNotify(message);
            this.onMessageToListenerFromReceiveQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessageToListenerFromReceiveQueue() throws JMSException {
        if (!this.receiveQueue.isEmpty()) {
            ReceiveQueue receiveQueue = this.receiveQueue;
            synchronized (receiveQueue) {
                while (!this.receiveQueue.isEmpty()) {
                    MessageImpl message = (MessageImpl)this.receiveQueue.dequeue();
                    if (message == null) continue;
                    this.deliverAndAcknowledge(message);
                }
                this.session.sessionQueue.setListenerLate(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deliverAndAcknowledge(MessageImpl message) throws JMSException {
        this.session.sessionReader.setCurrentMessage(message);
        int retryCount = 0;
        try {
            block17: {
                this.session.setIsMessageListenerThread(true);
                if (!this.isDMQConsumer && message._isExpired()) {
                    this.session.acknowledgeExpired(message);
                    return;
                }
                try {
                    this.messageListener.onMessage((Message)message);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    boolean doredeliver = false;
                    int redeliveryCount = message.getIntProperty("JMSXDeliveryCount");
                    if (!this.session.getTransacted() && this.session.acknowledgeMode != 2) {
                        message.doAcknowledge = false;
                        if (!this.isClosed) {
                            doredeliver = true;
                        }
                    }
                    if (!doredeliver) break block17;
                    message.setJMSRedelivered(true);
                    try {
                        message.updateDeliveryCount(++redeliveryCount);
                        message.setClientRetries(++retryCount);
                        this.messageListener.onMessage((Message)message);
                        message.doAcknowledge = true;
                    }
                    catch (Exception e1) {
                        Debug.printStackTrace(e1);
                        if (message.consumerInRA) break block17;
                        int attemptcnt = 1;
                        int attempts = this.connection.onMessageExRedeliveryAttempts;
                        while (attemptcnt < attempts && !this.isClosed) {
                            message.doAcknowledge = false;
                            message.setJMSRedelivered(true);
                            if (this.connection.onMessageExRedeliveryIntervals > 0L && !this.session.sessionQueue.waitMaxInterval(this.connection.onMessageExRedeliveryIntervals)) break;
                            try {
                                message.updateDeliveryCount(++redeliveryCount);
                                message.setClientRetries(++retryCount);
                                this.messageListener.onMessage((Message)message);
                                message.doAcknowledge = true;
                                break;
                            }
                            catch (Exception ee) {
                                Debug.printStackTrace(ee);
                                if (++attemptcnt < attempts) continue;
                                String warnmsg = AdministeredObject.cr.getKString("W2010", String.valueOf(attempts), message.getMessageID() + "[" + this.getDestName() + "]");
                                SessionImpl.sessionLogger.log(Level.WARNING, warnmsg);
                                try {
                                    this.session.acknowledgeUndeliverable(message);
                                }
                                catch (Exception e2) {
                                    warnmsg = AdministeredObject.cr.getKString("W2011", message.getMessageID() + "[" + this.getDestName() + "]", e2.toString());
                                    SessionImpl.sessionLogger.log(Level.WARNING, warnmsg);
                                    Debug.printStackTrace(e2);
                                }
                            }
                        }
                    }
                }
            }
            if (!(!message.doAcknowledge || message.consumerInRA || this.session.getTransacted() && this.connection.isAppTransactedAck())) {
                this.session.acknowledge(message);
            }
        }
        finally {
            this.session.setIsMessageListenerThread(false);
        }
        this.setLastDeliveredID(message.getMessageID(), true);
    }

    private void setLastDeliveredID(SysMessageID sysid, boolean fromOnMessage) {
        if (fromOnMessage) {
            if (!this.session.getTransactedNoCheck() || !this.connection.isAppTransactedAck()) {
                this.lastDeliveredID = sysid;
                this.lastDeliveredIDInTransaction = this.session.getTransactedNoCheck();
            }
        } else {
            this.lastDeliveredID = sysid;
            this.lastDeliveredIDInTransaction = this.session.getTransactedNoCheck();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkState();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkState();
        this.messageListener = listener;
        if (listener == null) {
            this.setSyncReadFlag(true);
        } else {
            this.setSyncReadFlag(false);
            if (this.receiveQueue.size() > 0) {
                this.session.sessionQueue.setListenerLateNotify();
            }
        }
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        MessageImpl message = null;
        while (true) {
            this.checkReceive();
            try {
                if (this.noprefetch && this.pendingPrefetch) {
                    this.session.doPrefetch(this);
                    this.pendingPrefetch = false;
                }
                if ((message = (MessageImpl)this.receiveQueue.dequeueWait(timeout)) != null) {
                    if (!this.isDMQConsumer && message._isExpired()) {
                        if (this.noprefetch) {
                            this.pendingPrefetch = true;
                            this.session.acknowledgeExpired(message, false);
                            continue;
                        }
                        this.session.acknowledgeExpired(message, true);
                        continue;
                    }
                    if (!this.session.getTransacted() || !this.connection.isAppTransactedAck()) {
                        if (this.noprefetch) {
                            this.pendingPrefetch = true;
                            this.session.acknowledge(message, false);
                        } else {
                            this.session.acknowledge(message, true);
                        }
                    }
                    this.setLastDeliveredID(message.getMessageID(), false);
                    break;
                }
                if (!this.session.connection.connectionIsBroken) break;
                String errorString = AdministeredObject.cr.getKString("C4063");
                com.sun.messaging.jms.JMSException jmse = new com.sun.messaging.jms.JMSException(errorString, "C4063");
                if (this.session.connection.readChannel.savedJMSException != null) {
                    jmse.setLinkedException((Exception)((Object)this.session.connection.readChannel.savedJMSException));
                }
                ExceptionHandler.throwJMSException(jmse);
            }
            finally {
                this.receiveQueue.setReceiveInProcess(false);
                continue;
            }
            break;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBody(Class<T> c, long timeout) throws JMSException {
        MessageImpl message = null;
        T body = null;
        MessageFormatException e = null;
        while (true) {
            this.checkReceive();
            try {
                Object jmse;
                String errorString;
                if (this.noprefetch && this.pendingPrefetch) {
                    this.session.doPrefetch(this);
                    this.pendingPrefetch = false;
                }
                if ((message = (MessageImpl)this.receiveQueue.dequeueWait(timeout)) != null) {
                    try {
                        body = message.getBody(c);
                        if (body == null) {
                            errorString = AdministeredObject.cr.getKString("C4320");
                            jmse = new MessageFormatException(errorString, "C4320");
                            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
                        }
                    }
                    catch (MessageFormatException mfe) {
                        if (this.session.getAcknowledgeMode() == 1 || this.session.getAcknowledgeMode() == 3) {
                            this.receiveQueue.enqueueFirst(message);
                            throw mfe;
                        }
                        e = mfe;
                    }
                    if (!this.isDMQConsumer && message._isExpired()) {
                        if (this.noprefetch) {
                            this.pendingPrefetch = true;
                            this.session.acknowledgeExpired(message, false);
                            continue;
                        }
                        this.session.acknowledgeExpired(message, true);
                        continue;
                    }
                    if (!this.session.getTransacted() || !this.connection.isAppTransactedAck()) {
                        if (this.noprefetch) {
                            this.pendingPrefetch = true;
                            this.session.acknowledge(message, false);
                        } else {
                            this.session.acknowledge(message, true);
                        }
                    }
                    this.setLastDeliveredID(message.getMessageID(), false);
                    break;
                }
                body = null;
                if (!this.session.connection.connectionIsBroken) break;
                errorString = AdministeredObject.cr.getKString("C4063");
                jmse = new com.sun.messaging.jms.JMSException(errorString, "C4063");
                if (this.session.connection.readChannel.savedJMSException != null) {
                    jmse.setLinkedException((Exception)((Object)this.session.connection.readChannel.savedJMSException));
                }
                ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
            }
            finally {
                this.receiveQueue.setReceiveInProcess(false);
                continue;
            }
            break;
        }
        if (e != null) {
            throw e;
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws JMSException {
        MessageImpl message = null;
        while (true) {
            this.checkReceive();
            try {
                if (this.receiveQueue.getIsLocked()) {
                    Message message2 = null;
                    return message2;
                }
                this.receiveQueue.setReceiveInProcess(true);
                if (this.noprefetch && this.pendingPrefetch) {
                    this.session.doPrefetch(this);
                    this.pendingPrefetch = false;
                }
                if ((message = (MessageImpl)this.receiveQueue.dequeue()) == null) break;
                if (!this.isDMQConsumer && message._isExpired()) {
                    if (this.noprefetch) {
                        this.pendingPrefetch = true;
                        this.session.acknowledgeExpired(message, false);
                        continue;
                    }
                    this.session.acknowledgeExpired(message, true);
                    continue;
                }
                if (this.noprefetch) {
                    this.pendingPrefetch = true;
                    this.session.acknowledge(message, false);
                } else {
                    this.session.acknowledge(message, true);
                }
                this.setLastDeliveredID(message.getMessageID(), false);
            }
            finally {
                this.receiveQueue.setReceiveInProcess(false);
                continue;
            }
            break;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T receiveBodyNoWait(Class<T> c) throws JMSException {
        MessageImpl message = null;
        T body = null;
        MessageFormatException e = null;
        while (true) {
            this.checkReceive();
            try {
                if (this.receiveQueue.getIsLocked()) {
                    T t = null;
                    return t;
                }
                this.receiveQueue.setReceiveInProcess(true);
                if (this.noprefetch && this.pendingPrefetch) {
                    this.session.doPrefetch(this);
                    this.pendingPrefetch = false;
                }
                if ((message = (MessageImpl)this.receiveQueue.dequeue()) == null) break;
                try {
                    body = this.returnPayload(message, c);
                }
                catch (MessageFormatException mfe) {
                    if (this.session.getAcknowledgeMode() == 1 || this.session.getAcknowledgeMode() == 3) {
                        this.receiveQueue.enqueueFirst(message);
                        throw mfe;
                    }
                    e = mfe;
                }
                if (!this.isDMQConsumer && message._isExpired()) {
                    if (this.noprefetch) {
                        this.pendingPrefetch = true;
                        this.session.acknowledgeExpired(message, false);
                        continue;
                    }
                    this.session.acknowledgeExpired(message, true);
                    continue;
                }
                if (this.noprefetch) {
                    this.pendingPrefetch = true;
                    this.session.acknowledge(message, false);
                } else {
                    this.session.acknowledge(message, true);
                }
                this.setLastDeliveredID(message.getMessageID(), false);
            }
            finally {
                this.receiveQueue.setReceiveInProcess(false);
                continue;
            }
            break;
        }
        if (e != null) {
            throw e;
        }
        return body;
    }

    private <T> T returnPayload(Message message, Class<T> c) throws JMSException {
        Object body = message.getBody(c);
        if (body == null) {
            String errorString = AdministeredObject.cr.getKString("C4320");
            MessageFormatException jmse = new MessageFormatException(errorString, "C4320");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
        return (T)body;
    }

    @Override
    public <T> T receiveBody(Class<T> c) throws JMSException {
        return this.receiveBody(c, 0L);
    }

    public void close() throws JMSException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean fromSessionClose) throws JMSException {
        int reduceFlowCount = 0;
        boolean mysyncstate = false;
        if (!this.isClosed && Thread.currentThread() != this.session.sessionReader.sessionThread && !fromSessionClose) {
            this.session.prepareToClose(false);
            mysyncstate = true;
        }
        try {
            ReceiveQueue receiveQueue = this.receiveQueue;
            synchronized (receiveQueue) {
                block21: {
                    if (!this.isClosed) break block21;
                    return;
                }
                this.isClosed = true;
            }
            try {
                if (Thread.currentThread() != this.session.sessionReader.sessionThread) {
                    this.session.sessionQueue.stop(true);
                }
                this.stop();
                reduceFlowCount = this.receiveQueue.size();
                this.receiveQueue.close();
                if (!this.session.connection.isBroken() && !this.session.connection.recoverInProcess) {
                    if (this.session.dupsOkAckOnTimeout) {
                        this.session.syncedDupsOkCommitAcknowledge();
                    }
                    if (Thread.currentThread() == this.session.sessionReader.sessionThread) {
                        this.setLastDeliveredID(this.session.sessionReader.currentMessage.getMessageID(), true);
                    }
                    this.removeInterest();
                }
                if (this.session.connection.getBrokerProtocolLevel() < 350 && (this.session.isTransacted || this.session.acknowledgeMode == 2 || this.session.acknowledgeMode == 3)) {
                    this.session.removeUnAckedMessages(this.interestId);
                }
                this.removeUndeliveredMessages();
                if (Thread.currentThread() != this.session.sessionReader.sessionThread) {
                    this.session.sessionQueue.start();
                }
                if (this.debug) {
                    Debug.println("message consumer closed ...");
                    Debug.println(this);
                }
                this.messageListener = null;
                this.isClosed = true;
            }
            finally {
                this.session.resetConnectionFlowControl(reduceFlowCount);
                if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
                    this.logLifeCycle("I301");
                }
            }
        }
        finally {
            if (mysyncstate) {
                this.session.releaseInSyncState();
            }
        }
    }

    protected void removeUndeliveredMessages() throws JMSException {
        int reduceFlowCount = 0;
        Object[] obj = this.session.sessionQueue.toArray();
        int size = obj.length;
        if (size > 0) {
            int i;
            Vector<ReadOnlyPacket> removeq = new Vector<ReadOnlyPacket>();
            long consumerID = this.interestId;
            for (i = 0; i < size; ++i) {
                ReadOnlyPacket pkt = (ReadOnlyPacket)obj[i];
                if (pkt == null || pkt.getConsumerID() != consumerID) continue;
                removeq.addElement(pkt);
            }
            reduceFlowCount = removeq.size();
            for (i = 0; i < removeq.size(); ++i) {
                if (this.debug) {
                    Debug.println("removing msg from sessionq: " + removeq.elementAt(i));
                }
                this.session.sessionQueue.remove(removeq.elementAt(i));
            }
            this.session.resetConnectionFlowControl(reduceFlowCount);
        }
    }

    protected SysMessageID getLastDeliveredID() {
        return this.lastDeliveredID;
    }

    protected boolean getLastDeliveredIDInTransaction() {
        return this.lastDeliveredIDInTransaction;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ MessageConsumerImpl dump ------");
        ps.println("Interest ID: " + this.getInterestId());
        ps.println("is registered: " + this.getIsRegistered());
        ps.println("is durable: " + this.getDurable());
        if (this.durable) {
            ps.println("durableName: " + this.getDurableName());
        }
        if (this.getSharedSubscriptionName() != null) {
            ps.println("sharedSubscriptionName: " + this.getSharedSubscriptionName());
        }
        ps.println("destination: " + this.getDestination());
        ps.println("selector: " + this.messageSelector);
        if (this.receiveQueue != null) {
            this.receiveQueue.dump(ps);
        } else {
            ps.println("receiveQueue is null.");
        }
    }

    @Override
    protected Hashtable getDebugState(boolean verbose) {
        Hashtable ht = super.getDebugState(verbose);
        ht.put("# pending", String.valueOf(this.receiveQueue.size()));
        ht.put("syncReadFlag", String.valueOf(this.syncReadFlag));
        if (verbose) {
            ht.put("receiveQueue", this.receiveQueue);
        }
        return ht;
    }

    public Object TEST_GetAttribute(String name) {
        if (name.startsWith("FlowControl")) {
            return this.session.readChannel.flowControl.TEST_GetAttribute(name, this);
        }
        return null;
    }

    public void logLifeCycle(String key) {
        if (SessionImpl.sessionLogger.isLoggable(Level.FINE)) {
            SessionImpl.sessionLogger.log(Level.FINE, key, this);
        }
    }

    @Override
    public String toString() {
        String destName = null;
        try {
            destName = ((Destination)this.destination).getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.session.toString() + ", ConsumerID=" + this.getInterestId() + ", DestName=" + destName;
    }
}

