/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.protocol.ssl.SSLUtil;
import com.sun.messaging.jms.JMSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;

public class PortMapperClient {
    protected ConnectionImpl connection = null;
    protected PortMapperTable portMapperTable = null;
    protected boolean useMQAddress = false;
    protected MQAddress addr = null;
    private static final Version version = ConnectionImpl.version;
    private boolean debug = Debug.debug;

    public PortMapperClient(ConnectionImpl connection) throws javax.jms.JMSException {
        this.connection = connection;
        this.init();
    }

    public PortMapperClient(MQAddress addr, ConnectionImpl connection) throws javax.jms.JMSException {
        this.addr = addr;
        this.useMQAddress = true;
        this.connection = connection;
        this.init();
    }

    public int getPortForProtocol(String protocol) {
        String type = this.connection.getConnectionType();
        return this.getPort(protocol, type, null);
    }

    public int getPortForService(String protocol, String service) throws javax.jms.JMSException {
        String type = this.connection.getConnectionType();
        int port = this.getPort(protocol, type, service);
        if (port == -1) {
            String errorString = AdministeredObject.cr.getKString("C4098", service);
            JMSException jmse = new JMSException(errorString, "C4098");
            ExceptionHandler.throwJMSException(jmse);
        }
        return port;
    }

    private int getPort(String protocol, String type, String servicename) {
        int port = -1;
        Map table = this.portMapperTable.getServices();
        PortMapperEntry pme2 = null;
        for (PortMapperEntry pme2 : table.values()) {
            if (!pme2.getProtocol().equals(protocol) || !pme2.getType().equals(type)) continue;
            if (servicename == null) {
                port = pme2.getPort();
                break;
            }
            if (!pme2.getName().equals(servicename)) continue;
            port = pme2.getPort();
            break;
        }
        return port;
    }

    protected void init() throws javax.jms.JMSException {
        try {
            this.readBrokerPorts();
            this.checkPacketVersion();
        }
        catch (javax.jms.JMSException jmse) {
            String str = this.getHostName() + ":" + this.getHostPort();
            this.connection.setLastContactedBrokerAddress(str);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void checkPacketVersion() throws javax.jms.JMSException {
        String pktversion = this.portMapperTable.getPacketVersion();
        String clientMVersion = version.getImplementationVersion();
        if (Version.compareVersions(pktversion, "3.0") < 0) {
            String errorString = AdministeredObject.cr.getKString("C4065", clientMVersion, pktversion);
            JMSException jmse = new JMSException(errorString, "C4065");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (Version.compareVersions(pktversion, "3.0.1", false) < 0) {
            ReadOnlyPacket.setDefaultVersion((short)200);
        }
    }

    private String getHostName() {
        if (this.useMQAddress) {
            return this.addr.getHostName();
        }
        return this.connection.getProperty("imqBrokerHostName");
    }

    private boolean getHostPortSSLEnabled() {
        if (this.useMQAddress) {
            return this.addr.isSSLPortMapperScheme();
        }
        return false;
    }

    private boolean getIsHostTrusted() {
        if (this.useMQAddress) {
            return this.addr.getIsSSLHostTrustedSet();
        }
        return false;
    }

    public int getHostPort() {
        if (this.useMQAddress) {
            return this.addr.getPort();
        }
        String prop = this.connection.getProperty("imqBrokerHostPort");
        return Integer.parseInt(prop);
    }

    protected void readBrokerPorts() throws javax.jms.JMSException {
        String host = this.getHostName();
        int port = this.getHostPort();
        boolean ssl = this.getHostPortSSLEnabled();
        boolean isHostTrusted = this.getIsHostTrusted();
        if (this.debug) {
            Debug.println("Connecting to portmapper host: " + host + "  port: " + port + " ssl: " + ssl);
        }
        InputStream is = null;
        OutputStream os = null;
        Socket socket = null;
        try {
            String version = String.valueOf(101) + "\n";
            int timeout = this.connection.getSocketConnectTimeout();
            Integer sotimeout = this.connection.getPortMapperSoTimeout();
            socket = this.makePortMapperClientSocket(host, port, timeout, sotimeout, ssl, isHostTrusted);
            is = socket.getInputStream();
            os = socket.getOutputStream();
            try {
                os.write(version.getBytes());
                os.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.portMapperTable = new PortMapperTable();
            this.portMapperTable.read(is);
            is.close();
            socket.close();
        }
        catch (Exception e) {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(e, host, port);
        }
    }

    private Socket makePortMapperClientSocket(String host, int port, int timeout, Integer sotimeout, boolean ssl, boolean isHostTrusted) throws Exception {
        Socket socket = null;
        if (timeout > 0) {
            ConnectionImpl.getConnectionLogger().fine("Connecting to portmapper with timeout=" + timeout);
            socket = ssl ? SSLUtil.makeSSLSocket(null, 0, isHostTrusted, this.connection.getProperty("imqKeyStore", null), this.connection.getProperty("imqKeyStorePassword", null), ConnectionImpl.connectionLogger, AdministeredObject.cr) : new Socket();
            InetSocketAddress socketAddr = new InetSocketAddress(host, port);
            socket.connect(socketAddr, timeout);
            socket.setSoTimeout(0);
        } else {
            ConnectionImpl.getConnectionLogger().fine("Connecting to portmapper without timeout ...");
            socket = ssl ? SSLUtil.makeSSLSocket(host, port, isHostTrusted, this.connection.getProperty("imqKeyStore", null), this.connection.getProperty("imqKeyStorePassword", null), ConnectionImpl.connectionLogger, AdministeredObject.cr) : new Socket(host, port);
        }
        if (sotimeout != null) {
            socket.setSoTimeout(sotimeout);
        }
        ConnectionImpl.getConnectionLogger().fine("socket connected., host=" + host + ", port=" + port);
        return socket;
    }

    public static void main(String[] args) {
        try {
            PortMapperClient pmc = new PortMapperClient(null);
            String protocol = "tcp";
            String prop = System.getProperty("protocol");
            if (prop != null) {
                protocol = prop;
            }
            int port = pmc.getPortForProtocol(protocol);
            if (Debug.debug) {
                Debug.println("port = " + port);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }
}

