/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

public class DestType {
    public static final int DEST_TYPE_QUEUE = 1;
    public static final int DEST_TYPE_TOPIC = 2;
    public static final int DEST_TEMP = 16;
    public static final int DEST_AUTO = 32;
    public static final int DEST_INTERNAL = 64;
    public static final int DEST_ADMIN = 128;
    public static final int DEST_DMQ = 4096;
    public static final int DEST_LOCAL = 8192;
    public static final int DEST_FLAVOR_SINGLE = 256;
    public static final int DEST_FLAVOR_RROBIN = 512;
    public static final int DEST_FLAVOR_FAILOVER = 1024;
    public static final String INTERNAL_DEST_PREFIX = "mq.";
    public static final String QUEUESTR = "queue";
    public static final String TOPICSTR = "topic";

    public static String queueOrTopic(int type) {
        if ((type & 0x10) == 16) {
            return null;
        }
        if ((type & 1) == 1) {
            return DestType.toString(1);
        }
        if ((type & 2) == 2) {
            return DestType.toString(2);
        }
        return null;
    }

    public static boolean isQueueStr(String queueOrTopic) {
        if (queueOrTopic == null) {
            return false;
        }
        return queueOrTopic.equals(QUEUESTR);
    }

    public static boolean isQueue(int mask) {
        return (mask & 1) == 1;
    }

    public static boolean isTopic(int mask) {
        return (mask & 2) == 2;
    }

    public static boolean isTemporary(int mask) {
        return (mask & 0x10) == 16;
    }

    public static boolean isLocal(int mask) {
        return (mask & 0x2000) == 8192;
    }

    public static boolean isAutoCreated(int mask) {
        return (mask & 0x20) == 32;
    }

    public static boolean isAdmin(int mask) {
        return (mask & 0x80) == 128;
    }

    public static boolean isInternal(int mask) {
        return (mask & 0x40) == 64;
    }

    public static boolean isDMQ(int mask) {
        return (mask & 0x1000) == 4096;
    }

    public static boolean destNameIsInternal(String destName) {
        return destName != null && destName.startsWith(INTERNAL_DEST_PREFIX);
    }

    public static boolean destNameIsInternalLogging(String destName) {
        return destName != null && destName.startsWith("mq.log.broker");
    }

    public static boolean isSingle(int mask) {
        return (mask & 0x100) == 256;
    }

    public static boolean isRRobin(int mask) {
        return (mask & 0x200) == 512;
    }

    public static boolean isFailover(int mask) {
        return (mask & 0x400) == 1024;
    }

    public static String toString(int mask) {
        StringBuffer s = new StringBuffer();
        if (DestType.isQueue(mask)) {
            s.append(QUEUESTR);
        } else if (DestType.isTopic(mask)) {
            s.append(TOPICSTR);
        } else {
            s.append("?????");
        }
        if (DestType.isTemporary(mask)) {
            s.append(":temporary");
        }
        if (DestType.isAutoCreated(mask)) {
            s.append(":autocreated");
        }
        if (DestType.isInternal(mask)) {
            s.append(":internal");
        }
        if (DestType.isAdmin(mask)) {
            s.append(":admin");
        }
        if (DestType.isLocal(mask)) {
            s.append(":local");
        }
        if (DestType.isSingle(mask)) {
            s.append(":single");
        } else if (DestType.isRRobin(mask)) {
            s.append(":roundrobin");
        } else if (DestType.isFailover(mask)) {
            s.append(":failover");
        }
        return s.toString();
    }
}

