/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.DestinationName;
import com.sun.messaging.jms.ra.GenericConnectionFactoryProperties;
import com.sun.messaging.jms.ra.ManagedConnectionFactory;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.util.CustomTokenizer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapterAssociation;

public class ActivationSpec
implements javax.resource.spi.ActivationSpec,
ResourceAdapterAssociation,
Serializable,
GenericConnectionFactoryProperties {
    private static final String AUTOACKNOWLEDGE = "Auto-acknowledge";
    private static final String DUPSOKACKNOWLEDGE = "Dups-ok-acknowledge";
    private static final String NOACKNOWLEDGE = "No-acknowledge";
    private static final String DURABLE = "Durable";
    private static final String NONDURABLE = "NonDurable";
    private static final String INSTANCE = "Instance";
    private static final String CLUSTER = "Cluster";
    private static final String QUEUE = "javax.jms.Queue";
    private static final String TOPIC = "javax.jms.Topic";
    private static final String _className = "com.sun.messaging.jms.ra.ActivationSpec";
    protected static final String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final String _lgrMIDPrefix = "MQJMSRA_AS";
    protected static final String _lgrMID_EET = "MQJMSRA_AS1001: ";
    protected static final String _lgrMID_INF = "MQJMSRA_AS1101: ";
    protected static final String _lgrMID_WRN = "MQJMSRA_AS2001: ";
    protected static final String _lgrMID_ERR = "MQJMSRA_AS3001: ";
    protected static final String _lgrMID_EXC = "MQJMSRA_AS4001: ";
    private ResourceAdapter ra = null;
    private ManagedConnectionFactory mcf;
    private String destinationType = null;
    private String destination = null;
    private String messageSelector = null;
    private String acknowledgeMode = "Auto-acknowledge";
    private String subscriptionDurability = "NonDurable";
    private String clientId = null;
    private String subscriptionName = null;
    private String subscriptionScope = null;
    private String connectionFactoryJNDIName;
    private int endpointPoolMaxSize = 15;
    private int endpointPoolSteadySize = 10;
    private int endpointPoolResizeCount = 1;
    private int endpointPoolResizeTimeout = 5;
    private int endpointExceptionRedeliveryAttempts = 6;
    private int endpointExceptionRedeliveryInterval = 500;
    private boolean sendUndeliverableMsgsToDMQ = true;
    private String addressList = null;
    private boolean addressListSet = false;
    private String addressListBehavior = null;
    private String customAcknowledgeMode = null;
    private String userName = null;
    private String password = null;
    private int addressListIterations;
    private boolean addressListIterationsSet = false;
    private int reconnectAttempts;
    private boolean reconnectAttemptsSet = false;
    private int reconnectInterval;
    private boolean reconnectIntervalSet = false;
    private String destinationLookup;
    private String connectionFactoryLookup;
    private transient ClassLoader contextClassLoader = null;
    private String mdbName = null;
    private String groupName = null;
    private String raUID = null;
    private boolean inClusteredContainer = false;
    private boolean useSharedSubscriptionInClusteredContainer = true;
    private boolean deliverySerial = false;
    private String options;

    public ActivationSpec() {
        _loggerIM.entering(_className, "constructor()");
    }

    public void validate() throws InvalidPropertyException {
        _loggerIM.entering(_className, "validate()", this);
        if (this.destinationLookup == null && !DestinationName.isSyntaxValid(this.destination)) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:Invalid destination name=" + this.destination);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (QUEUE.equals(this.destinationType) && this.subscriptionScope != null) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:subscriptionScope must not be set if destinationType is javax.jms.Queue");
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (TOPIC.equals(this.destinationType)) {
            if (this.subscriptionScope != null && this.clientId != null) {
                InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:clientId must not be set if subscriptionScope is set");
                _loggerIM.throwing(_className, "validate()", ipe);
                throw ipe;
            }
            if (this.subscriptionDurability.equals(DURABLE) && (this.subscriptionName == null || "".equals(this.subscriptionName))) {
                InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:subscriptionName must be non-null\n\tsubscriptionName=" + this.subscriptionName);
                _loggerIM.throwing(_className, "validate()", ipe);
                throw ipe;
            }
        }
        if (this.endpointExceptionRedeliveryInterval < 1) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointExceptionRedeliveryInterval must be greater than 0\nInvalid value=" + this.endpointExceptionRedeliveryInterval);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (this.endpointExceptionRedeliveryAttempts < 0) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointExceptionRedeliveryAttempts must be greater than or equal to 0\nInvalid value=" + this.endpointExceptionRedeliveryAttempts);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (this.endpointPoolResizeTimeout < 1) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolResizeTimeout must be greater than 0\nInvalid value=" + this.endpointPoolResizeTimeout);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (this.endpointPoolResizeCount < 1) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolResizeCount must be greater than 0\nInvalid value=" + this.endpointPoolResizeCount);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (this.endpointPoolMaxSize < 1) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolMaxSize must be greater than 0\nInvalid value=" + this.endpointPoolMaxSize);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (this.endpointPoolSteadySize < 0) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolSteadySize must be greater than or equal to 0\nInvalid value=" + this.endpointPoolSteadySize);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        if (this.endpointPoolSteadySize > this.endpointPoolMaxSize) {
            InvalidPropertyException ipe = new InvalidPropertyException("MQJMSRA_AS4001: validate:\nendpointPoolSteadySize must be less than or equal to endpointPoolMaxSize\nendpointPoolSteadySize value=" + this.endpointPoolSteadySize + "\nendpointPoolMaxSize value=" + this.endpointPoolSteadySize);
            _loggerIM.throwing(_className, "validate()", ipe);
            throw ipe;
        }
        _loggerIM.exiting(_className, "validate()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceAdapter(javax.resource.spi.ResourceAdapter ra) throws ResourceException {
        _loggerIM.entering(_className, "setResourceAdapter()", ra);
        ActivationSpec activationSpec = this;
        synchronized (activationSpec) {
            if (this.ra == null) {
                if (!(ra instanceof ResourceAdapter)) {
                    ResourceException rae = new ResourceException("MQJMSRA_AS4001: setResourceAdapter:Incompatible ResourceAdapter class=" + ra.getClass());
                    _loggerIM.warning(rae.getMessage());
                    _loggerIM.throwing(_className, "setResourceAdapter()", rae);
                    throw rae;
                }
            } else {
                ResourceException rae = new ResourceException("MQJMSRA_AS4001: setResourceAdapter:Illegal to re-associate ResourceAdapter");
                _loggerIM.warning(rae.getMessage());
                _loggerIM.throwing(_className, "setResourceAdapter()", rae);
                throw rae;
            }
            this.ra = (ResourceAdapter)ra;
            this.groupName = this.ra.getGroupName();
            this.inClusteredContainer = this.ra.getInClusteredContainer();
            this.raUID = this.ra._getRAUID();
        }
        _loggerIM.exiting(_className, "setResourceAdapter()");
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        _loggerIM.entering(_className, "getResourceAdapter()");
        return this.ra;
    }

    public void setMCF(ManagedConnectionFactory mcf) {
        this.mcf = mcf;
    }

    public void setDestinationType(String destinationType) {
        _loggerIM.entering(_className, "setDestinationType()", destinationType);
        if (!QUEUE.equals(destinationType) && !TOPIC.equals(destinationType)) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setDestinationType:Invalid destinationType=" + destinationType);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setDestinationType()", iae);
            throw iae;
        }
        this.destinationType = destinationType;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestination(String destination) {
        _loggerIM.entering(_className, "setDestination()", destination);
        if (!DestinationName.isSyntaxValid(destination)) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setDestination:Invalid destination name=" + destination);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setDestination()", iae);
            throw iae;
        }
        this.destination = destination;
    }

    public String getDestination() {
        _loggerIM.entering(_className, "getDestination()", this.destination);
        return this.destination;
    }

    public void setMessageSelector(String messageSelector) {
        _loggerIM.entering(_className, "setMessageSelector()", messageSelector);
        this.messageSelector = messageSelector;
    }

    public String getMessageSelector() {
        _loggerIM.entering(_className, "getMessageSelector()", this.messageSelector);
        return this.messageSelector;
    }

    public void setAcknowledgeMode(String acknowledgeMode) {
        _loggerIM.entering(_className, "setAcknowledgeMode()", acknowledgeMode);
        if (!AUTOACKNOWLEDGE.equals(acknowledgeMode) && !DUPSOKACKNOWLEDGE.equals(acknowledgeMode)) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setAcknowledgeMode:Invalid acknowledgeMode=" + acknowledgeMode);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setAcknowledgeMode()", iae);
            throw iae;
        }
        this.acknowledgeMode = acknowledgeMode;
    }

    public String getAcknowledgeMode() {
        _loggerIM.entering(_className, "getAcknowledgeMode()", this.acknowledgeMode);
        return this.acknowledgeMode;
    }

    public void setCustomAcknowledgeMode(String customAcknowledgeMode) {
        _loggerIM.entering(_className, "setCustomAcknowledgeMode()", customAcknowledgeMode);
        if (!NOACKNOWLEDGE.equals(customAcknowledgeMode)) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setCustomAcknowledgeMode:Invalid customAcknowledgeMode=" + customAcknowledgeMode);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setCustomAcknowledgeMode()", iae);
            throw iae;
        }
        this.customAcknowledgeMode = customAcknowledgeMode;
    }

    public String getCustomAcknowledgeMode() {
        _loggerIM.entering(_className, "getCustomAcknowledgeMode()", this.customAcknowledgeMode);
        return this.customAcknowledgeMode;
    }

    public void setSubscriptionDurability(String subscriptionDurability) {
        _loggerIM.entering(_className, "setSubscriptionDurability()", subscriptionDurability);
        if (!DURABLE.equals(subscriptionDurability) && !NONDURABLE.equals(subscriptionDurability)) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setSubscriptionDurability:Invalid subscriptionDurability=" + subscriptionDurability);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setSubscriptionDurability()", iae);
            throw iae;
        }
        this.subscriptionDurability = subscriptionDurability;
    }

    public String getSubscriptionDurability() {
        _loggerIM.entering(_className, "getSubscriptionDurability()", this.subscriptionDurability);
        return this.subscriptionDurability;
    }

    @Override
    public void setClientId(String clientId) {
        _loggerIM.entering(_className, "setClientId()", clientId);
        this.clientId = clientId;
    }

    @Override
    public String getClientId() {
        _loggerIM.entering(_className, "getClientId()", this.clientId);
        return this.clientId;
    }

    public void setSubscriptionName(String subscriptionName) {
        _loggerIM.entering(_className, "setSubscriptionName()", subscriptionName);
        this.subscriptionName = subscriptionName;
    }

    public String getSubscriptionName() {
        _loggerIM.entering(_className, "getSubscriptionName()", this.subscriptionName);
        return this.subscriptionName;
    }

    public String getSubscriptionScope() {
        _loggerIM.entering(_className, "getSubscriptionScope()", this.subscriptionScope);
        return this.subscriptionScope;
    }

    public void _setConnectionFactoryJNDIName(String connectionFactoryJNDIName) {
        _loggerIM.entering(_className, "_setConnectionFactoryJNDIName()", connectionFactoryJNDIName);
        this.connectionFactoryJNDIName = connectionFactoryJNDIName;
    }

    public String _getConnectionFactoryJNDIName() {
        _loggerIM.entering(_className, "_getConnectionFactoryJNDIName()", this.connectionFactoryJNDIName);
        return this.connectionFactoryJNDIName;
    }

    public void setEndpointPoolMaxSize(int endpointPoolMaxSize) {
        _loggerIM.entering(_className, "setEndpointPoolMaxSize()", Integer.toString(endpointPoolMaxSize));
        if (endpointPoolMaxSize < 1) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolMaxSize:Value must be greater than 0Invalid value=" + endpointPoolMaxSize);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolMaxSize()", iae);
            throw iae;
        }
        this.endpointPoolMaxSize = endpointPoolMaxSize;
    }

    public int getEndpointPoolMaxSize() {
        _loggerIM.entering(_className, "getEndpointPoolMaxSize()", Integer.toString(this.endpointPoolMaxSize));
        return this.endpointPoolMaxSize;
    }

    public void setEndpointPoolSteadySize(int endpointPoolSteadySize) {
        _loggerIM.entering(_className, "setEndpointPoolSteadySize()", Integer.toString(endpointPoolSteadySize));
        if (endpointPoolSteadySize < 0) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolSteadySize:Value must be greater than or equal to 0Invalid value=" + endpointPoolSteadySize);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolSteadySize()", iae);
            throw iae;
        }
        this.endpointPoolSteadySize = endpointPoolSteadySize;
    }

    public int getEndpointPoolSteadySize() {
        _loggerIM.entering(_className, "getEndpointPoolSteadySize()", Integer.toString(this.endpointPoolSteadySize));
        return this.endpointPoolSteadySize;
    }

    public void setEndpointPoolResizeCount(int endpointPoolResizeCount) {
        _loggerIM.entering(_className, "setEndpointPoolResizeCount()", Integer.toString(endpointPoolResizeCount));
        if (endpointPoolResizeCount < 1) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolResizeCount:Value must be greater than 0:Invalid value=" + endpointPoolResizeCount);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolResizeCount()", iae);
            throw iae;
        }
        this.endpointPoolResizeCount = endpointPoolResizeCount;
    }

    public int getEndpointPoolResizeCount() {
        _loggerIM.entering(_className, "getEndpointPoolResizeCount()", Integer.toString(this.endpointPoolResizeCount));
        return this.endpointPoolResizeCount;
    }

    public void setEndpointPoolResizeTimeout(int endpointPoolResizeTimeout) {
        _loggerIM.entering(_className, "setEndpointPoolResizeTimeout()", Integer.toString(endpointPoolResizeTimeout));
        if (endpointPoolResizeTimeout < 1) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointPoolResizeTimeout:Value must be greater than 0:Invalid value=" + endpointPoolResizeTimeout);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setEndpointPoolResizeTimeout()", iae);
            throw iae;
        }
        this.endpointPoolResizeTimeout = endpointPoolResizeTimeout;
    }

    public int getEndpointPoolResizeTimeout() {
        _loggerIM.entering(_className, "getEndpointPoolResizeTimeout()", Integer.toString(this.endpointPoolResizeTimeout));
        return this.endpointPoolResizeTimeout;
    }

    public void setEndpointExceptionRedeliveryAttempts(int endpointExceptionRedeliveryAttempts) {
        _loggerIM.entering(_className, "setEndpointExceptionRedeliveryAttempts()", Integer.toString(endpointExceptionRedeliveryAttempts));
        if (endpointExceptionRedeliveryAttempts < 0) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointExceptionRedeliveryAttempts:Value must be greater than or equal to 0:Invalid value=" + endpointExceptionRedeliveryAttempts);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setEndpointExceptionRedeliveryAttempts()", iae);
            throw iae;
        }
        this.endpointExceptionRedeliveryAttempts = endpointExceptionRedeliveryAttempts;
    }

    public int getEndpointExceptionRedeliveryAttempts() {
        _loggerIM.entering(_className, "getEndpointExceptionRedeliveryAttempts()", Integer.toString(this.endpointExceptionRedeliveryAttempts));
        return this.endpointExceptionRedeliveryAttempts;
    }

    public void setEndpointExceptionRedeliveryInterval(int endpointExceptionRedeliveryInterval) {
        _loggerIM.entering(_className, "setEndpointExceptionRedeliveryInterval()", Integer.toString(endpointExceptionRedeliveryInterval));
        if (endpointExceptionRedeliveryInterval < 1) {
            IllegalArgumentException iae = new IllegalArgumentException("MQJMSRA_AS4001: setEndpointExceptionRedeliveryInterval:Value must be greater than 0:Invalid value=" + endpointExceptionRedeliveryInterval);
            _loggerIM.warning(iae.getMessage());
            _loggerIM.throwing(_className, "setEndpointExceptionRedeliveryInterval()", iae);
            throw iae;
        }
        this.endpointExceptionRedeliveryInterval = endpointExceptionRedeliveryInterval;
    }

    public int getEndpointExceptionRedeliveryInterval() {
        _loggerIM.entering(_className, "getEndpointExceptionRedeliveryInterval()", Integer.toString(this.endpointExceptionRedeliveryInterval));
        return this.endpointExceptionRedeliveryInterval;
    }

    public void setSendUndeliverableMsgsToDMQ(boolean sendUndeliverableMsgsToDMQ) {
        _loggerIM.entering(_className, "setSendUndeliverableMsgsToDMQ()", Boolean.toString(sendUndeliverableMsgsToDMQ));
        this.sendUndeliverableMsgsToDMQ = sendUndeliverableMsgsToDMQ;
    }

    public boolean getSendUndeliverableMsgsToDMQ() {
        _loggerIM.entering(_className, "getSendUndeliverableMsgsToDMQ()", Boolean.toString(this.sendUndeliverableMsgsToDMQ));
        return this.sendUndeliverableMsgsToDMQ;
    }

    public void setContextClassLoader(ClassLoader contextClassLoader) {
        _loggerIM.entering(_className, "setContextClassLoader()", contextClassLoader);
        this.contextClassLoader = contextClassLoader;
    }

    public ClassLoader getContextClassLoader() {
        _loggerIM.entering(_className, "getContextClassLoader()", this.contextClassLoader);
        return this.contextClassLoader;
    }

    @Override
    public void setAddressList(String addressList) {
        _loggerIM.entering(_className, "setAddressList()", addressList);
        this.addressList = addressList;
        if (addressList != null && !"".equals(addressList)) {
            this.addressListSet = true;
        }
    }

    @Override
    public String getAddressList() {
        _loggerIM.entering(_className, "getAddressList()", this.addressList);
        return this.addressList;
    }

    @Override
    public void setAddressListBehavior(String addressListBehavior) {
        _loggerIM.entering(_className, "setAddressListBehavior()", addressListBehavior);
        this.addressListBehavior = addressListBehavior;
    }

    @Override
    public String getAddressListBehavior() {
        _loggerIM.entering(_className, "getAddressListBehavior()", this.addressListBehavior);
        if (this.addressListBehavior != null) {
            return this.addressListBehavior;
        }
        if (this.mcf != null) {
            return this.mcf.getAddressListBehavior();
        }
        if (this.ra != null) {
            return this.ra.getAddressListBehavior();
        }
        return null;
    }

    public void setMdbName(String mdbName) {
        _loggerIM.entering(_className, "setMdbName()", mdbName);
        this.mdbName = mdbName;
    }

    public String getMdbName() {
        _loggerIM.entering(_className, "getMdbName()", this.mdbName);
        return this.mdbName;
    }

    @Override
    public void setUserName(String userName) {
        _loggerIM.entering(_className, "setUserName()", userName);
        this.userName = userName;
    }

    @Override
    public String getUserName() {
        _loggerIM.entering(_className, "getUserName()", this.userName);
        if (this.userName != null) {
            return this.userName;
        }
        if (this.mcf != null && this.mcf.getUserName() != null) {
            return this.mcf.getUserName();
        }
        if (this.ra != null) {
            return this.ra.getUserName();
        }
        return null;
    }

    @Override
    public void setPassword(String password) {
        _loggerIM.entering(_className, "setPassword()");
        this.password = password;
    }

    @Override
    public String getPassword() {
        _loggerIM.entering(_className, "getPassword()");
        if (this.password != null) {
            return this.password;
        }
        if (this.mcf != null && this.mcf.getPassword() != null) {
            return this.mcf.getPassword();
        }
        if (this.ra != null) {
            return this.ra.getPassword();
        }
        return null;
    }

    @Override
    public void setAddressListIterations(int addressListIterations) {
        _loggerIM.entering(_className, "setAddressListIterations()");
        this.addressListIterations = addressListIterations;
        this.addressListIterationsSet = true;
    }

    @Override
    public int getAddressListIterations() {
        if (this.addressListIterationsSet) {
            return this.addressListIterations;
        }
        if (this.mcf != null) {
            return this.mcf.getAddressListIterations();
        }
        return this.ra.getAddressListIterations();
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) {
        _loggerIM.entering(_className, "setReconnectAttempts()");
        this.reconnectAttempts = reconnectAttempts;
        this.reconnectAttemptsSet = true;
    }

    @Override
    public int getReconnectAttempts() {
        if (this.reconnectAttemptsSet) {
            return this.reconnectAttempts;
        }
        if (this.mcf != null) {
            return this.mcf.getReconnectAttempts();
        }
        return this.ra.getReconnectAttempts();
    }

    @Override
    public void setReconnectInterval(int reconnectInterval) {
        _loggerIM.entering(_className, "setReconnectInterval()");
        this.reconnectInterval = reconnectInterval;
        this.reconnectIntervalSet = true;
    }

    @Override
    public int getReconnectInterval() {
        if (this.reconnectIntervalSet) {
            return this.reconnectInterval;
        }
        if (this.mcf != null) {
            return this.mcf.getReconnectInterval();
        }
        return this.ra.getReconnectInterval();
    }

    @Override
    public void setReconnectEnabled(boolean flag) {
        _loggerIM.warning("MQJMSRA_AS2001: Property reconnectEnabled cannot be set on con.sun.messaging.jms.ra.ActivationSpec, ignoring specified value");
    }

    @Override
    public boolean getReconnectEnabled() {
        return false;
    }

    public String getDestinationLookup() {
        return this.destinationLookup;
    }

    public void setDestinationLookup(String destinationLookup) {
        this.destinationLookup = destinationLookup;
    }

    public String getConnectionFactoryLookup() {
        return this.connectionFactoryLookup;
    }

    public void setConnectionFactoryLookup(String connectionFactoryLookup) {
        this.connectionFactoryLookup = connectionFactoryLookup;
    }

    @Override
    public void setOptions(String props) {
        this.options = props;
    }

    @Override
    public String getOptions() {
        String mergedOptions = null;
        if (this.options != null) {
            mergedOptions = this.mcf != null && this.mcf.getOptions() != null ? this.mergeOptions(this.options, this.mcf.getOptions()) : this.options;
        } else if (this.mcf != null && this.mcf.getOptions() != null) {
            mergedOptions = this.mcf.getOptions();
        }
        return mergedOptions;
    }

    private String mergeOptions(String options, String mcfOptions) {
        Hashtable<String, String> props = null;
        try {
            props = CustomTokenizer.parseToProperties(options);
        }
        catch (InvalidPropertyException ipe) {
            String message = "ActivationSpec property options has invalid value " + options + " error is: " + ipe.getMessage();
            _loggerIM.warning(_lgrMID_WRN + message);
            IllegalArgumentException iae = new IllegalArgumentException(_lgrMID_EXC + message);
            iae.initCause(ipe);
            throw iae;
        }
        Hashtable<String, String> mcfProps = null;
        try {
            if (this.mcf != null) {
                mcfProps = CustomTokenizer.parseToProperties(this.mcf.getOptions());
            }
        }
        catch (InvalidPropertyException ipe) {
            String message = "ManagedConnectionFactory property options has invalid value " + this.mcf.getOptions() + " error is: " + ipe.getMessage();
            _loggerIM.warning(_lgrMID_WRN + message);
            IllegalArgumentException iae = new IllegalArgumentException(_lgrMID_EXC + message);
            iae.initCause(ipe);
            throw iae;
        }
        Hashtable<String, String> mergedProps = new Hashtable<String, String>();
        mergedProps.putAll(mcfProps);
        Enumeration<String> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            mergedProps.put(key, props.get(key));
        }
        StringBuffer mergedOptions = new StringBuffer();
        keys = mergedProps.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            mergedOptions.append(",").append(key).append("=").append((String)mergedProps.get(key));
        }
        return mergedOptions.substring(1);
    }

    protected String _AddressList() {
        if (this.addressList != null) {
            return this.addressList;
        }
        if (this.mcf != null) {
            return this.mcf.getAddressList();
        }
        if (this.ra != null) {
            return this.ra._getEffectiveConnectionURL();
        }
        return "localhost";
    }

    public void _setDeliverySerial(boolean mode) {
        this.deliverySerial = mode;
    }

    protected boolean _getDeliverySerial() {
        return this.deliverySerial;
    }

    protected boolean _deliverySerial() {
        return this.deliverySerial;
    }

    protected String _getGroupName() {
        return this.groupName;
    }

    protected void _setGroupName(String groupName) {
        this.groupName = groupName;
    }

    protected String _getRAUID() {
        return this.raUID;
    }

    protected void _setRAUID(String raUID) {
        this.raUID = raUID;
    }

    protected void _setInClusteredContainer(boolean inClusteredContainer) {
        this.inClusteredContainer = inClusteredContainer;
    }

    protected boolean _isInClusteredContainerSet() {
        return this.inClusteredContainer;
    }

    protected boolean _isNoAckDeliverySet() {
        return NOACKNOWLEDGE.equals(this.customAcknowledgeMode);
    }

    protected boolean _isDurableSet() {
        return DURABLE.equals(this.subscriptionDurability);
    }

    protected boolean _isDestTypeQueueSet() {
        return QUEUE.equals(this.destinationType);
    }

    protected boolean _isDestTypeTopicSet() {
        return TOPIC.equals(this.destinationType);
    }

    protected boolean useRADirect() {
        if (this.ra != null) {
            return this.ra._isRADirect() && !this.addressListSet;
        }
        return false;
    }

    public String toString() {
        return "ActvationSpec configuration=\n\tDestinationType                     =" + this.destinationType + "\n" + "\tDestination                         =" + this.destination + "\n" + "\tDestinationLookup                   =" + this.destinationLookup + "\n" + "\tConnectionFactoryLookup             =" + this.connectionFactoryLookup + "\n" + "\tMessageSelector                     =" + this.messageSelector + "\n" + "\tAcknowledgeMode                     =" + this.acknowledgeMode + "\n" + "\tSubscriptionDurability              =" + this.subscriptionDurability + "\n" + "\tuseSharedSubscriptionInClusteredContainer=" + this.useSharedSubscriptionInClusteredContainer + "\n" + "\tClientId                            =" + this.clientId + "\n" + "\tSubscriptionName                    =" + this.subscriptionName + "\n" + "\tEndpointPoolMaxSize                 =" + this.endpointPoolMaxSize + "\n" + "\tEndpointPoolSteadySize              =" + this.endpointPoolSteadySize + "\n" + "\tEndpointPoolResizeCount             =" + this.endpointPoolResizeCount + "\n" + "\tEndpointPoolResizeTimeout           =" + this.endpointPoolResizeTimeout + "\n" + "\tEndpointExceptionRedeliveryAttempts =" + this.endpointExceptionRedeliveryAttempts + "\n" + "\tEndpointExceptionRedeliveryInterval =" + this.endpointExceptionRedeliveryInterval + "\n" + "\tSendUndeliverableMsgsToDMQ          =" + this.sendUndeliverableMsgsToDMQ + "\n" + "\tGroupName                           =" + this.groupName + "\n" + "\tRAUID                               =" + this.raUID + "\n" + "\tInClusteredContainer                =" + this.inClusteredContainer + "\n" + "\tMdbName                             =" + this.mdbName + "\n" + "\tUserName                            =" + this.userName + "\n" + "\tAddressList (configured)            =" + this.addressList + "\n" + "\tAddressList (in effect)             =" + this._AddressList() + "\n" + "\taddressListBehavior (configured)    =" + this.addressListBehavior + "\n" + "\taddressListBehavior (in effect)     =" + this.getAddressListBehavior() + "\n" + "\taddressListIterations (configured)  =" + this.addressListIterations + "\n" + "\taddressListIterations (in effect)   =" + this.getAddressListIterations() + "\n" + "\treconnectAttempts (configured)      =" + this.reconnectAttempts + "\n" + "\treconnectAttempts (in effect)       =" + this.getReconnectAttempts() + "\n" + "\treconnectInterval (configured)      =" + this.reconnectInterval + "\n" + "\treconnectInterval  (in effect)      =" + this.getReconnectInterval() + "\n" + "\toptions  (configured)               =" + this.options + "\n" + "\toptions  (in effec)                 =" + this.getOptions() + "\n";
    }

    public boolean isUseSharedSubscriptionInClusteredContainer() {
        return this.useSharedSubscriptionInClusteredContainer;
    }

    public void setUseSharedSubscriptionInClusteredContainer(boolean useSharedSubscriptionInClusteredContainer) {
        this.useSharedSubscriptionInClusteredContainer = useSharedSubscriptionInClusteredContainer;
    }
}

