/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.ManagedConnectionFactory;

public class ConnectionRequestInfo
implements javax.resource.spi.ConnectionRequestInfo {
    private ManagedConnectionFactory mcf = null;
    private String userName = null;
    private String password = null;
    private ConnectionType connectionType;
    private transient int criId = ConnectionRequestInfo.incrementIdCounter();
    private static int idCounter = 0;

    private static synchronized int incrementIdCounter() {
        return ++idCounter;
    }

    public ConnectionRequestInfo(ManagedConnectionFactory mcf, String userName, String password, ConnectionType connectionType) {
        this.mcf = mcf;
        this.userName = userName;
        this.password = password;
        this.connectionType = connectionType;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ConnectionRequestInfo) {
            ConnectionRequestInfo otherCRI = (ConnectionRequestInfo)other;
            String oUserName = otherCRI.getUserName();
            String oPassword = otherCRI.getPassword();
            ConnectionType oConnectionType = otherCRI.getConnectionType();
            ManagedConnectionFactory oMCF = otherCRI.getMCF();
            return (oUserName != null && oUserName.equals(this.userName) || oUserName == null && this.userName == null) && (oPassword != null && oPassword.equals(this.password) || oPassword == null && this.password == null) && oConnectionType == this.connectionType && (oMCF != null && oMCF.equals(this.mcf) || oMCF == null && this.mcf == null);
        }
        return false;
    }

    public int hashCode() {
        String hashStr = "" + this.userName + this.password + this.criId + this.connectionType.ordinal();
        return hashStr.hashCode();
    }

    public ManagedConnectionFactory getMCF() {
        return this.mcf;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getCRIId() {
        return this.criId;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public String toString() {
        return "ConnectionRequestInfo configuration=\n\tcriId                               =" + this.criId + "\n" + "\tUserName                            =" + this.userName + "\n" + "\tPassword                            =" + this.password + "\n" + "\tconnectionType                      =" + (Object)((Object)this.connectionType) + "\n" + "\tMCF configuration                   =" + (this.mcf != null ? this.mcf.toString() : "NULL") + "\n";
    }

    public static enum ConnectionType {
        UNIFIED_CONNECTION,
        QUEUE_CONNECTION,
        TOPIC_CONNECTION;

    }
}

