/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.ManagedConnection;
import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.LocalTransaction;

public class DirectLocalTransaction
implements LocalTransaction {
    private ManagedConnection mc = null;
    private DirectConnection dc = null;
    private long transactionID = -1L;
    protected boolean started = false;
    protected boolean active = false;

    public DirectLocalTransaction(ManagedConnection mc, DirectConnection dc) {
        this.mc = mc;
        this.dc = dc;
    }

    public synchronized void begin() throws ResourceException {
        try {
            if (this.dc.isClosed()) {
                EISSystemException re = new EISSystemException("MQRA:LT:startTransaction exception:Connection is closed");
                throw re;
            }
            this.transactionID = this.dc._startTransaction("DirectLocalTransaction.begin()");
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("MQRA:LT:startTransaction exception:" + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
        this.started = true;
        this.active = true;
        this.mc.setLTActive(true);
    }

    public synchronized void commit() throws ResourceException {
        block6: {
            try {
                if (!this.dc.isClosed()) {
                    this.dc._commitTransaction("DirectLocalTransaction.commit()", this.transactionID);
                    break block6;
                }
                EISSystemException re = new EISSystemException("MQRA:LT:commitTransaction exception:Connection is closed");
                throw re;
            }
            catch (Exception ex) {
                EISSystemException re = new EISSystemException("MQRA:LT:commit exception:" + ex.getMessage());
                re.initCause((Throwable)ex);
                throw re;
            }
            finally {
                this.mc.setLTActive(false);
                this.started = false;
                this.active = false;
            }
        }
    }

    public synchronized void rollback() throws ResourceException {
        block6: {
            try {
                if (!this.dc.isClosed()) {
                    this.dc._rollbackTransaction("DirectLocalTransaction.rollback()", this.transactionID);
                    break block6;
                }
                EISSystemException re = new EISSystemException("MQRA:LT:rillbackTransaction exception:Connection is closed");
                throw re;
            }
            catch (Exception ex) {
                EISSystemException re = new EISSystemException("MQRA:LT:rollback exception:" + ex.getMessage());
                re.initCause((Throwable)ex);
                throw re;
            }
            finally {
                this.mc.setLTActive(false);
                this.started = false;
                this.active = false;
            }
        }
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public synchronized boolean started() {
        return this.started;
    }

    public synchronized boolean isActive() {
        return this.active;
    }
}

