/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceForRA;
import com.sun.messaging.jms.ra.ActivationSpec;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.EndpointConsumer;
import com.sun.messaging.jms.ra.OnMessageRunnerPool;
import com.sun.messaging.jms.ra.api.JMSRAOnMessageRunner;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.StreamMessage;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;

public class OnMessageRunner
implements Work,
JMSRAOnMessageRunner {
    protected int omrId;
    private Message message;
    private OnMessageRunnerPool omrPool;
    MessageImpl mqmsg;
    SessionImpl mqsess;
    private DirectPacket dpMsg = null;
    private DirectSession ds = null;
    private MessageEndpoint msgEndpoint = null;
    private MessageEndpointFactory epFactory;
    private EndpointConsumer epConsumer;
    private ActivationSpec spec = null;
    private XAResourceForRA xar = null;
    private DirectXAResource dxar = null;
    private Object xarSyncObj = null;
    private Method onMessage = null;
    private boolean transactedDelivery = false;
    private boolean endpointValid = false;
    private boolean useDirect = false;
    private static final transient String _className = "com.sun.messaging.jms.ra.OnMessageRunner";
    protected static final transient String _lgrNameInboundMessage = "javax.resourceadapter.mqjmsra.inbound.message";
    protected static final transient Logger _loggerIM = Logger.getLogger("javax.resourceadapter.mqjmsra.inbound.message");
    protected static final transient String _lgrMIDPrefix = "MQJMSRA_MR";
    protected static final transient String _lgrMID_EET = "MQJMSRA_MR1001: ";
    protected static final transient String _lgrMID_INF = "MQJMSRA_MR1101: ";
    protected static final transient String _lgrMID_WRN = "MQJMSRA_MR2001: ";
    protected static final transient String _lgrMID_ERR = "MQJMSRA_MR3001: ";
    protected static final transient String _lgrMID_EXC = "MQJMSRA_MR4001: ";

    public OnMessageRunner(int omrId, OnMessageRunnerPool omrPool, MessageEndpointFactory epFactory, EndpointConsumer epConsumer, ActivationSpec spec, boolean useDirect) {
        Object[] params = new Object[]{omrPool, epFactory, epConsumer, spec, useDirect};
        _loggerIM.entering(_className, "constructor()", params);
        this.omrId = omrId;
        this.omrPool = omrPool;
        this.epFactory = epFactory;
        this.epConsumer = epConsumer;
        this.spec = spec;
        this.useDirect = useDirect;
        if (useDirect) {
            this.dxar = new DirectXAResource(epConsumer.getDirectSession().dc, epConsumer.getDirectSession().jmsservice, epConsumer.getDirectSession().connectionId);
            this.dxar._setUsedByMDB(true);
        } else {
            while (this.xar == null) {
                try {
                    this.xar = new XAResourceForRA(this, epConsumer.xac);
                    break;
                }
                catch (JMSException jmse) {
                    _loggerIM.log(Level.INFO, "MQJMSRA_MR2001: Exception on XAResource creation-", jmse);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {}
                }
            }
        }
        this.xarSyncObj = useDirect ? this.dxar : this.xar;
        this.onMessage = epConsumer.ra._getOnMessageMethod();
        try {
            this.transactedDelivery = epFactory.isDeliveryTransacted(this.onMessage);
        }
        catch (NoSuchMethodException nsme) {
            // empty catch block
        }
        for (int i = 1; i < 6; ++i) {
            try {
                if (epConsumer.deactivated) continue;
                this.msgEndpoint = epFactory.createEndpoint(useDirect ? this.dxar : this.xar);
                break;
            }
            catch (UnavailableException ue) {
                try {
                    _loggerIM.info("MQJMSRA_MR1101: createEndpoint-UnavailableException:Sleeping for:" + i * 200);
                    Thread.sleep((long)i * 200L);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        if (this.msgEndpoint == null) {
            _loggerIM.info("MQJMSRA_MR1101: Endpoint Unavailable:Marking OMR as invalid-omrId=" + omrId + " for:" + spec.toString());
            return;
        }
        this.endpointValid = true;
    }

    public void release() {
    }

    public void releaseEndpoint() {
        if (this.msgEndpoint != null) {
            this.msgEndpoint.release();
        }
    }

    public void invalidate() {
        this.endpointValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.xarSyncObj;
        synchronized (object) {
            int redeliveryCount;
            boolean sendUndeliverableMsgsToDMQ = this.spec.getSendUndeliverableMsgsToDMQ();
            if (!this.endpointValid) {
                _loggerIM.fine("MQJMSRA_MR1101: run:msgEP invalid-Ack Undeliverable & remove OMR fr pool-omrId=" + this.omrId + ":msg=" + this.mqmsg);
                this.omrPool.removeOnMessageRunner(this);
                try {
                    if (!this.useDirect) {
                        this.mqsess.acknowledgeUndeliverableFromRAEndpoint(this.mqmsg, this.xar, sendUndeliverableMsgsToDMQ);
                    }
                }
                catch (JMSException jmse) {
                    _loggerIM.log(Level.WARNING, "MQJMSRA_MR2001: run:msgEP invalid:JMSException on Ack Undeliverable-", jmse);
                }
                return;
            }
            ClassLoader cl = this.spec.getContextClassLoader();
            int exRedeliveryAttempts = this.spec.getEndpointExceptionRedeliveryAttempts();
            int exRedeliveryInterval = this.spec.getEndpointExceptionRedeliveryInterval();
            boolean redeliver = true;
            int msgRedeliveryCount = 0;
            int retryCount = 0;
            try {
                if (this.useDirect) {
                    msgRedeliveryCount = this.dpMsg.getIntProperty("JMSXDeliveryCount");
                    this.dpMsg.setClientRetries(0);
                } else {
                    msgRedeliveryCount = this.mqmsg.getIntProperty("JMSXDeliveryCount");
                    this.mqmsg.setClientRetries(0);
                }
            }
            catch (JMSException e) {
                // empty catch block
            }
            int n = redeliveryCount = msgRedeliveryCount > 1 ? msgRedeliveryCount - 1 : 0;
            while (redeliver) {
                try {
                    block45: {
                        if (this.transactedDelivery) {
                            this.msgEndpoint.beforeDelivery(this.onMessage);
                        }
                        try {
                            if (cl != null) {
                                try {
                                    Thread.currentThread().setContextClassLoader(cl);
                                }
                                catch (Exception sccle) {
                                    _loggerIM.log(Level.WARNING, "MQJMSRA_MR2001: run:Exception setting ContextClassLoader:", sccle);
                                }
                            }
                            if (++redeliveryCount > 1) {
                                if (this.useDirect) {
                                    ((DirectPacket)this.message).updateDeliveryCount(redeliveryCount);
                                } else {
                                    ((MessageImpl)this.message).updateDeliveryCount(redeliveryCount);
                                }
                            }
                            ((MessageListener)this.msgEndpoint).onMessage(this.message);
                            redeliver = false;
                            try {
                                if (this.useDirect) {
                                    if (redeliveryCount > 1) {
                                        this.dpMsg.updateDeliveryCount(redeliveryCount);
                                    }
                                    this.dpMsg._acknowledgeThisMessageForMDB(this.dxar);
                                    this.dxar.setRollback(false, null);
                                    break block45;
                                }
                                if (redeliveryCount > 1) {
                                    this.mqmsg.updateDeliveryCount(redeliveryCount);
                                }
                                this.mqsess.acknowledgeFromRAEndpoint(this.mqmsg, this.xar);
                                this.xar.setRollback(false, null);
                            }
                            catch (JMSException jmse) {
                                _loggerIM.log(Level.WARNING, "MQJMSRA_MR2001: run:JMSException on message acknowledgement:Rolling back if in txn", jmse);
                                if (this.useDirect) {
                                    this.dxar.setRollback(true, jmse);
                                    break block45;
                                }
                                this.xar.setRollback(true, (Exception)((Object)jmse));
                            }
                        }
                        catch (Exception rte) {
                            _loggerIM.log(Level.WARNING, "MQJMSRA_MR2001: run:Caught Exception from onMessage():Redelivering:", rte);
                            try {
                                ++retryCount;
                                if (this.useDirect) {
                                    this.dpMsg.setClientRetries(retryCount);
                                } else {
                                    this.mqmsg.setClientRetries(retryCount);
                                }
                                this.message.setJMSRedelivered(true);
                                if (this.message instanceof BytesMessage) {
                                    ((BytesMessage)this.message).reset();
                                } else if (this.message instanceof StreamMessage) {
                                    ((StreamMessage)this.message).reset();
                                }
                            }
                            catch (Exception jmsesr) {
                                _loggerIM.log(Level.WARNING, "MQJMSRA_MR2001: run:Exception on setJMSRedelivered():", jmsesr);
                            }
                            if (exRedeliveryAttempts > 0) {
                                try {
                                    Thread.sleep(exRedeliveryInterval);
                                }
                                catch (InterruptedException ie) {
                                    // empty catch block
                                }
                                --exRedeliveryAttempts;
                            }
                            _loggerIM.fine("MQJMSRA_MR1101: run:Exhausted redeliveryAttempts-msg=" + this.message.toString());
                            _loggerIM.fine("MQJMSRA_MR1101: run:Exhausted redeliveryAttempts-spec=" + this.spec.toString());
                            if (sendUndeliverableMsgsToDMQ) {
                                _loggerIM.info("MQJMSRA_MR1101: run:Message returned & marked for routing to the DMQ");
                            } else {
                                _loggerIM.info("MQJMSRA_MR1101: run:Message returned & marked for redelivery by the broker");
                            }
                            try {
                                if (this.useDirect) {
                                    this.dpMsg._acknowledgeThisMessageAsDeadForMDB(this.dxar);
                                    _loggerIM.fine("MQJMSRA_MR1101: run:omrId=" + this.omrId + ":Acked Undeliverable-Msg=" + this.dpMsg.toString());
                                } else {
                                    this.mqsess.acknowledgeUndeliverableFromRAEndpoint(this.mqmsg, this.xar, sendUndeliverableMsgsToDMQ);
                                    _loggerIM.fine("MQJMSRA_MR1101: :OMR:run:omrId=" + this.omrId + ":Acked Undeliverable-Msg=" + this.mqmsg.toString());
                                }
                            }
                            catch (JMSException jmse) {
                                _loggerIM.log(Level.WARNING, "MQJMSRA_MR2001: run:JMSException on Acked Undeliverable-", jmse);
                            }
                            redeliver = false;
                        }
                    }
                    if (!this.transactedDelivery) continue;
                    this.msgEndpoint.afterDelivery();
                }
                catch (Throwable t) {
                    _loggerIM.log(Level.WARNING, "MQJMSRA_MR2001: run:onMessage caught Throwable-before/on/afterDelivery:Class=" + t.getClass().getName() + "Msg=" + t.getMessage(), t);
                    redeliver = false;
                }
            }
            this.message = null;
            this.omrPool.putOnMessageRunner(this);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof OnMessageRunner) {
            return this.omrId == ((OnMessageRunner)other).getId();
        }
        return false;
    }

    public int hashCode() {
        return this.omrId;
    }

    public void onMessage(Message msg) {
        if (this.useDirect) {
            this.message = msg;
            this.dpMsg = (DirectPacket)this.message;
            this.ds = this.epConsumer.getDirectSession();
            try {
                this.epConsumer.ra.workMgr.scheduleWork((Work)this);
            }
            catch (WorkException we) {
                _loggerIM.log(Level.INFO, "MQJMSRA_MR1101: onMessage:WorkException-" + we.getMessage() + " on omrId=" + this.omrId, we);
            }
        } else {
            this.message = msg;
            this.mqmsg = (MessageImpl)this.message;
            this.mqsess = (SessionImpl)this.epConsumer.getXASession();
            this.mqmsg._setConsumerInRA();
            try {
                this.epConsumer.ra.workMgr.startWork((Work)this);
            }
            catch (WorkException we) {
                _loggerIM.log(Level.INFO, "MQJMSRA_MR1101: onMessage:WorkException-" + we.getMessage() + " on omrId=" + this.omrId, we);
            }
        }
    }

    @Override
    public int getId() {
        return this.omrId;
    }

    public boolean isValid() {
        return this.endpointValid;
    }

    @Override
    public EndpointConsumer getEndpointConsumer() {
        return this.epConsumer;
    }
}

