/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerFactory;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.org.omg.SendingContext.CodeBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.omg.CORBA.ORB;

public class EncapsInputStream
extends CDRInputObject {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private CodeBase codeBase;

    public EncapsInputStream(ORB orb, byte[] buf, int size, ByteOrder byteOrder, GIOPVersion version) {
        super(orb, ByteBuffer.wrap(buf), size, byteOrder, version, BufferManagerFactory.newReadEncapsulationBufferManager());
        this.performORBVersionSpecificInit();
    }

    public EncapsInputStream(ORB orb, ByteBuffer byteBuffer, int size, ByteOrder byteOrder, GIOPVersion version) {
        super(orb, byteBuffer, size, byteOrder, version, BufferManagerFactory.newReadEncapsulationBufferManager());
        this.performORBVersionSpecificInit();
    }

    public EncapsInputStream(ORB orb, byte[] data, int size) {
        this(orb, data, size, GIOPVersion.V1_2);
    }

    public EncapsInputStream(EncapsInputStream eis) {
        super(eis);
        this.performORBVersionSpecificInit();
    }

    public EncapsInputStream(ORB orb, byte[] data, int size, GIOPVersion version) {
        this(orb, data, size, ByteOrder.BIG_ENDIAN, version);
    }

    public EncapsInputStream(ORB orb, byte[] data, int size, GIOPVersion version, CodeBase codeBase) {
        super(orb, ByteBuffer.wrap(data), size, ByteOrder.BIG_ENDIAN, version, BufferManagerFactory.newReadEncapsulationBufferManager());
        this.codeBase = codeBase;
        this.performORBVersionSpecificInit();
    }

    @Override
    public CDRInputObject dup() {
        return new EncapsInputStream(this);
    }

    @Override
    protected CodeSetConversion.BTCConverter createCharBTCConverter() {
        return CodeSetConversion.impl().getBTCConverter(OSFCodeSetRegistry.ISO_8859_1);
    }

    @Override
    protected CodeSetConversion.BTCConverter createWCharBTCConverter() {
        if (this.getGIOPVersion().equals(GIOPVersion.V1_0)) {
            throw wrapper.wcharDataInGiop10();
        }
        if (this.getGIOPVersion().equals(GIOPVersion.V1_1)) {
            return CodeSetConversion.impl().getBTCConverter(OSFCodeSetRegistry.UTF_16, this.getByteOrder());
        }
        return CodeSetConversion.impl().getBTCConverter(OSFCodeSetRegistry.UTF_16, ByteOrder.BIG_ENDIAN);
    }

    @Override
    public CodeBase getCodeBase() {
        return this.codeBase;
    }
}

