/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerFactory;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.orb.ORB;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.omg.CORBA.portable.InputStream;

public class EncapsOutputStream
extends CDROutputObject {
    static final boolean usePooledByteBuffers = false;
    private static final CDROutputObject.InputObjectFactory INPUT_STREAM_FACTORY = new EncapsInputStreamFactory();

    public EncapsOutputStream(ORB orb) {
        this(orb, GIOPVersion.V1_2);
    }

    public EncapsOutputStream(ORB orb, GIOPVersion version) {
        super(orb, version, BufferManagerFactory.newWriteEncapsulationBufferManager(orb), (byte)1, false);
    }

    @Override
    public InputStream create_input_stream() {
        this.freeInternalCaches();
        return this.createInputObject(null, INPUT_STREAM_FACTORY);
    }

    @Override
    protected CodeSetConversion.CTBConverter createCharCTBConverter() {
        return CodeSetConversion.impl().getCTBConverter(OSFCodeSetRegistry.ISO_8859_1);
    }

    @Override
    protected CodeSetConversion.CTBConverter createWCharCTBConverter() {
        if (this.getGIOPVersion().equals(GIOPVersion.V1_0)) {
            throw wrapper.wcharDataInGiop10();
        }
        if (this.getGIOPVersion().equals(GIOPVersion.V1_1)) {
            return CodeSetConversion.impl().getCTBConverter(OSFCodeSetRegistry.UTF_16, false, false);
        }
        boolean useBOM = ((ORB)this.orb()).getORBData().useByteOrderMarkersInEncapsulations();
        return CodeSetConversion.impl().getCTBConverter(OSFCodeSetRegistry.UTF_16, false, useBOM);
    }

    private static class EncapsInputStreamFactory
    implements CDROutputObject.InputObjectFactory {
        private EncapsInputStreamFactory() {
        }

        @Override
        public CDRInputObject createInputObject(CDROutputObject outputObject, ORB orb, ByteBuffer byteBuffer, int size, GIOPVersion giopVersion) {
            return new EncapsInputStream(outputObject.orb(), byteBuffer, size, ByteOrder.BIG_ENDIAN, giopVersion);
        }
    }
}

