/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.encoding.TypeCodeReader;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORB;
import org.omg.CORBA_2_3.portable.InputStream;

public class TypeCodeInputStream
extends EncapsInputStream
implements TypeCodeReader {
    private Map<Integer, TypeCodeImpl> typeMap = null;
    private InputStream enclosure = null;

    public TypeCodeInputStream(ORB orb, byte[] data, int size) {
        super(orb, data, size);
    }

    public TypeCodeInputStream(ORB orb, byte[] data, int size, ByteOrder byteOrder, GIOPVersion version) {
        super(orb, data, size, byteOrder, version);
    }

    TypeCodeInputStream(ORB orb, ByteBuffer byteBuffer, int size, ByteOrder byteOrder, GIOPVersion version) {
        super(orb, byteBuffer, size, byteOrder, version);
    }

    @Override
    public void addTypeCodeAtPosition(TypeCodeImpl tc, int position) {
        if (this.typeMap == null) {
            this.typeMap = new HashMap<Integer, TypeCodeImpl>(16);
        }
        this.typeMap.put(position, tc);
    }

    @Override
    public TypeCodeImpl getTypeCodeAtPosition(int position) {
        if (this.typeMap == null) {
            return null;
        }
        return this.typeMap.get(position);
    }

    @Override
    public void setEnclosingInputStream(InputStream enclosure) {
        this.enclosure = enclosure;
    }

    @Override
    public TypeCodeReader getTopLevelStream() {
        if (this.enclosure == null) {
            return this;
        }
        if (this.enclosure instanceof TypeCodeReader) {
            return ((TypeCodeReader)this.enclosure).getTopLevelStream();
        }
        return this;
    }

    @Override
    public int getTopLevelPosition() {
        if (this.enclosure != null && this.enclosure instanceof TypeCodeReader) {
            int topPos = ((TypeCodeReader)this.enclosure).getTopLevelPosition();
            return topPos - this.getBufferLength() + this.getPosition();
        }
        return this.getPosition();
    }

    public static TypeCodeInputStream readEncapsulation(InputStream is, ORB _orb) {
        int encapLength = is.read_long();
        byte[] encapBuffer = new byte[encapLength];
        is.read_octet_array(encapBuffer, 0, encapBuffer.length);
        TypeCodeInputStream encap = is instanceof CDRInputObject ? new TypeCodeInputStream(_orb, encapBuffer, encapBuffer.length, ((CDRInputObject)is).getByteOrder(), ((CDRInputObject)is).getGIOPVersion()) : new TypeCodeInputStream(_orb, encapBuffer, encapBuffer.length);
        encap.setEnclosingInputStream(is);
        encap.makeEncapsulation();
        return encap;
    }

    protected void makeEncapsulation() {
        this.consumeEndian();
    }

    @Override
    public void printTypeMap() {
        System.out.println("typeMap = {");
        for (Integer pos : this.typeMap.keySet()) {
            System.out.println("  key = " + pos + ", value = " + this.typeMap.get(pos).description());
        }
        System.out.println("}");
    }
}

