/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.folb;

import com.sun.corba.ee.impl.folb.CSIv2SSLTaggedComponentHandler;
import com.sun.corba.ee.impl.interceptors.IORInfoImpl;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.ior.iiop.ClusterInstanceInfoComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.legacy.interceptor.ServerRequestInfoExt;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactory;
import com.sun.corba.ee.spi.oa.rfm.ReferenceFactoryManager;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.trace.Folb;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.LinkedList;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryHelper;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ForwardRequestHelper;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Folb
public class ServerGroupManager
extends LocalObject
implements GroupInfoServiceObserver,
IORInterceptor,
ORBConfigurator,
ORBInitializer,
ServerRequestInterceptor {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final String baseMsg = ServerGroupManager.class.getName();
    private static final long serialVersionUID = -3197578705750630503L;
    private transient ORB orb;
    private transient GroupInfoService gis;
    private transient CSIv2SSLTaggedComponentHandler csiv2SSLTaggedComponentHandler;
    private String membershipLabel;
    private MembershipChangeState membershipChangeState = MembershipChangeState.IDLE;
    private ReferenceFactoryManager referenceFactoryManager;
    private Codec codec;
    private boolean initialized = false;
    private static final String SSL = "SSL";
    private static final String CLEAR = "IIOP_CLEAR_TEXT";

    @InfoMethod
    private void alreadyInitialized() {
    }

    @Folb
    private void initialize() {
        if (this.initialized) {
            this.alreadyInitialized();
            return;
        }
        try {
            this.initialized = true;
            this.updateMembershipLabel();
            CodecFactory codecFactory = CodecFactoryHelper.narrow((Object)this.orb.resolve_initial_references("CodecFactory"));
            this.codec = codecFactory.create_codec(new Encoding(0, 1, 2));
            this.referenceFactoryManager = (ReferenceFactoryManager)this.orb.resolve_initial_references("ReferenceFactoryManager");
            this.gis = (GroupInfoService)PortableRemoteObject.narrow((java.lang.Object)this.orb.resolve_initial_references("FolbServerGroupInfoService"), GroupInfoService.class);
            this.gis.addObserver(this);
            try {
                this.csiv2SSLTaggedComponentHandler = (CSIv2SSLTaggedComponentHandler)this.orb.resolve_initial_references("CSIv2SSLTaggedComponentHandler");
            }
            catch (InvalidName e) {
                this.csiv2SSLTaggedComponentHandler = null;
                wrapper.noCSIV2Handler(e);
            }
        }
        catch (InvalidName e) {
            wrapper.serverGroupManagerException((Exception)((java.lang.Object)e));
        }
        catch (UnknownEncoding e) {
            wrapper.serverGroupManagerException((Exception)((java.lang.Object)e));
        }
    }

    public String name() {
        return baseMsg;
    }

    public void destroy() {
    }

    @InfoMethod
    private void adapterName(String[] arr) {
    }

    @InfoMethod
    private void addingAddresses() {
    }

    @InfoMethod
    private void notAddingAddress() {
    }

    @InfoMethod
    private void addingMembershipLabel(String ml) {
    }

    @InfoMethod
    private void notAddingMembershipLabel() {
    }

    @InfoMethod
    private void skippingEndpoint(SocketInfo si) {
    }

    @InfoMethod
    private void includingEndpoint(SocketInfo si) {
    }

    @InfoMethod
    private void addingInstanceInfoFor(String name, int weight) {
    }

    @Folb
    public void establish_components(IORInfo iorInfo) {
        try {
            TaggedComponent csiv2;
            this.initialize();
            String[] adapterName = ((IORInfoImpl)iorInfo).getObjectAdapter().getAdapterTemplate().adapter_name();
            this.adapterName(adapterName);
            ReferenceFactory rf = this.referenceFactoryManager.find(adapterName);
            if (rf == null) {
                if (this.gis.shouldAddAddressesToNonReferenceFactory(adapterName)) {
                    this.addingAddresses();
                } else {
                    this.notAddingAddress();
                    return;
                }
            }
            List<ClusterInstanceInfo> info = this.gis.getClusterInstanceInfo(adapterName);
            if (this.csiv2SSLTaggedComponentHandler != null && (csiv2 = this.csiv2SSLTaggedComponentHandler.insert(iorInfo, info)) != null) {
                iorInfo.add_ior_component(csiv2);
            }
            for (ClusterInstanceInfo clusterInstanceInfo : info) {
                this.addingInstanceInfoFor(clusterInstanceInfo.name(), clusterInstanceInfo.weight());
                LinkedList<SocketInfo> listOfSocketInfo = new LinkedList<SocketInfo>();
                for (SocketInfo sinfo : clusterInstanceInfo.endpoints()) {
                    if (sinfo.type().startsWith(SSL)) {
                        this.skippingEndpoint(sinfo);
                        continue;
                    }
                    this.includingEndpoint(sinfo);
                    SocketInfo si = new SocketInfo(CLEAR, sinfo.host(), sinfo.port());
                    listOfSocketInfo.add(si);
                }
                ClusterInstanceInfo ninfo = new ClusterInstanceInfo(clusterInstanceInfo.name(), clusterInstanceInfo.weight(), listOfSocketInfo);
                ClusterInstanceInfoComponent comp = IIOPFactories.makeClusterInstanceInfoComponent(ninfo);
                iorInfo.add_ior_component(comp.getIOPComponent((org.omg.CORBA.ORB)this.orb));
            }
            if (this.gis.shouldAddMembershipLabel(adapterName)) {
                TaggedComponent tc = new TaggedComponent(1398099460, this.membershipLabel.getBytes());
                this.addingMembershipLabel(this.membershipLabel);
                iorInfo.add_ior_component(tc);
            } else {
                this.notAddingMembershipLabel();
            }
        }
        catch (RuntimeException e) {
            wrapper.serverGroupManagerException(e);
        }
    }

    public void components_established(IORInfo iorInfo) {
    }

    public void adapter_manager_state_changed(int managerId, short state) {
    }

    public void adapter_state_changed(ObjectReferenceTemplate[] templates, short state) {
    }

    @InfoMethod
    private void alreadyChangingMembership() {
    }

    @InfoMethod
    private void loopingForMembershipChange() {
    }

    @InfoMethod
    private void unexpectedStateForMembershipChange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Folb
    public void membershipChange() {
        try {
            boolean loop;
            ServerGroupManager serverGroupManager = this;
            synchronized (serverGroupManager) {
                if (this.membershipChangeState != MembershipChangeState.IDLE) {
                    this.membershipChangeState = MembershipChangeState.RETRY_REQUIRED;
                    this.alreadyChangingMembership();
                    return;
                }
                this.membershipChangeState = MembershipChangeState.DOING_WORK;
            }
            do {
                loop = false;
                this.restartFactories();
                ServerGroupManager serverGroupManager2 = this;
                synchronized (serverGroupManager2) {
                    if (this.membershipChangeState == MembershipChangeState.RETRY_REQUIRED) {
                        this.membershipChangeState = MembershipChangeState.DOING_WORK;
                        loop = true;
                        this.loopingForMembershipChange();
                    } else if (this.membershipChangeState == MembershipChangeState.DOING_WORK) {
                        this.membershipChangeState = MembershipChangeState.IDLE;
                    } else if (this.membershipChangeState == MembershipChangeState.IDLE) {
                        this.unexpectedStateForMembershipChange();
                    }
                }
            } while (loop);
        }
        catch (RuntimeException e) {
            wrapper.serverGroupManagerException(e);
            ServerGroupManager serverGroupManager = this;
            synchronized (serverGroupManager) {
                this.membershipChangeState = MembershipChangeState.IDLE;
            }
        }
    }

    @InfoMethod
    private void waitingForWorkerTermination() {
    }

    @Folb
    private void restartFactories() {
        boolean tryAgain;
        ReferenceFactoryManager rfm = this.referenceFactoryManager;
        WorkerThread worker = new WorkerThread();
        worker.start();
        this.waitingForWorkerTermination();
        do {
            tryAgain = false;
            try {
                worker.join();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                tryAgain = true;
            }
        } while (tryAgain);
    }

    @InfoMethod
    private void newMembershipLabel(String ml) {
    }

    @Folb
    private void updateMembershipLabel() {
        UID uid = new UID();
        String hostAddress = null;
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
            this.membershipLabel = hostAddress + ":::" + uid;
            this.newMembershipLabel(this.membershipLabel);
        }
        catch (UnknownHostException e) {
            wrapper.serverGroupManagerException(e);
        }
    }

    @Folb
    public void receive_request_service_contexts(ServerRequestInfo ri) {
        this.initialize();
    }

    @Folb
    public void receive_request(ServerRequestInfo ri) {
        this.initialize();
    }

    public void send_reply(ServerRequestInfo ri) {
        this.send_star(".send_reply", ri);
    }

    public void send_exception(ServerRequestInfo ri) {
        this.send_star(".send_exception", ri);
    }

    public void send_other(ServerRequestInfo ri) {
        this.send_star(".send_other", ri);
    }

    @InfoMethod
    private void rfmIsHolding() {
    }

    @InfoMethod
    private void notManagedByReferenceFactory(String[] adapterName) {
    }

    @InfoMethod
    private void membershipLabelsEqual() {
    }

    @InfoMethod
    private void membershipLabelsNotEqual() {
    }

    @InfoMethod
    private void membershipLabelsNotPresent() {
    }

    @InfoMethod
    private void sendingUpdatedIOR(String[] adapterName) {
    }

    @Folb
    private void send_star(String point, ServerRequestInfo ri) {
        String[] adapterName = null;
        try {
            adapterName = ri.adapter_name();
            if (this.referenceFactoryManager.getState() == ReferenceFactoryManager.RFMState.SUSPENDED) {
                this.rfmIsHolding();
                return;
            }
            ReferenceFactory referenceFactory = this.referenceFactoryManager.find(adapterName);
            if (referenceFactory == null && !((ServerRequestInfoExt)ri).isNameService()) {
                this.notManagedByReferenceFactory(adapterName);
                return;
            }
            String requestMembershipLabel = null;
            try {
                ServiceContext sc = ri.get_request_service_context(1398099457);
                if (sc != null) {
                    byte[] data = sc.context_data;
                    requestMembershipLabel = new String(data);
                    if (this.membershipLabel.equals(requestMembershipLabel)) {
                        this.membershipLabelsEqual();
                        return;
                    }
                    this.membershipLabelsNotEqual();
                }
            }
            catch (BAD_PARAM e) {
                this.membershipLabelsNotPresent();
            }
            this.sendingUpdatedIOR(adapterName);
            byte[] objectId = ri.object_id();
            Object ref = referenceFactory.createReference(objectId);
            Any any = this.orb.create_any();
            ForwardRequest fr = new ForwardRequest(ref);
            ForwardRequestHelper.insert((Any)any, (ForwardRequest)fr);
            byte[] data = null;
            try {
                data = this.codec.encode_value(any);
            }
            catch (InvalidTypeForEncoding e) {
                wrapper.serverGroupManagerException((Exception)((java.lang.Object)e));
            }
            ServiceContext sc = new ServiceContext(1398099458, data);
            ri.add_reply_service_context(sc, false);
        }
        catch (RuntimeException e) {
            wrapper.serverGroupManagerException(e);
        }
    }

    public void pre_init(ORBInitInfo info) {
    }

    @Folb
    public void post_init(ORBInitInfo info) {
        try {
            info.add_ior_interceptor((IORInterceptor)this);
            info.add_server_request_interceptor((ServerRequestInterceptor)this);
        }
        catch (Exception e) {
            wrapper.serverGroupManagerException(e);
        }
    }

    @Override
    @Folb
    public void configure(DataCollector collector, ORB orb) {
        this.orb = orb;
        orb.getORBData().addORBInitializer(this);
    }

    private static enum MembershipChangeState {
        IDLE,
        DOING_WORK,
        RETRY_REQUIRED;

    }

    @Folb
    public class WorkerThread
    extends Thread {
        @InfoMethod
        private void suspendRFM() {
        }

        @InfoMethod
        private void updateMembershipLabelInfo() {
        }

        @InfoMethod
        private void restartFactories() {
        }

        @InfoMethod
        private void resumeRFM() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Folb
        public void run() {
            try {
                this.suspendRFM();
                ServerGroupManager.this.referenceFactoryManager.suspend();
                this.updateMembershipLabelInfo();
                ServerGroupManager.this.updateMembershipLabel();
                this.restartFactories();
                ServerGroupManager.this.referenceFactoryManager.restartFactories();
            }
            finally {
                this.resumeRFM();
                ServerGroupManager.this.referenceFactoryManager.resume();
            }
        }
    }
}

