/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.io;

import com.sun.corba.ee.impl.io.Exceptions;
import com.sun.corba.ee.impl.io.FVDCodeBaseImpl;
import com.sun.corba.ee.impl.io.IIOPInputStream;
import com.sun.corba.ee.impl.io.IIOPOutputStream;
import com.sun.corba.ee.impl.io.ObjectStreamClass;
import com.sun.corba.ee.impl.io.ObjectStreamClassCorbaExt;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.misc.ClassInfoCache;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.logging.UtilSystemException;
import com.sun.corba.ee.spi.trace.ValueHandlerRead;
import com.sun.corba.ee.spi.trace.ValueHandlerWrite;
import com.sun.org.omg.SendingContext.CodeBase;
import com.sun.org.omg.SendingContext.CodeBaseHelper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.glassfish.pfl.basic.logex.OperationTracer;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ValueOutputStream;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.SendingContext.RunTime;

@ValueHandlerRead
@ValueHandlerWrite
public class ValueHandlerImpl
implements ValueHandlerMultiFormat {
    private static final OMGSystemException omgWrapper = OMGSystemException.self;
    protected static final UtilSystemException utilWrapper = UtilSystemException.self;
    public static final String FORMAT_VERSION_PROPERTY = "com.sun.corba.ee.MaxStreamFormatVersion";
    private static final byte MAX_SUPPORTED_FORMAT_VERSION = 2;
    private static final byte STREAM_FORMAT_VERSION_1 = 1;
    private static final byte MAX_STREAM_FORMAT_VERSION = ValueHandlerImpl.getMaxStreamFormatVersion();
    public static final short kRemoteType = 0;
    public static final short kAbstractType = 1;
    public static final short kValueType = 2;
    private final Map<org.omg.CORBA.portable.InputStream, IIOPInputStream> inputStreamPairs = new ConcurrentHashMap<org.omg.CORBA.portable.InputStream, IIOPInputStream>();
    private final Map<org.omg.CORBA.portable.OutputStream, IIOPOutputStream> outputStreamPairs = new ConcurrentHashMap<org.omg.CORBA.portable.OutputStream, IIOPOutputStream>();

    private static byte getMaxStreamFormatVersion() {
        try {
            String propValue = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(ValueHandlerImpl.FORMAT_VERSION_PROPERTY);
                }
            });
            if (propValue == null) {
                return 2;
            }
            byte result = Byte.parseByte(propValue);
            if (result < 1 || result > 2) {
                throw new ExceptionInInitializerError("Invalid stream format version: " + result + ".  Valid range is 1 through " + 2);
            }
            return result;
        }
        catch (Exception ex) {
            ExceptionInInitializerError err = new ExceptionInInitializerError(ex);
            err.initCause(ex);
            throw err;
        }
    }

    public byte getMaximumStreamFormatVersion() {
        return MAX_STREAM_FORMAT_VERSION;
    }

    @ValueHandlerWrite
    public void writeValue(org.omg.CORBA.portable.OutputStream out, Serializable value, byte streamFormatVersion) {
        if (streamFormatVersion == 2) {
            if (!(out instanceof ValueOutputStream)) {
                throw omgWrapper.notAValueoutputstream();
            }
        } else if (streamFormatVersion != 1) {
            throw omgWrapper.invalidStreamFormatVersion(streamFormatVersion);
        }
        this.writeValueWithVersion(out, value, streamFormatVersion);
    }

    @ValueHandlerWrite
    public void writeValue(org.omg.CORBA.portable.OutputStream _out, Serializable value) {
        this.writeValueWithVersion(_out, value, (byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueHandlerWrite
    private void writeValueWithVersion(org.omg.CORBA.portable.OutputStream _out, Serializable value, byte streamFormatVersion) {
        OutputStream out = (OutputStream)_out;
        IIOPOutputStream jdkToOrbOutputStreamBridge = null;
        jdkToOrbOutputStreamBridge = this.outputStreamPairs.get(_out);
        if (jdkToOrbOutputStreamBridge == null) {
            jdkToOrbOutputStreamBridge = this.createOutputStream();
            jdkToOrbOutputStreamBridge.setOrbStream(out);
            this.outputStreamPairs.put(_out, jdkToOrbOutputStreamBridge);
        }
        try {
            jdkToOrbOutputStreamBridge.increaseRecursionDepth();
            this.writeValueInternal(jdkToOrbOutputStreamBridge, out, value, streamFormatVersion);
        }
        finally {
            if (jdkToOrbOutputStreamBridge.decreaseRecursionDepth() == 0) {
                this.outputStreamPairs.remove(_out);
            }
        }
    }

    @ValueHandlerWrite
    private void writeValueInternal(IIOPOutputStream bridge, OutputStream out, Serializable value, byte streamFormatVersion) {
        Class<?> clazz = value.getClass();
        ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(clazz);
        if (cinfo.isArray()) {
            this.write_Array(out, value, clazz.getComponentType());
        } else {
            bridge.simpleWriteObject(value, streamFormatVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueHandlerRead
    public Serializable readValue(org.omg.CORBA.portable.InputStream _in, int offset, Class clazz, String repositoryID, RunTime _sender) {
        Serializable result = null;
        CodeBase sender = CodeBaseHelper.narrow((Object)_sender);
        InputStream in = (InputStream)_in;
        IIOPInputStream jdkToOrbInputStreamBridge = this.inputStreamPairs.get(_in);
        if (jdkToOrbInputStreamBridge == null) {
            jdkToOrbInputStreamBridge = this.createInputStream();
            jdkToOrbInputStreamBridge.setOrbStream(in);
            jdkToOrbInputStreamBridge.setSender(sender);
            jdkToOrbInputStreamBridge.setValueHandler((ValueHandler)this);
            this.inputStreamPairs.put(_in, jdkToOrbInputStreamBridge);
        }
        try {
            jdkToOrbInputStreamBridge.increaseRecursionDepth();
            result = this.readValueInternal(jdkToOrbInputStreamBridge, in, offset, clazz, repositoryID, sender);
        }
        finally {
            if (jdkToOrbInputStreamBridge.decreaseRecursionDepth() == 0) {
                this.inputStreamPairs.remove(_in);
            }
        }
        return result;
    }

    @ValueHandlerRead
    private Serializable readValueInternal(IIOPInputStream bridge, InputStream in, int offset, Class<?> clazz, String repositoryID, CodeBase sender) {
        Serializable result = null;
        if (clazz == null) {
            if (this.isArray(repositoryID)) {
                this.read_Array(bridge, in, null, sender, offset);
            } else {
                bridge.simpleSkipObject(repositoryID, sender);
            }
            return result;
        }
        ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(clazz);
        result = cinfo.isArray() ? (Serializable)this.read_Array(bridge, in, clazz, sender, offset) : (Serializable)bridge.simpleReadObject(clazz, cinfo, repositoryID, sender, offset);
        return result;
    }

    public String getRMIRepositoryID(Class clz) {
        return RepositoryId.createForJavaType(clz);
    }

    public boolean isCustomMarshaled(Class clz) {
        return ObjectStreamClass.lookup(clz).isCustomMarshaled();
    }

    public RunTime getRunTimeCodeBase() {
        FVDCodeBaseImpl codeBase = new FVDCodeBaseImpl((ValueHandler)this);
        return codeBase;
    }

    public boolean useFullValueDescription(Class clazz, String repositoryID) throws IOException {
        return RepositoryId.useFullValueDescription(clazz, repositoryID);
    }

    public String getClassName(String id) {
        RepositoryId repID = RepositoryId.cache.getId(id);
        return repID.getClassName();
    }

    public Class getClassFromType(String id) throws ClassNotFoundException {
        RepositoryId repId = RepositoryId.cache.getId(id);
        return repId.getClassFromType();
    }

    public Class getAnyClassFromType(String id) throws ClassNotFoundException {
        RepositoryId repId = RepositoryId.cache.getId(id);
        return repId.getAnyClassFromType();
    }

    public String createForAnyType(Class cl) {
        return RepositoryId.createForAnyType(cl);
    }

    public String getDefinedInId(String id) {
        RepositoryId repId = RepositoryId.cache.getId(id);
        return repId.getDefinedInId();
    }

    public String getUnqualifiedName(String id) {
        RepositoryId repId = RepositoryId.cache.getId(id);
        return repId.getUnqualifiedName();
    }

    public String getSerialVersionUID(String id) {
        RepositoryId repId = RepositoryId.cache.getId(id);
        return repId.getSerialVersionUID();
    }

    public boolean isAbstractBase(Class clazz) {
        return RepositoryId.isAbstractBase(clazz);
    }

    public boolean isSequence(String id) {
        RepositoryId repId = RepositoryId.cache.getId(id);
        return repId.isSequence();
    }

    @ValueHandlerWrite
    public Serializable writeReplace(Serializable value) {
        return ObjectStreamClass.lookup(value.getClass()).writeReplace(value);
    }

    @ValueHandlerWrite
    protected void writeCharArray(OutputStream out, char[] array, int offset, int length) {
        out.write_wchar_array(array, offset, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ValueHandlerWrite
    private void write_Array(OutputStream out, Serializable obj, Class type) {
        ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(type);
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                int[] array = (int[])obj;
                int length = array.length;
                out.write_ulong(length);
                out.write_long_array(array, 0, length);
                return;
            } else if (type == Byte.TYPE) {
                byte[] array = (byte[])obj;
                int length = array.length;
                out.write_ulong(length);
                out.write_octet_array(array, 0, length);
                return;
            } else if (type == Long.TYPE) {
                long[] array = (long[])obj;
                int length = array.length;
                out.write_ulong(length);
                out.write_longlong_array(array, 0, length);
                return;
            } else if (type == Float.TYPE) {
                float[] array = (float[])obj;
                int length = array.length;
                out.write_ulong(length);
                out.write_float_array(array, 0, length);
                return;
            } else if (type == Double.TYPE) {
                double[] array = (double[])obj;
                int length = array.length;
                out.write_ulong(length);
                out.write_double_array(array, 0, length);
                return;
            } else if (type == Short.TYPE) {
                short[] array = (short[])obj;
                int length = array.length;
                out.write_ulong(length);
                out.write_short_array(array, 0, length);
                return;
            } else if (type == Character.TYPE) {
                char[] array = (char[])obj;
                int length = array.length;
                out.write_ulong(length);
                this.writeCharArray(out, array, 0, length);
                return;
            } else {
                if (type != Boolean.TYPE) throw Exceptions.self.invalidPrimitiveType(obj.getClass().getName());
                boolean[] array = (boolean[])obj;
                int length = array.length;
                out.write_ulong(length);
                out.write_boolean_array(array, 0, length);
            }
            return;
        } else if (type == java.lang.Object.class) {
            java.lang.Object[] array = (java.lang.Object[])obj;
            int length = array.length;
            out.write_ulong(length);
            for (int i = 0; i < length; ++i) {
                Util.getInstance().writeAny((org.omg.CORBA.portable.OutputStream)out, array[i]);
            }
            return;
        } else {
            java.lang.Object[] array = (java.lang.Object[])obj;
            int length = array.length;
            out.write_ulong(length);
            int callType = 2;
            if (cinfo.isInterface()) {
                String className = type.getName();
                if (cinfo.isARemote(type)) {
                    callType = 0;
                } else if (cinfo.isACORBAObject(type)) {
                    callType = 0;
                } else if (RepositoryId.isAbstractBase(type)) {
                    callType = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(type)) {
                    callType = 1;
                }
            }
            block8: for (int i = 0; i < length; ++i) {
                switch (callType) {
                    case 0: {
                        Util.getInstance().writeRemoteObject((org.omg.CORBA.portable.OutputStream)out, array[i]);
                        continue block8;
                    }
                    case 1: {
                        Util.getInstance().writeAbstractObject((org.omg.CORBA.portable.OutputStream)out, array[i]);
                        continue block8;
                    }
                    case 2: {
                        try {
                            out.write_value((Serializable)array[i]);
                            continue block8;
                        }
                        catch (ClassCastException cce) {
                            if (array[i] instanceof Serializable) {
                                throw cce;
                            }
                            Utility.throwNotSerializableForCorba(array[i].getClass().getName());
                        }
                    }
                }
            }
        }
    }

    @ValueHandlerRead
    protected void readCharArray(InputStream in, char[] array, int offset, int length) {
        in.read_wchar_array(array, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueHandlerRead
    private java.lang.Object read_Array(IIOPInputStream bridge, InputStream in, Class sequence, CodeBase sender, int offset) {
        try {
            Class componentType;
            int length = in.read_ulong();
            if (sequence == null) {
                for (int i = 0; i < length; ++i) {
                    in.read_value();
                }
                java.lang.Object var8_10 = null;
                return var8_10;
            }
            OperationTracer.startReadArray((String)sequence.getName(), (int)length);
            Class actualType = componentType = sequence.getComponentType();
            ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(componentType);
            if (componentType.isPrimitive()) {
                if (componentType == Integer.TYPE) {
                    int[] array = new int[length];
                    in.read_long_array(array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                if (componentType == Byte.TYPE) {
                    byte[] array = new byte[length];
                    in.read_octet_array(array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                if (componentType == Long.TYPE) {
                    long[] array = new long[length];
                    in.read_longlong_array(array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                if (componentType == Float.TYPE) {
                    float[] array = new float[length];
                    in.read_float_array(array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                if (componentType == Double.TYPE) {
                    double[] array = new double[length];
                    in.read_double_array(array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                if (componentType == Short.TYPE) {
                    short[] array = new short[length];
                    in.read_short_array(array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                if (componentType == Character.TYPE) {
                    char[] array = new char[length];
                    this.readCharArray(in, array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                if (componentType == Boolean.TYPE) {
                    boolean[] array = new boolean[length];
                    in.read_boolean_array(array, 0, length);
                    Serializable serializable = (Serializable)array;
                    return serializable;
                }
                throw Exceptions.self.invalidPrimitiveComponentType(sequence.getName());
            }
            if (componentType == java.lang.Object.class) {
                java.lang.Object objectValue;
                java.lang.Object[] array = (java.lang.Object[])Array.newInstance(componentType, length);
                bridge.activeRecursionMgr.addObject(offset, array);
                for (int i = 0; i < length; ++i) {
                    objectValue = null;
                    try {
                        OperationTracer.readingIndex((int)i);
                        objectValue = Util.getInstance().readAny((org.omg.CORBA.portable.InputStream)in);
                    }
                    catch (IndirectionException cdrie) {
                        try {
                            objectValue = bridge.activeRecursionMgr.getObject(cdrie.offset);
                        }
                        catch (IOException ie) {
                            throw utilWrapper.invalidIndirection(ie, cdrie.offset);
                        }
                    }
                    array[i] = objectValue;
                }
                objectValue = (Serializable)array;
                return objectValue;
            }
            java.lang.Object[] array = (java.lang.Object[])Array.newInstance(componentType, length);
            bridge.activeRecursionMgr.addObject(offset, array);
            int callType = 2;
            boolean narrow = false;
            if (cinfo.isInterface()) {
                boolean loadStubClass = false;
                if (cinfo.isARemote(componentType)) {
                    callType = 0;
                    loadStubClass = true;
                } else if (cinfo.isACORBAObject(componentType)) {
                    callType = 0;
                    loadStubClass = true;
                } else if (RepositoryId.isAbstractBase(componentType)) {
                    callType = 1;
                    loadStubClass = true;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(componentType)) {
                    callType = 1;
                }
                if (loadStubClass) {
                    try {
                        Class stubType;
                        String codebase = Util.getInstance().getCodebase(componentType);
                        String repID = RepositoryId.createForAnyType(componentType);
                        actualType = stubType = Utility.loadStubClass(repID, codebase, componentType);
                    }
                    catch (ClassNotFoundException e) {
                        narrow = true;
                    }
                } else {
                    narrow = true;
                }
            }
            for (int i = 0; i < length; ++i) {
                try {
                    OperationTracer.readingIndex((int)i);
                    switch (callType) {
                        case 0: {
                            if (!narrow) {
                                array[i] = in.read_Object(actualType);
                                break;
                            }
                            array[i] = Utility.readObjectAndNarrow((org.omg.CORBA.portable.InputStream)in, actualType);
                            break;
                        }
                        case 1: {
                            if (!narrow) {
                                array[i] = in.read_abstract_interface(actualType);
                                break;
                            }
                            array[i] = Utility.readAbstractAndNarrow(in, actualType);
                            break;
                        }
                        case 2: {
                            array[i] = in.read_value(actualType);
                        }
                    }
                    continue;
                }
                catch (IndirectionException cdrie) {
                    try {
                        array[i] = bridge.activeRecursionMgr.getObject(cdrie.offset);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw utilWrapper.invalidIndirection(ioe, cdrie.offset);
                    }
                }
            }
            Serializable serializable = (Serializable)array;
            return serializable;
        }
        finally {
            bridge.activeRecursionMgr.removeObject(offset);
            if (sequence != null) {
                OperationTracer.endReadArray();
            }
        }
    }

    private boolean isArray(String repId) {
        return RepositoryId.cache.getId(repId).isSequence();
    }

    protected IIOPOutputStream createOutputStream() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<IIOPOutputStream>(){

                @Override
                public IIOPOutputStream run() {
                    try {
                        return new IIOPOutputStream();
                    }
                    catch (IOException exc) {
                        throw utilWrapper.exceptionInCreateIiopOutputStream(exc);
                    }
                }
            });
        }
        try {
            return new IIOPOutputStream();
        }
        catch (IOException exc) {
            throw utilWrapper.exceptionInCreateIiopOutputStream(exc);
        }
    }

    protected IIOPInputStream createInputStream() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<IIOPInputStream>(){

                @Override
                public IIOPInputStream run() {
                    try {
                        return new IIOPInputStream();
                    }
                    catch (IOException exc) {
                        throw utilWrapper.exceptionInCreateIiopInputStream(exc);
                    }
                }
            });
        }
        try {
            return new IIOPInputStream();
        }
        catch (IOException exc) {
            throw utilWrapper.exceptionInCreateIiopInputStream(exc);
        }
    }

    protected TCKind getJavaCharTCKind() {
        return TCKind.tk_wchar;
    }
}

