/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.ior.iiop;

import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.encoding.EncapsOutputStream;
import com.sun.corba.ee.impl.ior.EncapsulationUtility;
import com.sun.corba.ee.impl.ior.iiop.IIOPAddressImpl;
import com.sun.corba.ee.impl.util.JDKBridge;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.IdentifiableBase;
import com.sun.corba.ee.spi.ior.ObjectAdapterId;
import com.sun.corba.ee.spi.ior.ObjectId;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.TaggedProfile;
import com.sun.corba.ee.spi.ior.TaggedProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPFactories;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.ior.iiop.JavaCodebaseComponent;
import com.sun.corba.ee.spi.logging.IORSystemException;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.trace.IsLocal;
import java.util.Iterator;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.IOP.TaggedProfileHelper;

@IsLocal
public class IIOPProfileImpl
extends IdentifiableBase
implements IIOPProfile {
    private static final IORSystemException wrapper = IORSystemException.self;
    private com.sun.corba.ee.spi.orb.ORB orb;
    private ObjectId oid;
    private IIOPProfileTemplate proftemp;
    private ObjectKeyTemplate oktemp;
    private ObjectKey objectKey;
    protected String codebase = null;
    protected boolean cachedCodebase = false;
    private boolean checkedIsLocal = false;
    private boolean cachedIsLocal = false;
    private GIOPVersion giopVersion = null;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IIOPProfileImpl[proftemp=");
        sb.append(this.proftemp.toString());
        sb.append(" oktemp=");
        sb.append(this.oktemp.toString());
        sb.append(" oid=");
        sb.append(this.oid.toString());
        return sb.toString();
    }

    public boolean equals(java.lang.Object obj) {
        if (!(obj instanceof IIOPProfileImpl)) {
            return false;
        }
        IIOPProfileImpl other = (IIOPProfileImpl)obj;
        return this.oid.equals(other.oid) && this.proftemp.equals(other.proftemp) && this.oktemp.equals(other.oktemp);
    }

    public int hashCode() {
        return this.oid.hashCode() ^ this.proftemp.hashCode() ^ this.oktemp.hashCode();
    }

    @Override
    public ObjectId getObjectId() {
        return this.oid;
    }

    @Override
    public TaggedProfileTemplate getTaggedProfileTemplate() {
        return this.proftemp;
    }

    @Override
    public ObjectKeyTemplate getObjectKeyTemplate() {
        return this.oktemp;
    }

    private IIOPProfileImpl(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
    }

    public IIOPProfileImpl(com.sun.corba.ee.spi.orb.ORB orb, ObjectKeyTemplate oktemp, ObjectId oid, IIOPProfileTemplate proftemp) {
        this(orb);
        this.oktemp = oktemp;
        this.oid = oid;
        this.proftemp = proftemp;
    }

    public IIOPProfileImpl(InputStream is) {
        this((com.sun.corba.ee.spi.orb.ORB)is.orb());
        this.init(is);
    }

    public IIOPProfileImpl(com.sun.corba.ee.spi.orb.ORB orb, org.omg.IOP.TaggedProfile profile) {
        this(orb);
        if (profile == null || profile.tag != 0 || profile.profile_data == null) {
            throw wrapper.invalidTaggedProfile();
        }
        EncapsInputStream istr = new EncapsInputStream((ORB)orb, profile.profile_data, profile.profile_data.length);
        istr.consumeEndian();
        this.init(istr);
    }

    private void init(InputStream istr) {
        GIOPVersion version = new GIOPVersion();
        version.read((org.omg.CORBA.portable.InputStream)istr);
        IIOPAddressImpl primary = new IIOPAddressImpl(istr);
        byte[] key = EncapsulationUtility.readOctets(istr);
        ObjectKey okey = this.orb.getObjectKeyFactory().create(key);
        this.oktemp = okey.getTemplate();
        this.oid = okey.getId();
        this.proftemp = IIOPFactories.makeIIOPProfileTemplate(this.orb, version, primary);
        if (version.getMinor() > 0) {
            EncapsulationUtility.readIdentifiableSequence(this.proftemp, this.orb.getTaggedComponentFactoryFinder(), istr);
        }
        if (this.uncachedGetCodeBase() == null) {
            JavaCodebaseComponent jcc = LocalCodeBaseSingletonHolder.comp;
            if (jcc != null) {
                if (version.getMinor() > 0) {
                    this.proftemp.add(jcc);
                }
                this.codebase = jcc.getURLs();
            }
            this.cachedCodebase = true;
        }
    }

    @Override
    public void writeContents(OutputStream os) {
        this.proftemp.write(this.oktemp, this.oid, os);
    }

    @Override
    public int getId() {
        return this.proftemp.getId();
    }

    @Override
    public boolean isEquivalent(TaggedProfile prof) {
        if (!(prof instanceof IIOPProfile)) {
            return false;
        }
        IIOPProfile other = (IIOPProfile)prof;
        return this.oid.equals(other.getObjectId()) && this.proftemp.isEquivalent(other.getTaggedProfileTemplate()) && this.oktemp.equals(other.getObjectKeyTemplate());
    }

    @Override
    public synchronized ObjectKey getObjectKey() {
        if (this.objectKey == null) {
            this.objectKey = IORFactories.makeObjectKey(this.oktemp, this.oid);
        }
        return this.objectKey;
    }

    @Override
    public org.omg.IOP.TaggedProfile getIOPProfile() {
        EncapsOutputStream os = new EncapsOutputStream(this.orb);
        os.write_long(this.getId());
        this.write(os);
        InputStream is = (InputStream)os.create_input_stream();
        return TaggedProfileHelper.read((org.omg.CORBA.portable.InputStream)is);
    }

    private String uncachedGetCodeBase() {
        Iterator<TaggedComponent> iter = this.proftemp.iteratorById(25);
        if (iter.hasNext()) {
            JavaCodebaseComponent jcbc = (JavaCodebaseComponent)JavaCodebaseComponent.class.cast(iter.next());
            return jcbc.getURLs();
        }
        return null;
    }

    @Override
    public synchronized String getCodebase() {
        if (!this.cachedCodebase) {
            this.cachedCodebase = true;
            this.codebase = this.uncachedGetCodeBase();
        }
        return this.codebase;
    }

    @Override
    public ORBVersion getORBVersion() {
        return this.oktemp.getORBVersion();
    }

    @InfoMethod
    private void computingIsLocal(String host, int scid, int sid, int port) {
    }

    @InfoMethod
    private void isLocalResults(boolean isLocalHost, boolean isLocalServerId, boolean isLocalPort) {
    }

    @Override
    @IsLocal
    public synchronized boolean isLocal() {
        if (!this.checkedIsLocal) {
            this.checkedIsLocal = true;
            String host = this.proftemp.getPrimaryAddress().getHost();
            int scid = this.oktemp.getSubcontractId();
            int sid = this.oktemp.getServerId();
            int port = this.proftemp.getPrimaryAddress().getPort();
            this.computingIsLocal(host, scid, sid, port);
            boolean isLocalHost = this.orb.isLocalHost(host);
            boolean isLocalServerId = sid == -1 || this.orb.isLocalServerId(scid, sid);
            boolean isLocalServerPort = this.orb.getLegacyServerSocketManager().legacyIsLocalServerPort(port);
            this.isLocalResults(isLocalHost, isLocalServerId, isLocalServerPort);
            this.cachedIsLocal = isLocalHost && isLocalServerId && isLocalServerPort;
        }
        return this.cachedIsLocal;
    }

    @Override
    @IsLocal
    public java.lang.Object getServant() {
        if (!this.isLocal()) {
            return null;
        }
        RequestDispatcherRegistry scr = this.orb.getRequestDispatcherRegistry();
        ObjectAdapterFactory oaf = scr.getObjectAdapterFactory(this.oktemp.getSubcontractId());
        ObjectAdapterId oaid = this.oktemp.getObjectAdapterId();
        ObjectAdapter oa = null;
        try {
            oa = oaf.find(oaid);
        }
        catch (SystemException exc) {
            wrapper.getLocalServantFailure((Exception)((java.lang.Object)exc), oaid);
            return null;
        }
        byte[] boid = this.oid.getId();
        Object servant = oa.getLocalServant(boid);
        return servant;
    }

    @Override
    public synchronized GIOPVersion getGIOPVersion() {
        return this.proftemp.getGIOPVersion();
    }

    @Override
    public void makeImmutable() {
        this.proftemp.makeImmutable();
    }

    private static class LocalCodeBaseSingletonHolder {
        public static JavaCodebaseComponent comp;

        private LocalCodeBaseSingletonHolder() {
        }

        static {
            String localCodebase = JDKBridge.getLocalCodebase();
            comp = localCodebase == null ? null : IIOPFactories.makeJavaCodebaseComponent(localCodebase);
        }
    }
}

