/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.presentation.rmi;

import com.sun.corba.ee.impl.misc.ClassInfoCache;
import com.sun.corba.ee.impl.presentation.rmi.DynamicMethodMarshallerImpl;
import com.sun.corba.ee.impl.presentation.rmi.IDLNameTranslatorImpl;
import com.sun.corba.ee.impl.presentation.rmi.InvocationHandlerFactoryImpl;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.presentation.rmi.DynamicMethodMarshaller;
import com.sun.corba.ee.spi.presentation.rmi.IDLNameTranslator;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.rmi.CORBA.Tie;
import org.glassfish.pfl.basic.concurrent.WeakCache;
import org.glassfish.pfl.basic.graph.Graph;
import org.glassfish.pfl.basic.graph.GraphImpl;
import org.glassfish.pfl.basic.graph.Node;
import org.glassfish.pfl.basic.proxy.InvocationHandlerFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public final class PresentationManagerImpl
implements PresentationManager {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private WeakCache<Class<?>, PresentationManager.ClassData> classToClassData;
    private WeakCache<Method, DynamicMethodMarshaller> methodToDMM;
    private PresentationManager.StubFactoryFactory staticStubFactoryFactory;
    private PresentationManager.StubFactoryFactory dynamicStubFactoryFactory;
    private boolean useDynamicStubs;
    private boolean debug;
    private PrintStream ps;

    public PresentationManagerImpl(boolean useDynamicStubs) {
        this.useDynamicStubs = useDynamicStubs;
        this.classToClassData = new WeakCache<Class<?>, PresentationManager.ClassData>(){

            protected PresentationManager.ClassData lookup(Class<?> key) {
                return new ClassDataImpl(key);
            }
        };
        this.methodToDMM = new WeakCache<Method, DynamicMethodMarshaller>(){

            protected DynamicMethodMarshaller lookup(Method key) {
                return new DynamicMethodMarshallerImpl(key);
            }
        };
    }

    @Override
    public synchronized DynamicMethodMarshaller getDynamicMethodMarshaller(Method method) {
        if (method == null) {
            return null;
        }
        return (DynamicMethodMarshaller)this.methodToDMM.get((Object)method);
    }

    @Override
    public synchronized PresentationManager.ClassData getClassData(Class<?> cls) {
        return (PresentationManager.ClassData)this.classToClassData.get(cls);
    }

    @Override
    public PresentationManager.StubFactoryFactory getStubFactoryFactory(boolean isDynamic) {
        if (isDynamic) {
            return this.getDynamicStubFactoryFactory();
        }
        return this.getStaticStubFactoryFactory();
    }

    @Override
    public PresentationManager.StubFactoryFactory getStaticStubFactoryFactory() {
        return this.staticStubFactoryFactory;
    }

    @Override
    public PresentationManager.StubFactoryFactory getDynamicStubFactoryFactory() {
        return this.dynamicStubFactoryFactory;
    }

    public void setStaticStubFactoryFactory(PresentationManager.StubFactoryFactory sff) {
        this.staticStubFactoryFactory = sff;
    }

    public void setDynamicStubFactoryFactory(PresentationManager.StubFactoryFactory sff) {
        this.dynamicStubFactoryFactory = sff;
    }

    @Override
    public Tie getTie() {
        return this.dynamicStubFactoryFactory.getTie(null);
    }

    @Override
    public String getRepositoryId(Remote impl) {
        Tie tie = this.getTie();
        tie.setTarget(impl);
        return ((Servant)Servant.class.cast(tie))._all_interfaces((POA)null, (byte[])null)[0];
    }

    @Override
    public boolean useDynamicStubs() {
        return this.useDynamicStubs;
    }

    @Override
    public void flushClass(final Class<?> cls) {
        this.classToClassData.remove(cls);
        Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return cls.getMethods();
            }
        });
        for (int ctr = 0; ctr < methods.length; ++ctr) {
            this.methodToDMM.remove((Object)methods[ctr]);
        }
    }

    private Set<NodeImpl> getRootSet(Class<?> target, NodeImpl root, Graph<NodeImpl> gr) {
        Set rootSet = null;
        if (ClassInfoCache.get(target).isInterface()) {
            gr.add((Object)root);
            rootSet = gr.getRoots();
        } else {
            HashSet<NodeImpl> initialRootSet = new HashSet<NodeImpl>();
            for (Class<?> superclass = target; superclass != null && !superclass.equals(Object.class); superclass = superclass.getSuperclass()) {
                NodeImpl node = new NodeImpl(superclass);
                gr.add((Object)node);
                initialRootSet.add(node);
            }
            gr.getRoots();
            gr.removeAll(initialRootSet);
            rootSet = gr.getRoots();
        }
        return rootSet;
    }

    private Class<?>[] getInterfaces(Set<NodeImpl> roots) {
        int ctr = 0;
        Class[] classes = new Class[roots.size()];
        for (NodeImpl node : roots) {
            classes[ctr] = node.getInterface();
            ++ctr;
        }
        return classes;
    }

    private String[] makeTypeIds(NodeImpl root, Graph<NodeImpl> gr, Set<NodeImpl> rootSet) {
        HashSet<NodeImpl> nonRootSet = new HashSet<NodeImpl>((Collection<NodeImpl>)gr);
        nonRootSet.removeAll(rootSet);
        if (rootSet.isEmpty()) {
            return new String[]{""};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (rootSet.size() > 1) {
            result.add(root.getTypeId());
        }
        this.addNodes(result, rootSet);
        this.addNodes(result, nonRootSet);
        return result.toArray(new String[result.size()]);
    }

    private void addNodes(List<String> resultList, Set<NodeImpl> nodeSet) {
        for (NodeImpl node : nodeSet) {
            String typeId = node.getTypeId();
            resultList.add(typeId);
        }
    }

    public void enableDebug(PrintStream ps) {
        this.debug = true;
        this.ps = ps;
    }

    public void disableDebug() {
        this.debug = false;
        this.ps = null;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public PrintStream getPrintStream() {
        return this.ps;
    }

    private class ClassDataImpl
    implements PresentationManager.ClassData {
        private Class<?> cls;
        private IDLNameTranslator nameTranslator;
        private String[] typeIds;
        private InvocationHandlerFactory ihfactory;
        private Map<String, Object> dictionary;

        ClassDataImpl(Class<?> cls) {
            this.cls = cls;
            GraphImpl gr = new GraphImpl();
            NodeImpl root = new NodeImpl(cls);
            Set rootSet = PresentationManagerImpl.this.getRootSet(cls, root, (Graph<NodeImpl>)((Graph)gr));
            Class[] interfaces = PresentationManagerImpl.this.getInterfaces(rootSet);
            this.nameTranslator = IDLNameTranslatorImpl.get(interfaces);
            this.typeIds = PresentationManagerImpl.this.makeTypeIds(root, (Graph<NodeImpl>)((Graph)gr), rootSet);
            this.ihfactory = new InvocationHandlerFactoryImpl(PresentationManagerImpl.this, this);
            this.dictionary = new HashMap<String, Object>();
        }

        @Override
        public Class<?> getMyClass() {
            return this.cls;
        }

        @Override
        public IDLNameTranslator getIDLNameTranslator() {
            return this.nameTranslator;
        }

        @Override
        public String[] getTypeIds() {
            return (String[])this.typeIds.clone();
        }

        @Override
        public InvocationHandlerFactory getInvocationHandlerFactory() {
            return this.ihfactory;
        }

        @Override
        public Map<String, Object> getDictionary() {
            return this.dictionary;
        }
    }

    private static class NodeImpl
    implements Node<NodeImpl> {
        private Class<?> interf;

        public Class<?> getInterface() {
            return this.interf;
        }

        NodeImpl(Class<?> interf) {
            this.interf = interf;
        }

        public String getTypeId() {
            return RepositoryId.createForJavaType(this.interf);
        }

        public Set<NodeImpl> getChildren() {
            HashSet<NodeImpl> result = new HashSet<NodeImpl>();
            Class<?>[] interfaces = this.interf.getInterfaces();
            for (int ctr = 0; ctr < interfaces.length; ++ctr) {
                Class<?> cls = interfaces[ctr];
                ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(cls);
                if (!cinfo.isARemote(cls) || Remote.class.equals(cls)) continue;
                result.add(new NodeImpl(cls));
            }
            return result;
        }

        public String toString() {
            return "NodeImpl[" + this.interf + "]";
        }

        public int hashCode() {
            return this.interf.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NodeImpl)) {
                return false;
            }
            NodeImpl other = (NodeImpl)obj;
            return other.getInterface().equals(this.interf);
        }
    }
}

