/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.transport.AcceptorBase;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Selector;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public class AcceptorImpl
extends AcceptorBase {
    protected ServerSocketChannel serverSocketChannel;
    protected ServerSocket serverSocket;
    private Class<?> lastExceptionClassSeen = null;

    public AcceptorImpl(ORB orb, int port, String name, String type) {
        super(orb, port, name, type);
    }

    @Override
    @Transport
    public synchronized boolean initialize() {
        if (this.initialized) {
            return false;
        }
        InetSocketAddress inetSocketAddress = null;
        String host = "all interfaces";
        try {
            if (this.orb.getORBData().getListenOnAllInterfaces()) {
                inetSocketAddress = new InetSocketAddress(this.port);
            } else {
                host = this.orb.getORBData().getORBServerHost();
                inetSocketAddress = new InetSocketAddress(host, this.port);
            }
            this.serverSocket = this.orb.getORBData().getSocketFactory().createServerSocket(this.type, inetSocketAddress);
            this.internalInitialize();
            if (this.orb.getORBData().showInfoMessages()) {
                this.wrapper.infoCreateListenerSucceeded(host, Integer.toString(this.port));
            }
        }
        catch (Throwable t) {
            throw this.wrapper.createListenerFailed(t, host, this.port);
        }
        this.initialized = true;
        return true;
    }

    protected void internalInitialize() throws Exception {
        this.port = this.serverSocket.getLocalPort();
        this.orb.getCorbaTransportManager().getInboundConnectionCache(this);
        this.serverSocketChannel = this.serverSocket.getChannel();
        if (this.serverSocketChannel != null) {
            this.setUseSelectThreadToWait(this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
            this.serverSocketChannel.configureBlocking(!this.orb.getORBData().acceptorSocketUseSelectThreadToWait());
        } else {
            this.setUseSelectThreadToWait(false);
        }
        this.setUseWorkerThreadForEvent(this.orb.getORBData().acceptorSocketUseWorkerThreadForEvent());
    }

    @InfoMethod
    private void usingServerSocket(ServerSocket ss) {
    }

    @InfoMethod
    private void usingServerSocketChannel(ServerSocketChannel ssc) {
    }

    @Override
    @Transport
    public Socket getAcceptedSocket() {
        SocketChannel socketChannel = null;
        Socket socket = null;
        try {
            if (this.serverSocketChannel == null) {
                socket = this.serverSocket.accept();
                this.usingServerSocket(this.serverSocket);
            } else {
                socketChannel = this.serverSocketChannel.accept();
                socket = socketChannel.socket();
                this.usingServerSocketChannel(this.serverSocketChannel);
            }
            this.orb.getORBData().getSocketFactory().setAcceptedSocketOptions(this, this.serverSocket, socket);
            this.lastExceptionClassSeen = null;
        }
        catch (IOException e) {
            if (e.getClass() == this.lastExceptionClassSeen) {
                this.wrapper.ioexceptionInAcceptFine(e);
            } else {
                this.lastExceptionClassSeen = e.getClass();
                this.wrapper.ioexceptionInAccept(e);
            }
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
            this.orb.getTransportManager().getSelector(0).registerForEvent(this);
        }
        return socket;
    }

    @InfoMethod
    private void closeException(IOException exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void close() {
        try {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.unregisterForEvent(this);
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            this.closeException(e);
        }
    }

    @Override
    public SelectableChannel getChannel() {
        return this.serverSocketChannel;
    }

    protected void accept() {
        this.processSocket(this.getAcceptedSocket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    public void doWork() {
        try {
            if (this.selectionKey.isAcceptable()) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        AcceptorImpl.this.accept();
                        return null;
                    }
                });
            } else {
                this.selectionKeyNotAcceptable();
            }
        }
        catch (SecurityException se) {
            this.securityException(se);
            String permissionStr = ORBUtility.getClassSecurityInfo(this.getClass());
            this.wrapper.securityExceptionInAccept(se, permissionStr);
        }
        catch (Exception ex) {
            this.otherException(ex);
            this.wrapper.exceptionInAccept(ex, ex.toString());
        }
        catch (Throwable t) {
            this.otherException(t);
        }
        finally {
            Selector selector = this.orb.getTransportManager().getSelector(0);
            selector.registerInterestOps(this);
        }
    }

    @Override
    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @InfoMethod
    private void selectionKeyNotAcceptable() {
    }

    @InfoMethod
    private void securityException(SecurityException se) {
    }

    @InfoMethod
    private void otherException(Throwable t) {
    }
}

