/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.concurrent;

import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueue;

public class ConcurrentQueueImpl<V>
implements ConcurrentQueue<V> {
    final Entry<V> head = new Entry<Object>(null, 0L);
    int count = 0;
    private long ttl;

    public ConcurrentQueueImpl(long ttl) {
        this.head.next = this.head;
        this.head.prev = this.head;
        this.ttl = ttl;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public ConcurrentQueue.Handle<V> offer(V arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        Entry<V> entry = new Entry<V>(arg, System.currentTimeMillis() + this.ttl);
        entry.next = this.head;
        entry.prev = this.head.prev;
        this.head.prev.next = entry;
        this.head.prev = entry;
        ++this.count;
        return entry.handle();
    }

    @Override
    public ConcurrentQueue.Handle<V> poll() {
        Entry first = null;
        first = this.head.next;
        if (first == this.head) {
            return null;
        }
        HandleImpl result = first.handle();
        result.remove();
        return result;
    }

    @Override
    public ConcurrentQueue.Handle<V> peek() {
        Entry first = this.head.next;
        if (first == this.head) {
            return null;
        }
        return first.handle();
    }

    private final class Entry<V> {
        Entry<V> next = null;
        Entry<V> prev = null;
        private HandleImpl<V> handle;
        private long expiration;

        Entry(V value, long expiration) {
            this.handle = new HandleImpl<V>(this, value, expiration);
            this.expiration = expiration;
        }

        HandleImpl<V> handle() {
            return this.handle;
        }
    }

    private final class HandleImpl<V>
    implements ConcurrentQueue.Handle<V> {
        private Entry<V> entry;
        private final V value;
        private boolean valid;
        private long expiration;

        HandleImpl(Entry<V> entry, V value, long expiration) {
            this.entry = entry;
            this.value = value;
            this.valid = true;
            this.expiration = expiration;
        }

        Entry<V> entry() {
            return this.entry;
        }

        @Override
        public V value() {
            return this.value;
        }

        @Override
        public boolean remove() {
            if (!this.valid) {
                return false;
            }
            this.valid = false;
            this.entry.next.prev = this.entry.prev;
            this.entry.prev.next = this.entry.next;
            --ConcurrentQueueImpl.this.count;
            this.entry.prev = null;
            this.entry.next = null;
            ((Entry)this.entry).handle = null;
            this.entry = null;
            this.valid = false;
            return true;
        }

        @Override
        public long expiration() {
            return this.expiration;
        }
    }
}

