/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.concurrent;

import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueue;

public class ConcurrentQueueNonBlockingImpl<V>
implements ConcurrentQueue<V> {
    final Entry<V> head = new Entry<Object>(null, 0L);
    final Object lock = new Object();
    int count = 0;
    private long ttl;

    public ConcurrentQueueNonBlockingImpl(long ttl) {
        this.head.next = this.head;
        this.head.prev = this.head;
        this.ttl = ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentQueue.Handle<V> offer(V arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        Entry<V> entry = new Entry<V>(arg, System.currentTimeMillis() + this.ttl);
        Object object = this.lock;
        synchronized (object) {
            entry.next = this.head;
            entry.prev = this.head.prev;
            this.head.prev.next = entry;
            this.head.prev = entry;
            ++this.count;
        }
        return entry.handle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentQueue.Handle<V> poll() {
        Entry first = null;
        Object object = this.lock;
        synchronized (object) {
            first = this.head.next;
            if (first == this.head) {
                return null;
            }
            HandleImpl result = first.handle();
            result.remove();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentQueue.Handle<V> peek() {
        Object object = this.lock;
        synchronized (object) {
            Entry first = this.head.next;
            if (first == this.head) {
                return null;
            }
            return first.handle();
        }
    }

    private final class Entry<V> {
        Entry<V> next = null;
        Entry<V> prev = null;
        private HandleImpl<V> handle;
        private long expiration;

        Entry(V value, long expiration) {
            this.handle = new HandleImpl<V>(this, value, expiration);
            this.expiration = expiration;
        }

        HandleImpl<V> handle() {
            return this.handle;
        }
    }

    private final class HandleImpl<V>
    implements ConcurrentQueue.Handle<V> {
        private Entry<V> entry;
        private final V value;
        private boolean valid;
        private long expiration;

        HandleImpl(Entry<V> entry, V value, long expiration) {
            this.entry = entry;
            this.value = value;
            this.valid = true;
            this.expiration = expiration;
        }

        Entry<V> entry() {
            return this.entry;
        }

        @Override
        public V value() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove() {
            Object object = ConcurrentQueueNonBlockingImpl.this.lock;
            synchronized (object) {
                if (!this.valid) {
                    return false;
                }
                this.valid = false;
                this.entry.next.prev = this.entry.prev;
                this.entry.prev.next = this.entry.next;
                --ConcurrentQueueNonBlockingImpl.this.count;
            }
            this.entry.prev = null;
            this.entry.next = null;
            ((Entry)this.entry).handle = null;
            this.entry = null;
            this.valid = false;
            return true;
        }

        @Override
        public long expiration() {
            return this.expiration;
        }
    }
}

