/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.spi.transport.connection.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
public class OutboundCacheEntry<C extends Connection> {
    private ReentrantLock lock;
    private final Condition waitForPendingConnections;
    final Queue<C> idleConnections = new LinkedBlockingQueue<C>();
    final Collection<C> idleConnectionsView = Collections.unmodifiableCollection(this.idleConnections);
    final Queue<C> busyConnections = new LinkedBlockingQueue<C>();
    final Collection<C> busyConnectionsView = Collections.unmodifiableCollection(this.busyConnections);
    private int pendingConnections = 0;

    public OutboundCacheEntry(ReentrantLock lock) {
        this.lock = lock;
        this.waitForPendingConnections = lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = "OutboundCacheEntry[numIdle=" + this.idleConnections.size() + ",numBusy=" + this.busyConnections.size() + ",numPending=" + this.pendingConnections + "]";
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    @Description(value="list of idle connections")
    private Collection<C> idleConnections() {
        this.lock.lock();
        try {
            ArrayList<C> arrayList = new ArrayList<C>(this.idleConnections);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute
    @Description(value="list of idle connections")
    private Collection<C> busyConnections() {
        this.lock.lock();
        try {
            ArrayList<C> arrayList = new ArrayList<C>(this.busyConnections);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(id="numIdleConnections")
    @Description(value="Number of idle connections")
    private int numIdleConnectionsAttribute() {
        this.lock.lock();
        try {
            int n = this.idleConnections.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(id="numPendingConnections")
    @Description(value="Number of pending connections")
    private int numPendingConnectionsAttribute() {
        this.lock.lock();
        try {
            int n = this.pendingConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(id="numBusyConnections")
    @Description(value="Number of busy connections")
    private int numBusyConnectionsAttribute() {
        this.lock.lock();
        try {
            int n = this.busyConnections.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int totalConnections() {
        return this.idleConnections.size() + this.busyConnections.size() + this.pendingConnections;
    }

    public void startConnect() {
        ++this.pendingConnections;
    }

    public void finishConnect() {
        --this.pendingConnections;
        this.waitForPendingConnections.signal();
    }

    public void waitForConnection() {
        this.waitForPendingConnections.awaitUninterruptibly();
    }
}

