/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.impl.transport.connection.ConnectionCacheBlockingBase;
import com.sun.corba.ee.impl.transport.connection.OutboundCacheEntry;
import com.sun.corba.ee.impl.transport.connection.OutboundConnectionState;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueueFactory;
import com.sun.corba.ee.spi.transport.connection.Connection;
import com.sun.corba.ee.spi.transport.connection.ConnectionFinder;
import com.sun.corba.ee.spi.transport.connection.ContactInfo;
import com.sun.corba.ee.spi.transport.connection.OutboundConnectionCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
@ManagedObject
@Description(value="Outbound connection cache for connections opened by the client")
public final class OutboundConnectionCacheBlockingImpl<C extends Connection>
extends ConnectionCacheBlockingBase<C>
implements OutboundConnectionCache<C> {
    private ReentrantLock lock = new ReentrantLock();
    private final int maxParallelConnections;
    private Map<ContactInfo<C>, OutboundCacheEntry<C>> entryMap;
    private Map<C, OutboundConnectionState<C>> connectionMap;

    @Override
    @ManagedAttribute
    public int maxParallelConnections() {
        return this.maxParallelConnections;
    }

    @ManagedAttribute(id="cacheEntries")
    private Map<ContactInfo<C>, OutboundCacheEntry<C>> entryMap() {
        return new HashMap<ContactInfo<C>, OutboundCacheEntry<C>>(this.entryMap);
    }

    @ManagedAttribute(id="connections")
    private Map<C, OutboundConnectionState<C>> connectionMap() {
        return new HashMap<C, OutboundConnectionState<C>>(this.connectionMap);
    }

    @Override
    protected String thisClassName() {
        return "OutboundConnectionCacheBlockingImpl";
    }

    public OutboundConnectionCacheBlockingImpl(String cacheType, int highWaterMark, int numberToReclaim, int maxParallelConnections, long ttl) {
        super(cacheType, highWaterMark, numberToReclaim, ttl);
        if (maxParallelConnections < 1) {
            throw new IllegalArgumentException("maxParallelConnections must be > 0");
        }
        this.maxParallelConnections = maxParallelConnections;
        this.entryMap = new HashMap<ContactInfo<C>, OutboundCacheEntry<C>>();
        this.connectionMap = new HashMap<C, OutboundConnectionState<C>>();
        this.reclaimableConnections = ConcurrentQueueFactory.makeConcurrentQueue(ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canCreateNewConnection(ContactInfo<C> cinfo) {
        this.lock.lock();
        try {
            OutboundCacheEntry<C> entry = this.entryMap.get(cinfo);
            if (entry == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.internalCanCreateNewConnection(entry);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalCanCreateNewConnection(OutboundCacheEntry<C> entry) {
        this.lock.lock();
        try {
            boolean createNewConnection;
            boolean bl = createNewConnection = entry.totalConnections() == 0 || this.numberOfConnections() < (long)this.highWaterMark() && entry.totalConnections() < this.maxParallelConnections;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public C get(ContactInfo<C> cinfo) throws IOException {
        return this.get(cinfo, null);
    }

    @InfoMethod
    private void msg(String m) {
    }

    @InfoMethod
    private void display(String m, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public C get(ContactInfo<C> cinfo, ConnectionFinder<C> finder) throws IOException {
        this.lock.lock();
        Connection result = null;
        try {
            OutboundCacheEntry<C> entry;
            while (true) {
                entry = this.getEntry(cinfo);
                if (finder != null) {
                    this.msg("calling finder to get a connection");
                    entry.startConnect();
                    this.lock.unlock();
                    try {
                        result = finder.find(cinfo, entry.idleConnectionsView, entry.busyConnectionsView);
                    }
                    finally {
                        this.lock.lock();
                        entry.finishConnect();
                    }
                    if (result != null) {
                        this.display("finder got connection", result);
                    }
                }
                if (result == null) {
                    result = (Connection)entry.idleConnections.poll();
                }
                if (result == null) {
                    result = this.tryNewConnection(entry, cinfo);
                }
                if (result == null) {
                    result = (Connection)entry.busyConnections.poll();
                }
                if (result != null) break;
                this.msg("No connection available: awaiting a pending connection");
                entry.waitForConnection();
            }
            OutboundConnectionState<Connection> cs = this.getConnectionState(cinfo, entry, result);
            if (!cs.isBusy()) {
                if (cs.isIdle()) {
                    ++this.totalBusy;
                    this.decrementTotalIdle();
                } else {
                    ++this.totalBusy;
                }
            }
            cs.acquire();
        }
        finally {
            this.display("totalIdle", this.totalIdle);
            this.display("totalBusy", this.totalBusy);
            this.lock.unlock();
        }
        return (C)result;
    }

    @Transport
    private OutboundCacheEntry<C> getEntry(ContactInfo<C> cinfo) throws IOException {
        OutboundCacheEntry<C> result = null;
        result = this.entryMap.get(cinfo);
        if (result == null) {
            result = new OutboundCacheEntry(this.lock);
            this.display("creating new OutboundCacheEntry", result);
            this.entryMap.put(cinfo, result);
        } else {
            this.display("re-using existing OutboundCacheEntry", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private C tryNewConnection(OutboundCacheEntry<C> entry, ContactInfo<C> cinfo) throws IOException {
        C conn = null;
        if (this.internalCanCreateNewConnection(entry)) {
            entry.startConnect();
            this.lock.unlock();
            try {
                conn = cinfo.createConnection();
            }
            finally {
                this.lock.lock();
                entry.finishConnect();
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transport
    private OutboundConnectionState<C> getConnectionState(ContactInfo<C> cinfo, OutboundCacheEntry<C> entry, C conn) {
        this.lock.lock();
        try {
            OutboundConnectionState<C> cs = this.connectionMap.get(conn);
            if (cs == null) {
                cs = new OutboundConnectionState<C>(cinfo, entry, conn);
                this.display("creating new OutboundConnectionState ", cs);
                this.connectionMap.put(conn, cs);
            } else {
                this.display("found OutboundConnectionState ", cs);
            }
            OutboundConnectionState<C> outboundConnectionState = cs;
            return outboundConnectionState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void release(C conn, int numResponsesExpected) {
        this.lock.lock();
        OutboundConnectionState<C> cs = null;
        try {
            cs = this.connectionMap.get(conn);
            if (cs == null) {
                this.msg("connection was already closed");
                return;
            }
            int numResp = cs.release(numResponsesExpected);
            this.display("numResponsesExpected", numResponsesExpected);
            if (!cs.isBusy()) {
                boolean connectionClosed = false;
                if (numResp == 0) {
                    connectionClosed = this.reclaimOrClose(cs, conn);
                }
                this.decrementTotalBusy();
                if (!connectionClosed) {
                    this.msg("idle connection queued");
                    ++this.totalIdle;
                }
            }
        }
        finally {
            this.display("cs", cs);
            this.display("totalIdle", this.totalIdle);
            this.display("totalBusy", this.totalBusy);
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void responseReceived(C conn) {
        this.lock.lock();
        try {
            OutboundConnectionState<C> cs = this.connectionMap.get(conn);
            if (cs == null) {
                this.msg("response received on closed connection");
                return;
            }
            if (cs.responseReceived()) {
                this.reclaimOrClose(cs, conn);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Transport
    private boolean reclaimOrClose(OutboundConnectionState<C> cs, C conn) {
        boolean isOverflow;
        boolean bl = isOverflow = this.numberOfConnections() > (long)this.highWaterMark();
        if (isOverflow) {
            this.msg("closing overflow connection");
            this.close(conn);
        } else {
            this.msg("queuing reclaimable connection");
            cs.setReclaimableHandle(this.reclaimableConnections.offer(conn));
        }
        return isOverflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void close(C conn) {
        this.lock.lock();
        try {
            OutboundConnectionState<C> cs = this.connectionMap.remove(conn);
            if (cs == null) {
                this.msg("connection was already closed");
                return;
            }
            this.display("cs", cs);
            if (cs.isBusy()) {
                this.msg("connection removed from busy connections");
                this.decrementTotalBusy();
            } else if (cs.isIdle()) {
                this.msg("connection removed from idle connections");
                this.decrementTotalIdle();
            }
            try {
                cs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Transport
    private void decrementTotalIdle() {
        if (this.totalIdle > 0) {
            --this.totalIdle;
        } else {
            this.msg("ERROR: was already 0!");
        }
    }

    @Transport
    private void decrementTotalBusy() {
        if (this.totalBusy > 0) {
            --this.totalBusy;
        } else {
            this.msg("ERROR: count was already 0!");
        }
    }
}

