/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.cdi.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.binding.BindingBuilder;
import org.glassfish.hk2.utilities.binding.ScopedBindingBuilder;
import org.glassfish.hk2.utilities.binding.ServiceBindingBuilder;
import org.glassfish.hk2.utilities.cache.Cache;
import org.glassfish.hk2.utilities.cache.Computable;
import org.glassfish.jersey.gf.cdi.internal.InjecteeSkippingAnalyzer;
import org.glassfish.jersey.gf.cdi.internal.LocalizationMessages;
import org.glassfish.jersey.gf.cdi.internal.TransactionalExceptionMapper;
import org.glassfish.jersey.gf.cdi.internal.WebAppExceptionHolder;
import org.glassfish.jersey.gf.cdi.internal.WebAppExceptionInterceptor;
import org.glassfish.jersey.gf.cdi.spi.Hk2CustomBoundTypesProvider;
import org.glassfish.jersey.internal.ServiceConfigurationError;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.model.internal.RankedProvider;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.spi.ComponentProvider;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Priority(value=200)
public class CdiComponentProvider
implements ComponentProvider,
Extension {
    private static final Logger LOGGER = Logger.getLogger(CdiComponentProvider.class.getName());
    public static final String CDI_CLASS_ANALYZER = "CdiInjecteeSkippingClassAnalyzer";
    static final String TRANSACTIONAL_WAE = "org.glassfish.jersey.cdi.transactional.wae";
    private ServiceLocator locator;
    private BeanManager beanManager;
    private Map<Class<?>, Set<Method>> methodsToSkip = new HashMap();
    private Map<Class<?>, Set<Field>> fieldsToSkip = new HashMap();
    private final Hk2CustomBoundTypesProvider customHk2TypesProvider = this.lookupHk2CustomBoundTypesProvider();
    private final Set<Type> hk2ProvidedTypes = Collections.synchronizedSet(new HashSet());
    private final Set<Type> jerseyVetoedTypes = Collections.synchronizedSet(new HashSet());

    public void initialize(ServiceLocator locator) {
        CdiComponentProvider extension;
        this.locator = locator;
        this.beanManager = CdiComponentProvider.beanManagerFromJndi();
        if (this.beanManager != null && (extension = (CdiComponentProvider)this.beanManager.getExtension(this.getClass())) != null) {
            extension.locator = this.locator;
            this.fieldsToSkip = extension.fieldsToSkip;
            this.methodsToSkip = extension.methodsToSkip;
            LOGGER.config(LocalizationMessages.CDI_PROVIDER_INITIALIZED());
        }
    }

    public boolean bind(Class<?> clazz, Set<Class<?>> providerContracts) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(LocalizationMessages.CDI_CLASS_BEING_CHECKED(clazz));
        }
        if (this.beanManager == null) {
            return false;
        }
        if (CdiComponentProvider.isJerseyOrDependencyType(clazz)) {
            return false;
        }
        boolean isCdiManaged = this.isCdiComponent(clazz);
        boolean isManagedBean = this.isManagedBean(clazz);
        boolean isJaxRsComponent = CdiComponentProvider.isJaxRsComponentType(clazz);
        if (!(isCdiManaged || isManagedBean || isJaxRsComponent)) {
            return false;
        }
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        ServiceBindingBuilder bindingBuilder = Injections.newFactoryBinder(new CdiFactory(clazz, this.locator, this.beanManager, isCdiManaged));
        bindingBuilder.to(clazz);
        for (Class<?> contract : providerContracts) {
            bindingBuilder.to(contract);
        }
        Injections.addBinding((BindingBuilder)bindingBuilder, (DynamicConfiguration)dc);
        dc.commit();
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(LocalizationMessages.CDI_CLASS_BOUND_WITH_CDI(clazz));
        }
        return true;
    }

    public void done() {
        if (this.beanManager != null) {
            this.bindHk2ClassAnalyzer();
            this.bindWaeRestoringExceptionMapper();
        }
    }

    private void bindWaeRestoringExceptionMapper() {
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        ServiceBindingBuilder bindingBuilder = Injections.newFactoryBinder(new CdiFactory<TransactionalExceptionMapper>(TransactionalExceptionMapper.class, this.locator, this.beanManager, true));
        bindingBuilder.to(ExceptionMapper.class);
        Injections.addBinding((BindingBuilder)bindingBuilder, (DynamicConfiguration)dc);
        dc.commit();
    }

    private boolean isCdiComponent(Class<?> component) {
        Annotation[] qualifiers = CdiComponentProvider.getQualifiers(component.getAnnotations());
        return !this.beanManager.getBeans(component, qualifiers).isEmpty();
    }

    private static Annotation[] getQualifiers(Annotation[] annotations) {
        ArrayList<Annotation> result = new ArrayList<Annotation>(annotations.length);
        for (Annotation a : annotations) {
            if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            result.add(a);
        }
        return result.toArray(new Annotation[result.size()]);
    }

    private boolean isManagedBean(Class<?> component) {
        return component.isAnnotationPresent(ManagedBean.class);
    }

    private static AnnotatedConstructor<?> enrichedConstructor(final AnnotatedConstructor<?> ctor) {
        return new AnnotatedConstructor(){

            public Constructor getJavaMember() {
                return ctor.getJavaMember();
            }

            public List<AnnotatedParameter> getParameters() {
                ArrayList<AnnotatedParameter> parameters = new ArrayList<AnnotatedParameter>(ctor.getParameters().size());
                for (final AnnotatedParameter ap : ctor.getParameters()) {
                    parameters.add(new AnnotatedParameter(){

                        public int getPosition() {
                            return ap.getPosition();
                        }

                        public AnnotatedCallable getDeclaringCallable() {
                            return ap.getDeclaringCallable();
                        }

                        public Type getBaseType() {
                            return ap.getBaseType();
                        }

                        public Set<Type> getTypeClosure() {
                            return ap.getTypeClosure();
                        }

                        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                            if (annotationType == JaxRsParamProducer.JaxRsParamQualifier.class) {
                                return (T)(this.isJaxRsParamAnnotationPresent() ? JaxRsParamProducer.JaxRsParamQUALIFIER : null);
                            }
                            return (T)ap.getAnnotation(annotationType);
                        }

                        public Set<Annotation> getAnnotations() {
                            HashSet<Annotation> result = new HashSet<Annotation>();
                            for (Annotation a : ap.getAnnotations()) {
                                result.add(a);
                                Class<? extends Annotation> annotationType = a.annotationType();
                                if (!JaxRsParamProducer.JaxRsParamAnnotationTYPES.contains(annotationType)) continue;
                                result.add(JaxRsParamProducer.JaxRsParamQUALIFIER);
                            }
                            return result;
                        }

                        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                            return annotationType == JaxRsParamProducer.JaxRsParamQualifier.class && this.isJaxRsParamAnnotationPresent() || ap.isAnnotationPresent(annotationType);
                        }

                        private boolean isJaxRsParamAnnotationPresent() {
                            for (Class<? extends Annotation> a : JaxRsParamProducer.JaxRsParamAnnotationTYPES) {
                                if (!ap.isAnnotationPresent(a)) continue;
                                return true;
                            }
                            return false;
                        }
                    });
                }
                return parameters;
            }

            public boolean isStatic() {
                return ctor.isStatic();
            }

            public AnnotatedType getDeclaringType() {
                return ctor.getDeclaringType();
            }

            public Type getBaseType() {
                return ctor.getBaseType();
            }

            public Set<Type> getTypeClosure() {
                return ctor.getTypeClosure();
            }

            public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                return (T)ctor.getAnnotation(annotationType);
            }

            public Set<Annotation> getAnnotations() {
                return ctor.getAnnotations();
            }

            public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                return ctor.isAnnotationPresent(annotationType);
            }
        };
    }

    private void processAnnotatedType(@Observes ProcessAnnotatedType processAnnotatedType) {
        final AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        if (this.customHk2TypesProvider != null) {
            Type baseType = annotatedType.getBaseType();
            if (this.customHk2TypesProvider.getHk2Types().contains(baseType)) {
                processAnnotatedType.veto();
                this.jerseyVetoedTypes.add(baseType);
            }
        }
        if (this.containsJaxRsParameterizedCtor(annotatedType)) {
            processAnnotatedType.setAnnotatedType(new AnnotatedType(){

                public Class getJavaClass() {
                    return annotatedType.getJavaClass();
                }

                public Set<AnnotatedConstructor> getConstructors() {
                    HashSet<AnnotatedConstructor> result = new HashSet<AnnotatedConstructor>();
                    for (AnnotatedConstructor c : annotatedType.getConstructors()) {
                        result.add(CdiComponentProvider.enrichedConstructor(c));
                    }
                    return result;
                }

                public Set getMethods() {
                    return annotatedType.getMethods();
                }

                public Set getFields() {
                    return annotatedType.getFields();
                }

                public Type getBaseType() {
                    return annotatedType.getBaseType();
                }

                public Set<Type> getTypeClosure() {
                    return annotatedType.getTypeClosure();
                }

                public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
                    return (T)annotatedType.getAnnotation(annotationType);
                }

                public Set<Annotation> getAnnotations() {
                    return annotatedType.getAnnotations();
                }

                public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                    return annotatedType.isAnnotationPresent(annotationType);
                }
            });
        }
    }

    private boolean containsJaxRsParameterizedCtor(AnnotatedType annotatedType) {
        for (AnnotatedConstructor c : annotatedType.getConstructors()) {
            for (AnnotatedParameter p : c.getParameters()) {
                for (Class<? extends Annotation> a : JaxRsParamProducer.JaxRsParamAnnotationTYPES) {
                    if (!p.isAnnotationPresent(a)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void afterTypeDiscovery(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        List interceptors = afterTypeDiscovery.getInterceptors();
        interceptors.add(WebAppExceptionInterceptor.class);
        if (LOGGER.isLoggable(Level.CONFIG) && !this.jerseyVetoedTypes.isEmpty()) {
            LOGGER.config(LocalizationMessages.CDI_TYPE_VETOED(this.customHk2TypesProvider, this.listTypes(new StringBuilder().append("\n"), this.jerseyVetoedTypes).toString()));
        }
    }

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(JaxRsParamProducer.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(WebAppExceptionHolder.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(WebAppExceptionInterceptor.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TransactionalExceptionMapper.class));
    }

    private void processInjectionTarget(@Observes ProcessInjectionTarget event) {
        InjectionTarget it = event.getInjectionTarget();
        Class componentClass = event.getAnnotatedType().getJavaClass();
        final Set<InjectionPoint> cdiInjectionPoints = this.filterHk2InjectionPointsOut(it.getInjectionPoints());
        for (InjectionPoint injectionPoint : cdiInjectionPoints) {
            Member member = injectionPoint.getMember();
            if (member instanceof Field) {
                this.addInjecteeToSkip(componentClass, this.fieldsToSkip, (Field)member);
                continue;
            }
            if (!(member instanceof Method)) continue;
            this.addInjecteeToSkip(componentClass, this.methodsToSkip, (Method)member);
        }
        if (CdiComponentProvider.isJerseyOrDependencyType(componentClass)) {
            event.setInjectionTarget((InjectionTarget)new CdiInjectionTarget(it){

                @Override
                public Set getInjectionPoints() {
                    return Collections.emptySet();
                }
            });
        } else if (CdiComponentProvider.isJaxRsComponentType(componentClass)) {
            event.setInjectionTarget((InjectionTarget)new CdiInjectionTarget(it){

                @Override
                public Set getInjectionPoints() {
                    return cdiInjectionPoints;
                }
            });
        }
    }

    private Set<InjectionPoint> filterHk2InjectionPointsOut(Set<InjectionPoint> originalInjectionPoints) {
        HashSet<InjectionPoint> filteredInjectionPoints = new HashSet<InjectionPoint>();
        for (InjectionPoint ip : originalInjectionPoints) {
            Type injectedType = ip.getType();
            if (this.customHk2TypesProvider != null && this.customHk2TypesProvider.getHk2Types().contains(injectedType)) {
                this.hk2ProvidedTypes.add(injectedType);
                continue;
            }
            if (injectedType instanceof Class) {
                Class injectedClass = (Class)injectedType;
                if (injectedClass != WebAppExceptionHolder.class && CdiComponentProvider.isJerseyOrDependencyType(injectedClass)) {
                    this.hk2ProvidedTypes.add(injectedType);
                    continue;
                }
                filteredInjectionPoints.add(ip);
                continue;
            }
            if (this.isInjectionProvider(injectedType) && this.isProviderOfJerseyType((ParameterizedType)injectedType)) {
                this.hk2ProvidedTypes.add(((ParameterizedType)injectedType).getActualTypeArguments()[0]);
                continue;
            }
            filteredInjectionPoints.add(ip);
        }
        return filteredInjectionPoints;
    }

    private boolean isInjectionProvider(Type injectedType) {
        return injectedType instanceof ParameterizedType && ((ParameterizedType)injectedType).getRawType() == Provider.class;
    }

    private boolean isProviderOfJerseyType(ParameterizedType provider) {
        Type firstArgumentType = provider.getActualTypeArguments()[0];
        if (firstArgumentType instanceof Class && CdiComponentProvider.isJerseyOrDependencyType((Class)firstArgumentType)) {
            return true;
        }
        return this.customHk2TypesProvider != null && this.customHk2TypesProvider.getHk2Types().contains(firstArgumentType);
    }

    private void afterDiscoveryObserver(@Observes AfterBeanDiscovery abd) {
        if (this.customHk2TypesProvider != null) {
            this.hk2ProvidedTypes.addAll(this.customHk2TypesProvider.getHk2Types());
        }
        for (Type t : this.hk2ProvidedTypes) {
            abd.addBean((Bean)new Hk2Bean(t));
        }
    }

    private Hk2CustomBoundTypesProvider lookupHk2CustomBoundTypesProvider() throws ServiceConfigurationError {
        LinkedList<RankedProvider> providers = new LinkedList<RankedProvider>();
        for (Hk2CustomBoundTypesProvider provider : ServiceFinder.find(Hk2CustomBoundTypesProvider.class)) {
            providers.add(new RankedProvider((Object)provider));
        }
        Collections.sort(providers, new RankedComparator(RankedComparator.Order.DESCENDING));
        return providers.isEmpty() ? null : (Hk2CustomBoundTypesProvider)((RankedProvider)providers.get(0)).getProvider();
    }

    private Set<Type> _getContracts(Set<Type> types) {
        HashSet<Type> result = new HashSet<Type>();
        for (Type t : types) {
            Class c;
            if (!(t instanceof Class) || (c = (Class)t).isPrimitive() || c.isSynthetic()) continue;
            this._addDerivedContracts(c, result);
        }
        return result;
    }

    private void _addDerivedContracts(Type t, Set<Type> result) {
        if (t == null || t == Object.class) {
            return;
        }
        result.add(t);
        if (t instanceof Class) {
            Class<?>[] interfaces;
            Class c = (Class)t;
            for (Class<?> i : interfaces = c.getInterfaces()) {
                this._addDerivedContracts(i, result);
            }
            Type superclass = c.getGenericSuperclass();
            this._addDerivedContracts(superclass, result);
        }
    }

    private <T> void addInjecteeToSkip(Class<?> componentClass, Map<Class<?>, Set<T>> toSkip, T member) {
        if (!toSkip.containsKey(componentClass)) {
            toSkip.put(componentClass, new HashSet());
        }
        toSkip.get(componentClass).add(member);
    }

    static boolean isJaxRsComponentType(Class<?> clazz) {
        return Application.class.isAssignableFrom(clazz) || Providers.isJaxRsProvider(clazz) || Resource.from(clazz) != null;
    }

    private static boolean isJerseyOrDependencyType(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isSynthetic()) {
            return false;
        }
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            LOGGER.warning(String.format("Class %s has null package", clazz));
            return false;
        }
        String pkgName = pkg.getName();
        return pkgName.contains("org.glassfish.hk2") || pkgName.contains("jersey.repackaged") || pkgName.contains("org.jvnet.hk2") || pkgName.startsWith("org.glassfish.jersey") && !pkgName.startsWith("org.glassfish.jersey.examples") && !pkgName.startsWith("org.glassfish.jersey.tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BeanManager beanManagerFromJndi() {
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            BeanManager beanManager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
            return beanManager;
        }
        catch (Exception ex) {
            try {
                BeanManager ignored = CDI.current().getBeanManager();
                return ignored;
            }
            catch (Exception e) {
                LOGGER.config(LocalizationMessages.CDI_BEAN_MANAGER_JNDI_LOOKUP_FAILED());
                BeanManager beanManager = null;
                return beanManager;
            }
        }
        finally {
            if (initialContext != null) {
                try {
                    initialContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private void bindHk2ClassAnalyzer() {
        ClassAnalyzer defaultClassAnalyzer = (ClassAnalyzer)this.locator.getService(ClassAnalyzer.class, "default", new Annotation[0]);
        int skippedElements = this.methodsToSkip.size() + this.fieldsToSkip.size();
        ClassAnalyzer customizedClassAnalyzer = skippedElements > 0 ? new InjecteeSkippingAnalyzer(defaultClassAnalyzer, this.methodsToSkip, this.fieldsToSkip) : defaultClassAnalyzer;
        DynamicConfiguration dc = Injections.getConfiguration((ServiceLocator)this.locator);
        ScopedBindingBuilder bindingBuilder = Injections.newBinder((Object)customizedClassAnalyzer);
        bindingBuilder.analyzeWith("default").to(ClassAnalyzer.class).named(CDI_CLASS_ANALYZER);
        Injections.addBinding((BindingBuilder)bindingBuilder, (DynamicConfiguration)dc);
        dc.commit();
    }

    private StringBuilder listTypes(StringBuilder logMsgBuilder, Collection<Type> types) {
        for (Type t : types) {
            logMsgBuilder.append(String.format(" - %s\n", t));
        }
        return logMsgBuilder;
    }

    public static class CdiDefaultAnnotation
    extends AnnotationLiteral<Default>
    implements Default {
    }

    private static class CdiFactory<T>
    implements Factory<T> {
        final Class<T> clazz;
        final BeanManager beanManager;
        final ServiceLocator locator;
        final InstanceManager<T> referenceProvider;
        final Annotation[] qualifiers;

        public T provide() {
            T instance = this.referenceProvider.getInstance(this.clazz);
            if (instance != null) {
                return instance;
            }
            throw new NoSuchElementException(LocalizationMessages.CDI_LOOKUP_FAILED(this.clazz));
        }

        public void dispose(T instance) {
            this.referenceProvider.preDestroy(instance);
        }

        CdiFactory(Class<T> rawType, final ServiceLocator locator, final BeanManager beanManager, boolean cdiManaged) {
            this.clazz = rawType;
            this.qualifiers = CdiComponentProvider.getQualifiers(this.clazz.getAnnotations());
            this.beanManager = beanManager;
            this.locator = locator;
            this.referenceProvider = cdiManaged ? new InstanceManager<T>(){

                @Override
                public T getInstance(Class<T> clazz) {
                    Set beans = beanManager.getBeans(clazz, CdiFactory.this.qualifiers);
                    Iterator i$ = beans.iterator();
                    if (i$.hasNext()) {
                        Bean b = (Bean)i$.next();
                        Object instance = beanManager.getReference(b, clazz, beanManager.createCreationalContext((Contextual)b));
                        return instance;
                    }
                    return null;
                }

                @Override
                public void preDestroy(T instance) {
                }
            } : new InstanceManager<T>(){
                final AnnotatedType<T> annotatedType;
                final InjectionTargetFactory<T> injectionTargetFactory;
                final InjectionTarget<T> injectionTarget;
                final CreationalContext<T> creationalContext;
                {
                    this.annotatedType = beanManager.createAnnotatedType(CdiFactory.this.clazz);
                    this.injectionTargetFactory = beanManager.getInjectionTargetFactory(this.annotatedType);
                    this.injectionTarget = this.injectionTargetFactory.createInjectionTarget(null);
                    this.creationalContext = beanManager.createCreationalContext(null);
                }

                @Override
                public T getInstance(Class<T> clazz) {
                    Object instance = this.injectionTarget.produce(this.creationalContext);
                    this.injectionTarget.inject(instance, this.creationalContext);
                    if (locator != null) {
                        locator.inject(instance, CdiComponentProvider.CDI_CLASS_ANALYZER);
                    }
                    this.injectionTarget.postConstruct(instance);
                    return instance;
                }

                @Override
                public void preDestroy(T instance) {
                    this.injectionTarget.preDestroy(instance);
                }
            };
        }

        private static interface InstanceManager<T> {
            public T getInstance(Class<T> var1);

            public void preDestroy(T var1);
        }
    }

    private abstract class CdiInjectionTarget
    implements InjectionTarget {
        private final InjectionTarget delegate;

        protected CdiInjectionTarget(InjectionTarget delegate) {
            this.delegate = delegate;
        }

        public void inject(Object t, CreationalContext cc) {
            this.delegate.inject(t, cc);
            if (CdiComponentProvider.this.locator != null) {
                CdiComponentProvider.this.locator.inject(t, CdiComponentProvider.CDI_CLASS_ANALYZER);
            }
        }

        public void postConstruct(Object t) {
            this.delegate.postConstruct(t);
        }

        public void preDestroy(Object t) {
            this.delegate.preDestroy(t);
        }

        public Object produce(CreationalContext cc) {
            return this.delegate.produce(cc);
        }

        public void dispose(Object t) {
            this.delegate.dispose(t);
        }

        public abstract Set getInjectionPoints();
    }

    private class Hk2Bean
    implements Bean {
        private final Type t;

        public Hk2Bean(Type t) {
            this.t = t;
        }

        public Class getBeanClass() {
            return (Class)this.t;
        }

        public Set getInjectionPoints() {
            return Collections.emptySet();
        }

        public boolean isNullable() {
            return true;
        }

        public Object create(CreationalContext creationalContext) {
            return CdiComponentProvider.this.locator.getService(this.t, new Annotation[0]);
        }

        public void destroy(Object instance, CreationalContext creationalContext) {
        }

        public Set getTypes() {
            return Collections.singleton(this.t);
        }

        public Set getQualifiers() {
            return Collections.singleton(new CdiDefaultAnnotation());
        }

        public Class getScope() {
            return Dependent.class;
        }

        public String getName() {
            return this.t.toString();
        }

        public Set getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }
    }

    @ApplicationScoped
    public static class JaxRsParamProducer {
        private static final JaxRsParamQualifier JaxRsParamQUALIFIER = new JaxRsParamQualifier(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return JaxRsParamQualifier.class;
            }
        };
        static final Set<Class<? extends Annotation>> JaxRsParamAnnotationTYPES = new HashSet<Class<? extends Annotation>>(){
            {
                this.add(PathParam.class);
                this.add(QueryParam.class);
                this.add(CookieParam.class);
                this.add(HeaderParam.class);
                this.add(MatrixParam.class);
            }
        };
        final Cache<InjectionPoint, Parameter> parameterCache = new Cache((Computable)new Computable<InjectionPoint, Parameter>(){

            public Parameter compute(InjectionPoint injectionPoint) {
                AnnotatedParameter annotatedParameter;
                AnnotatedCallable callable;
                Annotated annotated = injectionPoint.getAnnotated();
                Class<?> clazz = injectionPoint.getMember().getDeclaringClass();
                if (annotated instanceof AnnotatedParameter && (callable = (annotatedParameter = (AnnotatedParameter)annotated).getDeclaringCallable()) instanceof AnnotatedConstructor) {
                    AnnotatedConstructor ac = (AnnotatedConstructor)callable;
                    int position = annotatedParameter.getPosition();
                    List parameters = Parameter.create(clazz, clazz, (Constructor)ac.getJavaMember(), (boolean)false);
                    return (Parameter)parameters.get(position);
                }
                return null;
            }
        });

        @Produces
        @JaxRsParamQualifier
        public String getParameterValue(InjectionPoint injectionPoint, BeanManager beanManager) {
            Parameter parameter = (Parameter)this.parameterCache.compute((Object)injectionPoint);
            if (parameter != null) {
                ServiceLocator locator = ((CdiComponentProvider)beanManager.getExtension(CdiComponentProvider.class)).locator;
                Set providers = Providers.getProviders((ServiceLocator)locator, ValueFactoryProvider.class);
                for (ValueFactoryProvider vfp : providers) {
                    Factory valueFactory = vfp.getValueFactory(parameter);
                    if (valueFactory == null) continue;
                    return (String)valueFactory.provide();
                }
            }
            return null;
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
        public static @interface JaxRsParamQualifier {
        }
    }
}

