/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.transport.tcp;

import com.sun.xml.ws.transport.tcp.server.TCPMessageListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.webservices.transport.tcp.Connector;
import org.glassfish.webservices.transport.tcp.LogUtils;
import org.glassfish.webservices.transport.tcp.V3Module;

public class WSTCPProtocolFilter
extends BaseFilter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private volatile Connector connector;
    private final Object sync = new Object();
    private static final V3Module module = new V3Module();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        NIOConnection connection = (NIOConnection)ctx.getConnection();
        if (this.connector == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.connector == null) {
                    InetSocketAddress socketAddress = (InetSocketAddress)connection.getPeerAddress();
                    String host = socketAddress.getHostName();
                    int port = socketAddress.getPort();
                    LOGGER.log(Level.INFO, "AS-WSSOAPTCP-00001", port);
                    this.connector = new Connector(host, port, (TCPMessageListener)module.getDelegate());
                }
            }
        }
        Buffer buffer = (Buffer)ctx.getMessage();
        ByteBuffer byteBuffer = buffer.toByteBuffer();
        SocketChannel channel = (SocketChannel)connection.getChannel();
        this.connector.process(byteBuffer, channel);
        return ctx.getStopAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        block7: {
            Connection connection = ctx.getConnection();
            SelectionKey selectionKey = ((NIOConnection)connection).getSelectionKey();
            try {
                if (this.connector != null) {
                    this.connector.notifyConnectionClosed((SocketChannel)selectionKey.channel());
                    break block7;
                }
                Object object = this.sync;
                synchronized (object) {
                    if (this.connector != null) {
                        this.connector.notifyConnectionClosed((SocketChannel)selectionKey.channel());
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ctx.getInvokeAction();
    }
}

