/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.SharedConnection;
import com.sun.messaging.bridge.service.jms.SharedConnectionImpl;
import com.sun.messaging.bridge.service.jms.SharedXAConnectionImpl;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;

public class SharedConnectionFactory
implements Runnable {
    private Logger _logger = null;
    private Object _cf = null;
    private int _idleTimeout = 0;
    private int _maxRetries = 0;
    private int _retryInterval = 0;
    private final int _closeWaittime = 15;
    private ScheduledExecutorService _scheduler = null;
    private final ReentrantLock _lock = new ReentrantLock();
    private final Condition _refcnt0 = this._lock.newCondition();
    private SharedConnection _conn = null;
    private int _refcnt = 0;
    private ScheduledFuture _future = null;
    private boolean _closed = false;
    private String _username = null;
    private String _password = null;
    private EventNotifier _notifier = new EventNotifier();
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public SharedConnectionFactory(Object cf, Properties attrs, Logger logger) throws Exception {
        this._cf = cf;
        this._logger = logger;
        String val = attrs.getProperty("username");
        if (val != null) {
            this._username = val.trim();
            this._password = attrs.getProperty("password");
        }
        this._idleTimeout = Integer.valueOf(attrs.getProperty("idle-timeout-in-seconds", "1800"));
        if (this._idleTimeout < 0) {
            this._idleTimeout = 0;
        }
        this._maxRetries = Integer.valueOf(attrs.getProperty("connect-attempts", "-1"));
        this._retryInterval = Integer.valueOf(attrs.getProperty("connect-attempt-interval-in-seconds", "5"));
        if (this._retryInterval < 0) {
            this._retryInterval = 0;
        }
        this._scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection obtainConnection(Connection c, String logstr, Object caller, boolean doReconnect) throws Exception {
        this._lock.lockInterruptibly();
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Obtaining shared connection from shared connection factory " + this);
        }
        if (this._closed) {
            if (c == null) {
                throw new JMSException(_jbr.getString("BSJ4028", this.toString()));
            }
            try {
                c.close();
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to close conneciton from shared connection factory " + this);
            }
            throw new JMSException(_jbr.getString("BSJ4028", this.toString()));
        }
        if (c != null) {
            this._conn = c instanceof XAConnection ? new SharedXAConnectionImpl((XAConnection)c) : new SharedConnectionImpl(c);
        }
        if (this._conn != null && !this._conn.isValid()) {
            try {
                this._logger.log(Level.INFO, _jbr.getString("BSJ1048", c.toString(), this.toString()));
                ((Connection)((Object)this._conn)).close();
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Unable to close invalid connection " + this._conn + " from shared connection factory " + this);
            }
            this._conn = null;
        }
        try {
            if (this._conn == null) {
                Connection cn = null;
                EventListener l = new EventListener(this);
                try {
                    this._notifier.addEventListener(EventListener.EventType.CONN_CLOSE, l);
                    cn = JMSBridge.openConnection(this._cf, this._maxRetries, this._retryInterval, this._username, this._password, logstr, caller, l, this._logger, doReconnect);
                }
                finally {
                    this._notifier.removeEventListener(l);
                }
                this._conn = this._cf instanceof XAConnectionFactory ? new SharedXAConnectionImpl((XAConnection)cn) : new SharedConnectionImpl(cn);
            }
            if (this._closed) {
                try {
                    ((Connection)((Object)this._conn)).close();
                }
                catch (Exception e) {
                    this._logger.log(Level.FINE, "Exception on closing connection " + this._conn + ": " + e.getMessage());
                }
                this._conn = null;
                throw new JMSException(_jbr.getString("BSJ4028", this.toString()));
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Increment refcnt in shared connection factory " + this);
            }
            ++this._refcnt;
            if (this._future != null) {
                this._future.cancel(true);
                this._future = null;
            }
        }
        finally {
            this._lock.unlock();
        }
        return (Connection)((Object)this._conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(Connection conn) throws Exception {
        this._lock.lock();
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Decrement refcnt in shared connection factory " + this);
            }
            --this._refcnt;
            assert (this._refcnt >= 0);
            if (this._refcnt == 0 && this._idleTimeout > 0) {
                if (this._future != null) {
                    this._future.cancel(true);
                }
                this._logger.log(Level.INFO, _jbr.getString("BSJ1049", this._idleTimeout, this.toString()));
                this._future = this._scheduler.schedule(this, (long)this._idleTimeout, TimeUnit.SECONDS);
            }
            if (this._refcnt == 0) {
                this._refcnt0.signalAll();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Check idle timeout in shared connection factory " + this);
        }
        try {
            this._lock.lockInterruptibly();
        }
        catch (Throwable t) {
            this._logger.log(Level.WARNING, "Unable to get lock for idle connection check in shared connection factory " + this + ": " + t.getMessage());
            return;
        }
        try {
            if (this._refcnt > 0) {
                return;
            }
            this._logger.log(Level.INFO, _jbr.getString("BSJ1050", this._conn.toString(), this.toString()));
            try {
                ((Connection)((Object)this._conn)).close();
                this._conn = null;
            }
            catch (Throwable t) {
                try {
                    this._logger.log(Level.WARNING, "Exception in closing idle timed out shared connection: " + t.getMessage() + " in shared connection factory " + this);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this._conn = null;
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        this._closed = true;
        this._logger.log(Level.INFO, _jbr.getString("BSJ1051", this.toString()));
        this._notifier.notifyEvent(EventListener.EventType.CONN_CLOSE, this);
        this._scheduler.shutdownNow();
        boolean done = false;
        try {
            this._lock.lockInterruptibly();
            try {
                if (this._conn == null) {
                    return;
                }
                if (this._refcnt > 0) {
                    this._logger.log(Level.WARNING, "Force close shared connection factory " + this + " with outstanding reference count " + this._refcnt);
                }
                ((Connection)((Object)this._conn)).close();
                done = true;
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in closing shared connection " + e.getMessage());
            }
            finally {
                this._lock.unlock();
            }
        }
        finally {
            Connection c = (Connection)((Object)this._conn);
            try {
                if (c != null && !done) {
                    c.close();
                }
            }
            catch (Exception e) {
                this._logger.log(Level.FINE, "Exception in closing shared connection " + c + ": " + e.getMessage());
            }
        }
    }

    public Object getCF() {
        return this._cf;
    }

    public int getIdleTimeout() {
        return this._idleTimeout;
    }

    public int getMaxRetries() {
        return this._maxRetries;
    }

    public int getRetryInterval() {
        return this._retryInterval;
    }

    public int getRefCount() {
        return this._refcnt;
    }

    public String toString() {
        return this._cf + "[" + this._refcnt + "]";
    }
}

