/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.ejb;

import com.google.common.collect.SetMultimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.reflection.Reflections;

public class EjbDescriptors
implements Service,
Iterable<InternalEjbDescriptor<?>> {
    private final Map<String, InternalEjbDescriptor<?>> ejbByName;
    private final SetMultimap<Class<?>, String> ejbByClass;
    public static final EjbDescriptors EMPTY = new EjbDescriptors();

    /*
     * Exception decompiling
     */
    public EjbDescriptors() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> InternalEjbDescriptor<T> get(String beanName) {
        return (InternalEjbDescriptor)Reflections.cast(this.ejbByName.get(beanName));
    }

    public <T> void add(EjbDescriptor<T> ejbDescriptor) {
        InternalEjbDescriptor<T> internalEjbDescriptor = new InternalEjbDescriptor<T>(ejbDescriptor);
        this.ejbByName.put(ejbDescriptor.getEjbName(), internalEjbDescriptor);
        this.ejbByClass.put(ejbDescriptor.getBeanClass(), (Object)internalEjbDescriptor.getEjbName());
    }

    public boolean contains(String beanName) {
        return this.ejbByName.containsKey(beanName);
    }

    public boolean contains(Class<?> beanClass) {
        return this.ejbByClass.containsKey(beanClass);
    }

    public <T> InternalEjbDescriptor<T> getUnique(Class<T> beanClass) {
        Set ejbs = this.ejbByClass.get(beanClass);
        if (ejbs.size() > 1) {
            throw BeanLogger.LOG.tooManyEjbsForClass(beanClass, ejbs);
        }
        if (ejbs.size() == 0) {
            return null;
        }
        return this.get((String)ejbs.iterator().next());
    }

    public void addAll(Iterable<EjbDescriptor<?>> ejbDescriptors) {
        for (EjbDescriptor<?> ejbDescriptor : ejbDescriptors) {
            this.add(ejbDescriptor);
        }
    }

    public void clear() {
        this.ejbByName.clear();
    }

    @Override
    public Iterator<InternalEjbDescriptor<?>> iterator() {
        return this.ejbByName.values().iterator();
    }

    @Override
    public void cleanup() {
        this.ejbByClass.clear();
        this.ejbByName.clear();
    }
}

