/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Set;
import org.jboss.weld.resolution.AssignabilityRules;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.jboss.weld.util.reflection.Reflections;

public class EventTypeAssignabilityRules
implements AssignabilityRules {
    private static final EventTypeAssignabilityRules INSTANCE = new EventTypeAssignabilityRules();
    public static final Type[] EMPTY_TYPES = new Type[0];

    protected EventTypeAssignabilityRules() {
    }

    public static EventTypeAssignabilityRules instance() {
        return INSTANCE;
    }

    @Override
    public boolean isAssignableFrom(Type type1, Type type2) {
        Type requiredType = this.wrapWithinTypeHolder(type1);
        if (requiredType instanceof ActualTypeHolder) {
            return this.isAssignableFrom((ActualTypeHolder)requiredType, type2);
        }
        if (requiredType instanceof WildcardType) {
            return this.isAssignableFrom((WildcardType)requiredType, type2);
        }
        if (requiredType instanceof TypeVariable) {
            return this.isAssignableFrom((TypeVariable)requiredType, type2);
        }
        return false;
    }

    protected boolean isAssignableToAll(Type type1, Type[] types2) {
        return this.allAreAssignableFrom(types2, type1);
    }

    protected boolean isAssignableFromAll(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (this.isAssignableFrom(type1, type2)) continue;
            return false;
        }
        return true;
    }

    protected boolean allAreAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (this.isAssignableFrom(type, type2)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAssignableFrom(ActualTypeHolder requiredType, Type otherType) {
        TypeVariable typeVariable;
        if ((otherType = this.wrapWithinTypeHolder(otherType)) instanceof ActualTypeHolder) {
            return this.isAssignableFrom(requiredType, (ActualTypeHolder)otherType);
        }
        if (otherType instanceof TypeVariable && this.isTypeInsideBounds(requiredType, EMPTY_TYPES, (typeVariable = (TypeVariable)otherType).getBounds())) {
            return true;
        }
        if (otherType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)otherType;
            for (Type upperBound : wildcardType.getUpperBounds()) {
                if (this.isAssignableFrom(requiredType, upperBound)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isAssignableFrom(ActualTypeHolder requiredType, ActualTypeHolder otherTypeHolder) {
        return requiredType.getBoxedRawType().isAssignableFrom(otherTypeHolder.getBoxedRawType()) && this.areActualTypeArgumentsAssignableFrom(requiredType, otherTypeHolder.getActualTypeArguments());
    }

    protected boolean isAssignableFrom(WildcardType requiredType, Type beanType) {
        return this.isTypeInsideBounds(beanType, requiredType.getLowerBounds(), requiredType.getUpperBounds());
    }

    protected boolean isAssignableFrom(TypeVariable<?> requiredType, Type beanType) {
        return this.isTypeInsideBounds(beanType, EMPTY_TYPES, requiredType.getBounds());
    }

    protected boolean areActualTypeArgumentsAssignableFrom(ActualTypeHolder requiredType, Type[] otherActualTypeArguments) {
        for (int i = 0; i < requiredType.getActualTypeArguments().length; ++i) {
            Class<Object> type2;
            Type type1 = requiredType.getActualTypeArguments()[i];
            Class<Object> clazz = type2 = otherActualTypeArguments.length > i ? otherActualTypeArguments[i] : Object.class;
            if (this.isAssignableFrom(type1, (Type)((Object)type2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Set<Type> requiredTypes, Set<Type> beanTypes) {
        for (Type requiredType : requiredTypes) {
            if (!this.matches(requiredType, beanTypes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Type requiredType, Set<? extends Type> beanTypes) {
        for (Type type : beanTypes) {
            if (!this.matches(requiredType, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(Type requiredType, Type beanType) {
        if ((requiredType = this.wrapWithinTypeHolder(requiredType)) instanceof ActualTypeHolder) {
            return this.matches((ActualTypeHolder)requiredType, beanType);
        }
        if (requiredType instanceof WildcardType) {
            return this.matches((WildcardType)requiredType, beanType);
        }
        if (requiredType instanceof TypeVariable) {
            return this.matches((TypeVariable)requiredType, beanType);
        }
        return false;
    }

    protected boolean matches(WildcardType requiredType, Type beanType) {
        return this.isAssignableFrom(requiredType, beanType);
    }

    protected boolean matches(TypeVariable<?> requiredType, Type beanType) {
        return this.isAssignableFrom(requiredType, beanType);
    }

    public boolean isTypeInsideBounds(Type type, Type[] lowerBounds, Type[] upperBounds) {
        return !(lowerBounds.length != 0 && !this.isAssignableFromAll(type, lowerBounds) || upperBounds.length != 0 && !this.isAssignableToAll(type, upperBounds));
    }

    public boolean areTypesInsideBounds(Type[] types, Type[] lowerBounds, Type[] upperBounds) {
        for (Type type : types) {
            if (this.isTypeInsideBounds(type, lowerBounds, upperBounds)) continue;
            return false;
        }
        return true;
    }

    protected boolean matches(ActualTypeHolder requiredType, Type otherType) {
        TypeVariable typeVariable;
        if ((otherType = this.wrapWithinTypeHolder(otherType)) instanceof ActualTypeHolder) {
            ActualTypeHolder otherActualType = (ActualTypeHolder)otherType;
            if (requiredType.getRawType().isArray() && otherActualType.getRawType().isArray()) {
                return this.arraysMatch(requiredType, otherActualType);
            }
            return this.matches(requiredType, (ActualTypeHolder)otherType);
        }
        if (otherType instanceof TypeVariable && this.isTypeInsideBounds(requiredType, EMPTY_TYPES, (typeVariable = (TypeVariable)otherType).getBounds())) {
            return true;
        }
        if (otherType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)otherType;
            for (Type upperBound : wildcardType.getUpperBounds()) {
                if (this.matches(requiredType, upperBound)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean matches(ActualTypeHolder requiredType, ActualTypeHolder otherTypeHolder) {
        return requiredType.getBoxedRawType().equals(otherTypeHolder.getBoxedRawType()) && this.areActualTypeArgumentsMatching(requiredType, otherTypeHolder.getActualTypeArguments());
    }

    protected boolean arraysMatch(ActualTypeHolder a1, ActualTypeHolder a2) {
        if (a1.getRawType().getComponentType().isPrimitive() || a2.getRawType().getComponentType().isPrimitive()) {
            return a1.getRawType().equals(a2.getRawType());
        }
        return this.isAssignableFrom(a1.getComponentType(), a2.getComponentType());
    }

    protected boolean areActualTypeArgumentsMatching(ActualTypeHolder requiredType, Type[] otherActualTypeArguments) {
        for (int i = 0; i < requiredType.getActualTypeArguments().length; ++i) {
            Class<Object> type2;
            Type type1 = requiredType.getActualTypeArguments()[i];
            Class<Object> clazz = type2 = otherActualTypeArguments.length > i ? otherActualTypeArguments[i] : Object.class;
            if (this.matches(type1, (Type)((Object)type2))) continue;
            return false;
        }
        return true;
    }

    protected Type wrapWithinTypeHolder(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class clazz = (Class)rawType;
                return new ActualTypeHolder(clazz, parameterizedType.getActualTypeArguments());
            }
        } else {
            GenericArrayType arrayType;
            Type genericComponentType;
            Class rawComponentType;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return new ActualTypeHolder(clazz, EMPTY_TYPES);
            }
            if (type instanceof GenericArrayType && (rawComponentType = Reflections.getRawType(genericComponentType = (arrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
                Class<?> arrayClass = Array.newInstance(rawComponentType, 0).getClass();
                return new ActualTypeHolder(arrayClass, Reflections.getActualTypeArguments(genericComponentType));
            }
        }
        return type;
    }

    protected static class ActualTypeHolder
    implements Type {
        private Class<?> rawType;
        private Type[] actualTypeArguments;

        private ActualTypeHolder(Class<?> rawType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        public Class<?> getRawType() {
            return this.rawType;
        }

        @SuppressWarnings(value={"EI_EXPOSE_REP"})
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        private Class<?> getBoxedRawType() {
            return Types.boxedClass(this.getRawType());
        }

        protected Type getComponentType() {
            if (!this.rawType.isArray()) {
                throw new IllegalArgumentException(this.rawType + " is not an array type");
            }
            if (this.actualTypeArguments.length == 0) {
                return this.rawType.getComponentType();
            }
            return new ParameterizedTypeImpl(this.rawType.getComponentType(), this.actualTypeArguments, null);
        }

        public String toString() {
            return "ActualTypeHolder [rawType=" + this.rawType + ", actualTypeArguments=" + Arrays.toString(this.actualTypeArguments) + "]";
        }
    }
}

