/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompFrameParseException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.service.stomp.LoggerWrapperImpl;
import com.sun.messaging.bridge.service.stomp.StompFrameMessageImpl;
import com.sun.messaging.bridge.service.stomp.StompProtocolHandlerImpl;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.jmq.util.LoggerWrapper;
import java.io.IOException;
import java.util.Properties;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.NullaryFunction;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;

public class StompMessageFilter
extends BaseFilter {
    protected static final String STOMP_PROTOCOL_HANDLER = "STOMP_PROTOCOL_HANDLER";
    private final String _OOMMSG = "Running low on memory while parsing stomp incoming data";
    private LoggerWrapper logger = null;
    private BridgeContext _bc = null;
    private Properties _jmsprop = null;
    private StompServer server = null;
    private final Attribute<PacketParseState> parsestateAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(StompMessageFilter.class + ".parsestateAttr", (NullaryFunction)new NullaryFunction<PacketParseState>(){

        public PacketParseState evaluate() {
            return new PacketParseState();
        }
    });
    private final Attribute<StompProtocolHandler> sphAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(StompMessageFilter.class + ".sphAttr", (NullaryFunction)new NullaryFunction<StompProtocolHandler>(){

        public StompProtocolHandler evaluate() {
            return new StompProtocolHandlerImpl(StompMessageFilter.this.server);
        }
    });

    protected StompMessageFilter(StompServer server) {
        this.server = server;
        this._bc = server.getBridgeContext();
        this._jmsprop = server.getJMSConfig();
        this.logger = new LoggerWrapperImpl(server.getLogger());
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        Connection c = ctx.getConnection();
        StompProtocolHandler sph = (StompProtocolHandler)this.sphAttr.get((AttributeStorage)c);
        if (sph != null) {
            sph.close(false);
        }
        if (this.logger.isFineLoggable()) {
            this.logger.logFine((Object)((Object)this) + ", conn=@" + c.hashCode() + ", sph=@" + (sph == null ? "null" : Integer.valueOf(sph.hashCode())), null);
        }
        return super.handleClose(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        BridgeContext bc = null;
        StompMessageFilter stompMessageFilter = this;
        synchronized (stompMessageFilter) {
            if (this._bc == null || this._jmsprop == null || this.logger == null) {
                if (this.logger != null) {
                    this.logger.logWarn("Stomp Service not ready yet", null);
                }
                throw new IOException("Stomp service not ready yet");
            }
            bc = this._bc;
        }
        Connection c = ctx.getConnection();
        StompProtocolHandler sph = (StompProtocolHandler)this.sphAttr.get((AttributeStorage)c);
        if (this.logger.isFinestLoggable()) {
            this.logger.logFinest((Object)((Object)this) + ", conn=@" + c.hashCode() + ", sph=@" + (sph == null ? "null" : Integer.valueOf(sph.hashCode())), null);
        }
        AttributeHolder ah = ctx.getAttributes();
        ah.setAttribute(STOMP_PROTOCOL_HANDLER, (Object)sph);
        Buffer input = (Buffer)ctx.getMessage();
        PacketParseState parsestate = (PacketParseState)this.parsestateAttr.get((AttributeStorage)c);
        int pos = input.position();
        StompFrameMessageImpl _message = null;
        try {
            if (this.logger.isFinestLoggable()) {
                this.logger.logFinest((Object)((Object)this) + ", position=" + pos + ", input=" + input, null);
            }
            if (parsestate.message == null) {
                if (input.remaining() >= 3) {
                    parsestate.message = StompFrameMessageImpl.parseCommand(input, this.logger);
                    if (this.logger.isFinestLoggable()) {
                        this.logger.logFinest("returned from parseCommand with " + parsestate.message, null);
                    }
                }
                if (parsestate.message == null) {
                    input.position(pos);
                    return ctx.getStopAction((Object)input);
                }
            }
            if ((_message = parsestate.message).getNextParseStage() == StompFrameMessage.ParseStage.HEADER) {
                _message.parseHeader(input);
                if (this.logger.isFinestLoggable()) {
                    this.logger.logFinest("returned from parseHeader", null);
                }
            }
            if (_message.getNextParseStage() == StompFrameMessage.ParseStage.BODY) {
                _message.readBody(input);
            }
            if (_message.getNextParseStage() == StompFrameMessage.ParseStage.NULL) {
                _message.readNULL(input);
            }
            if (this.logger.isFinestLoggable()) {
                this.logger.logFinest("position=" + input.position() + ", input=" + input + ", nextParseState=" + (Object)((Object)_message.getNextParseStage()), null);
            }
            if (_message.getNextParseStage() != StompFrameMessage.ParseStage.DONE) {
                if (this.logger.isFinestLoggable()) {
                    this.logger.logFinest("StopAction with position=" + input.position() + ", hasRemaining=" + input.hasRemaining(), null);
                }
                return ctx.getStopAction(input.hasRemaining() ? input : null);
            }
            ctx.setMessage((Object)_message);
            Exception pex = _message.getParseException();
            if (pex != null) {
                _message = pex instanceof StompFrameParseException ? (StompFrameMessageImpl)((StompFrameParseException)pex).getStompMessageERROR(StompFrameMessageImpl.getFactory(), this.logger) : (StompFrameMessageImpl)new StompFrameParseException(pex.getMessage(), pex).getStompMessageERROR(StompFrameMessageImpl.getFactory(), this.logger);
                ctx.setMessage((Object)_message);
                parsestate.reset();
                return ctx.getInvokeAction();
            }
            Buffer remainder = input.split(input.position());
            parsestate.reset();
            return ctx.getInvokeAction(remainder.hasRemaining() ? remainder : null);
        }
        catch (Throwable t) {
            block28: {
                if (t instanceof OutOfMemoryError) {
                    this.logger.logSevere("Running low on memory while parsing stomp incoming data", null);
                    bc.handleGlobalError(t, "Running low on memory while parsing stomp incoming data");
                } else {
                    this.logger.logSevere(StompServer.getStompBridgeResources().getKString("BSS3003", t.getMessage()), t);
                }
                try {
                    if (t instanceof StompFrameParseException) {
                        _message = (StompFrameMessageImpl)((StompFrameParseException)t).getStompMessageERROR(StompFrameMessageImpl.getFactory(), this.logger);
                        _message.setFatalERROR();
                    } else {
                        _message = (StompFrameMessageImpl)new StompFrameParseException(t.getMessage(), t, true).getStompMessageERROR(StompFrameMessageImpl.getFactory(), this.logger);
                    }
                }
                catch (Throwable tt) {
                    if (t instanceof OutOfMemoryError) {
                        _message = (StompFrameMessageImpl)StompFrameParseException.OOMMSG;
                        break block28;
                    }
                    this.logger.logSevere(StompServer.getStompBridgeResources().getKString("BSS3004", t.getMessage()), tt);
                    RuntimeException re = new RuntimeException(tt.getMessage());
                    re.initCause(tt);
                    throw re;
                }
            }
            ctx.setMessage((Object)_message);
            parsestate.reset();
            return ctx.getInvokeAction();
        }
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        StompFrameMessageImpl message = (StompFrameMessageImpl)ctx.getMessage();
        MemoryManager mm = ctx.getConnection().getTransport().getMemoryManager();
        ctx.setMessage((Object)((Buffer)message.marshall(mm).getWrapped()));
        return ctx.getInvokeAction();
    }

    static final class PacketParseState {
        StompFrameMessageImpl message = null;

        PacketParseState() {
        }

        void reset() {
            this.message = null;
        }
    }
}

