/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport;

import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.impl.common.GMSMonitor;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.GMSMessage;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.buffers.Buffer;
import com.sun.enterprise.mgmt.transport.buffers.BufferInputStream;
import com.sun.enterprise.mgmt.transport.buffers.BufferUtils;
import com.sun.enterprise.mgmt.transport.buffers.ExpandableBufferWriter;
import com.sun.enterprise.mgmt.transport.buffers.ExpandableBufferWriterFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageImpl
implements Message {
    static final long serialVersionUID = -3617083350698668655L;
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    public static final int DEFAULT_MAX_TOTAL_MESSAGE_LENGTH = 133120;
    private static int maxTotalMessageLength = 133120;
    public static final int UNSPECIFIED_MESSAGE_LENGTH = -1;
    private static final int MAGIC_NUMBER = 770303;
    private static final int VERSION = 1;
    private static final int MAGIC_NUMBER_LENGTH = 4;
    private static final int VERSION_LENGTH = 4;
    private static final int TYPE_LENGTH = 4;
    private static final int MESSAGE_LENGTH = 4;
    public static final int HEADER_LENGTH = 16;
    private volatile int version;
    private volatile int type;
    private final Map<String, Serializable> messages = new HashMap<String, Serializable>();
    private final ReentrantLock messageLock = new ReentrantLock();
    private transient Buffer cachedBuffer;
    private transient ByteBuffer cachedByteBuffer;
    private boolean modified;
    private transient GMSMonitor gmsMonitor = null;
    private transient boolean checkForGmsMonitor = true;

    public static int getMaxMessageLength() {
        return maxTotalMessageLength;
    }

    public static void setMaxMessageLength(int maxMsgLength) {
        maxTotalMessageLength = maxMsgLength;
    }

    public MessageImpl() {
    }

    public MessageImpl(int type) {
        this.initialize(type, null);
    }

    public MessageImpl(int type, Map<String, Serializable> messages) {
        this.initialize(type, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(int type, Map<String, Serializable> messages) throws IllegalArgumentException {
        this.version = 1;
        this.type = type;
        if (messages != null) {
            this.messageLock.lock();
            try {
                this.messages.clear();
                this.messages.putAll(messages);
            }
            finally {
                this.modified = true;
                this.messageLock.unlock();
            }
        }
    }

    @Override
    public int parseHeader(byte[] bytes, int offset) throws IllegalArgumentException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        if (bytes.length < offset + 16) {
            throw new IllegalArgumentException("bytes' length is too small");
        }
        if (bytes.length - offset < 16) {
            throw new IllegalArgumentException("byte[] is too small");
        }
        int magicNumber = MessageImpl.readInt(bytes, offset);
        if (magicNumber != 770303) {
            throw new IllegalArgumentException("magic number is not valid");
        }
        this.version = MessageImpl.readInt(bytes, offset + 4);
        this.type = MessageImpl.readInt(bytes, offset + 8);
        int messageLen = MessageImpl.readInt(bytes, offset + 12);
        return messageLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int parseHeader(Buffer buffer, int offset) throws IllegalArgumentException {
        int messageLen;
        if (buffer == null) {
            throw new IllegalArgumentException("byte buffer must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        int restorePosition = buffer.position();
        try {
            buffer.position(offset);
            if (buffer.remaining() < 16) {
                throw new IllegalArgumentException("byte buffer's remaining() is too small");
            }
            int magicNumber = buffer.getInt();
            if (magicNumber != 770303) {
                throw new IllegalArgumentException("magic number is not valid");
            }
            this.version = buffer.getInt();
            this.type = buffer.getInt();
            messageLen = buffer.getInt();
        }
        finally {
            buffer.position(restorePosition);
        }
        return messageLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseMessage(byte[] bytes, int offset, int length) throws IllegalArgumentException, MessageIOException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is too small");
        }
        if (bytes.length < offset + length) {
            throw new IllegalArgumentException("bytes' length is too small");
        }
        if (length > 0) {
            int msgSize = 16 + length;
            if (msgSize > maxTotalMessageLength && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength);
            }
            if (bytes.length - offset < length) {
                throw new IllegalArgumentException("byte[] is too small");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes, offset, length);
            try {
                this.readMessagesInputStream(bais);
            }
            finally {
                try {
                    bais.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseMessage(Buffer buffer, int offset, int length) throws IllegalArgumentException, MessageIOException {
        long receiveDuration = 0L;
        long receiveStartTime = 0L;
        boolean calledMonitor = false;
        if (buffer == null) {
            throw new IllegalArgumentException("byte buffer must be initialized");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is too small");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is too small");
        }
        if (length > 0) {
            int msgSize = 16 + length;
            if (msgSize > maxTotalMessageLength && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength);
            }
            int restorePosition = buffer.position();
            int restoreLimit = buffer.limit();
            try {
                buffer.position(offset);
                if (buffer.remaining() < length) {
                    throw new IllegalArgumentException("byte buffer's remaining() is too small");
                }
                buffer.limit(offset + length);
                receiveStartTime = System.currentTimeMillis();
                this.readMessagesInputStream(new BufferInputStream(buffer));
                receiveDuration = System.currentTimeMillis() - receiveStartTime;
                calledMonitor = true;
                this.monitorReceive(receiveDuration);
            }
            catch (MessageIOException mioe) {
                receiveDuration = System.currentTimeMillis() - receiveStartTime;
                calledMonitor = true;
                this.monitorReceive(receiveDuration, true);
            }
            finally {
                BufferUtils.setPositionLimit(buffer, restorePosition, restoreLimit);
                if (!calledMonitor) {
                    receiveDuration = System.currentTimeMillis() - receiveStartTime;
                    this.monitorReceive(receiveDuration, true);
                }
            }
        }
    }

    private void monitorReceive(long receiveDuration) {
        this.monitorReceive(receiveDuration, false);
    }

    private void monitorReceive(long receiveDuration, boolean receiveError) {
        Serializable element;
        GMSMessage msg = null;
        if (this.gmsMonitor == null && this.checkForGmsMonitor && (element = this.messages.get("APPMESSAGE")) instanceof GMSMessage) {
            msg = (GMSMessage)element;
            GMSContext ctx = GMSContextFactory.getGMSContext(msg.getGroupName());
            if (ctx != null) {
                this.gmsMonitor = ctx.getGMSMonitor();
            }
            this.checkForGmsMonitor = false;
        }
        if (this.gmsMonitor != null && this.gmsMonitor.ENABLED) {
            GMSMonitor.MessageStats stats;
            if (msg == null && (element = this.messages.get("APPMESSAGE")) instanceof GMSMessage) {
                msg = (GMSMessage)element;
            }
            if (msg != null) {
                stats = this.gmsMonitor.getGMSMessageMonitorStats(msg.getComponentName());
                stats.addBytesReceived(msg.getMessage().length);
                stats.incrementNumMsgsReceived();
                stats.addReceiveDuration(receiveDuration);
            } else if (receiveError) {
                stats = this.gmsMonitor.getGMSMessageMonitorStats("unknown-component-due-to-receive-side-error");
                stats.addReceiveDuration(receiveDuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessagesInputStream(InputStream is) throws IllegalArgumentException, MessageIOException {
        try {
            int messageCount = MessageImpl.readInt(is);
            this.messageLock.lock();
            try {
                NetworkUtility.deserialize(is, messageCount, this.messages);
            }
            finally {
                this.modified = true;
                this.messageLock.unlock();
            }
        }
        catch (IOException ie) {
            throw new MessageIOException(ie);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addMessageElement(String key, Serializable value) {
        this.messageLock.lock();
        try {
            Serializable serializable = this.messages.put(key, value);
            return serializable;
        }
        finally {
            this.modified = true;
            this.messageLock.unlock();
        }
    }

    @Override
    public Object getMessageElement(String key) {
        return this.messages.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object removeMessageElement(String key) {
        this.messageLock.lock();
        Serializable removed = null;
        try {
            Serializable serializable = removed = this.messages.remove(key);
            return serializable;
        }
        finally {
            if (removed != null) {
                this.modified = true;
            }
            this.messageLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<String, Serializable>> getMessageElements() {
        return Collections.unmodifiableSet(this.messages.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getPlainByteBuffer() throws MessageIOException {
        this.messageLock.lock();
        try {
            if (this.cachedByteBuffer != null && !this.modified) {
                ByteBuffer byteBuffer = this.cachedByteBuffer;
                return byteBuffer;
            }
            MessageByteArrayOutputStream mbaos = new MessageByteArrayOutputStream();
            DataOutputStream dos = null;
            try {
                dos = new DataOutputStream(mbaos);
                int tempInt = 0;
                dos.writeInt(tempInt);
                int messageCount = NetworkUtility.serialize(mbaos, this.messages);
                mbaos.writeIntWithoutCount(0, messageCount);
            }
            catch (IOException ie) {
                throw new MessageIOException(ie);
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e) {}
                }
            }
            byte[] messageBytes = mbaos.getPlainByteArray();
            int messageLen = messageBytes != null ? Math.min(messageBytes.length, mbaos.size()) : 0;
            int msgSize = 16 + messageLen;
            if (msgSize > maxTotalMessageLength) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "messageImpl.msg.too.big", new Object[]{msgSize, maxTotalMessageLength});
                }
                throw new MessageIOException("total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength + this.toString());
            }
            this.cachedByteBuffer = ByteBuffer.allocate(16 + messageLen);
            this.cachedByteBuffer.putInt(770303);
            this.cachedByteBuffer.putInt(this.version);
            this.cachedByteBuffer.putInt(this.type);
            this.cachedByteBuffer.putInt(messageLen);
            this.cachedByteBuffer.put(messageBytes, 0, messageLen);
            this.cachedByteBuffer.flip();
            ByteBuffer byteBuffer = this.cachedByteBuffer;
            return byteBuffer;
        }
        finally {
            this.modified = false;
            this.messageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPlainBytes() throws MessageIOException {
        this.messageLock.lock();
        try {
            byte[] byArray = this.getPlainByteBuffer().array();
            return byArray;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getPlainBuffer(ExpandableBufferWriterFactory bufferWriterFactory) throws MessageIOException {
        this.messageLock.lock();
        try {
            if (this.cachedBuffer != null && !this.modified) {
                Buffer buffer = this.cachedBuffer.duplicate();
                return buffer;
            }
            ExpandableBufferWriter bufferWriter = bufferWriterFactory.create();
            int headerStart = bufferWriter.position();
            bufferWriter.reserve(16);
            try {
                int pos = bufferWriter.position();
                bufferWriter.reserve(4);
                int messageCount = NetworkUtility.serialize(bufferWriter.asOutputStream(), this.messages);
                bufferWriter.putInt(pos, messageCount);
            }
            catch (IOException ie) {
                throw new MessageIOException(ie);
            }
            int msgSize = bufferWriter.position();
            if (msgSize > maxTotalMessageLength) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "messageImpl.msg.too.big", new Object[]{msgSize, maxTotalMessageLength});
                }
                throw new MessageIOException("total message size is too big: size = " + msgSize + ", max size = " + maxTotalMessageLength + this.toString());
            }
            bufferWriter.putInt(headerStart, 770303);
            bufferWriter.putInt(headerStart + 4, this.version);
            bufferWriter.putInt(headerStart + 8, this.type);
            bufferWriter.putInt(headerStart + 12, msgSize - 16);
            this.cachedBuffer = bufferWriter.toBuffer();
            Buffer buffer = bufferWriter.toBuffer();
            return buffer;
        }
        finally {
            this.messageLock.unlock();
        }
    }

    public static String getStringType(int type) {
        switch (type) {
            case 1: {
                return "CLUSTER_MANAGER_MESSAGE";
            }
            case 2: {
                return "HEALTH_MONITOR_MESSAGE";
            }
            case 3: {
                return "MASTER_NODE_MESSAGE";
            }
            case 4: {
                return "MCAST_MESSAGE";
            }
            case 5: {
                return "PING_MESSAGE";
            }
            case 6: {
                return "PONG_MESSAGE";
            }
        }
        return "UNKNOWN_MESSAGE(" + type + ")";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(MessageImpl.class.getSimpleName());
        sb.append("[v").append(this.version).append(":");
        sb.append(MessageImpl.getStringType(this.type)).append(":");
        Serializable seq = this.messages.get("SEQ");
        if (seq != null) {
            sb.append(" MasterViewSeqID:").append(seq);
        }
        for (String elementName : this.messages.keySet()) {
            if ("sourcePeerId".compareTo(elementName) == 0) {
                sb.append(" Source: ").append(this.messages.get("sourcePeerId")).append(", ");
                continue;
            }
            if ("targetPeerId".compareTo(elementName) == 0) {
                sb.append(" Target: ").append(this.messages.get("targetPeerId")).append(" , ");
                continue;
            }
            sb.append(" ").append(elementName).append(", ");
        }
        return sb.toString();
    }

    private static int readInt(InputStream is) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read()) | (ch3 = is.read()) | (ch4 = is.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private static int readInt(byte[] bytes, int offset) {
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        int ch3 = bytes[offset + 2] & 0xFF;
        int ch4 = bytes[offset + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private static class MessageByteArrayOutputStream
    extends ByteArrayOutputStream {
        private MessageByteArrayOutputStream() {
        }

        private synchronized byte[] getPlainByteArray() {
            return this.buf;
        }

        private synchronized void writeIntWithoutCount(int pos, int value) {
            NetworkUtility.writeIntToByteArray(this.buf, pos, value);
        }
    }
}

