/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.filter;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.CacheManagerListener;
import com.sun.appserv.web.cache.filter.CachingResponseWrapper;
import com.sun.appserv.web.cache.filter.HttpCacheEntry;
import com.sun.enterprise.web.WebContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.logging.annotation.LogMessageInfo;

public class CachingFilter
implements Filter,
CacheManagerListener {
    private static final String PROCESSING_SET = "com.sun.appserv.web.cache.filter.CachingFilter.PROCESSING_SET";
    String filterName;
    String servletName;
    String urlPattern;
    CacheManager manager;
    CacheHelper helper;
    Cache cache;
    boolean isEnabled = false;
    private static final Logger _logger = WebContainer.logger;
    @LogMessageInfo(message="CachingFilter {0} ready; isEnabled = {1} manager = {2}", level="FINE")
    private static final String CACHING_FILTER_READY = "AS-WEB-GLUE-00005";
    @LogMessageInfo(message="CachingFilter {0} request is cacheable; key {1} index = {2}", level="FINE")
    private static final String CACHING_FILTER_CACHEABLE = "AS-WEB-GLUE-00006";
    @LogMessageInfo(message="CachingFilter {0} request needs a refresh; key {1}", level="FINE")
    private static final String CACHING_FILTER_NEEDS_REFRESH = "AS-WEB-GLUE-00007";
    @LogMessageInfo(message="CachingFilter {0} serving response from the cache  {1}", level="FINE")
    private static final String CACHING_FILTER_SERVING_RESPONSE = "AS-WEB-GLUE-00008";
    @LogMessageInfo(message="CachingFilter {0} pass thru; isEnabled = {1}", level="FINE")
    private static final String CACHING_FILTER_PASS_THRU = "AS-WEB-GLUE-00009";
    @LogMessageInfo(message="CachingFilter {0} received cacheManager enabled event", level="FINE")
    private static final String CACHING_FILTER_ENABLED_EVENT = "AS-WEB-GLUE-00010";
    @LogMessageInfo(message="CachingFilter {0} received cacheManager disabled event", level="FINE")
    private static final String CACHING_FILTER_DISABLED_EVENT = "AS-WEB-GLUE-00011";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterName = filterConfig.getFilterName();
        this.servletName = filterConfig.getInitParameter("servletName");
        this.urlPattern = filterConfig.getInitParameter("URLPattern");
        ServletContext context = filterConfig.getServletContext();
        this.manager = (CacheManager)context.getAttribute("com.sun.appserv.web.CacheManager");
        if (this.manager != null && this.manager.isEnabled()) {
            this.cache = this.manager.getDefaultCache();
            this.helper = this.manager.getCacheHelperByFilterName(this.filterName);
            this.manager.addCacheManagerListener(this);
            this.isEnabled = true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, CACHING_FILTER_READY, new Object[]{this.filterName, this.isEnabled, this.manager});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest srequest, ServletResponse sresponse, FilterChain chain) throws IOException, ServletException {
        String key;
        if (!(srequest instanceof HttpServletRequest) || !(sresponse instanceof HttpServletResponse)) {
            throw new ServletException();
        }
        HttpServletRequest request = (HttpServletRequest)srequest;
        HttpServletResponse response = (HttpServletResponse)sresponse;
        request.setAttribute("com.sun.ias.web.cachingFilterName", this.filterName);
        request.setAttribute("com.sun.appserv.web.cachedServletName", this.servletName);
        request.setAttribute("com.sun.appserv.web.cachedURLPattern", this.urlPattern);
        boolean isFine = _logger.isLoggable(Level.FINE);
        if (this.isEnabled && this.helper.isCacheable(request) && (key = this.helper.getCacheKey(request)) != null) {
            int index = this.cache.getIndex((Object)key);
            if (isFine) {
                _logger.log(Level.FINE, CACHING_FILTER_CACHEABLE, new Object[]{request.getServletPath(), key, index});
            }
            HttpCacheEntry entry = null;
            boolean entryReady = false;
            boolean waitForRefresh = true;
            if (!this.helper.isRefreshNeeded(request)) {
                do {
                    if ((entry = (HttpCacheEntry)this.cache.get((Object)key)) == null || !entry.isValid()) continue;
                    entryReady = true;
                    break;
                } while (waitForRefresh = this.waitForRefresh(request, key, index));
            } else if (isFine) {
                _logger.log(Level.FINE, CACHING_FILTER_NEEDS_REFRESH, new Object[]{request.getServletPath(), key});
            }
            if (entryReady) {
                if (isFine) {
                    _logger.log(Level.FINE, CACHING_FILTER_SERVING_RESPONSE, new Object[]{request.getServletPath(), key});
                }
                this.sendCachedResponse(entry, response);
            } else {
                CachingResponseWrapper wrapper = null;
                boolean needNotify = true;
                try {
                    wrapper = new CachingResponseWrapper(response);
                    chain.doFilter(srequest, wrapper);
                    if (!wrapper.isError()) {
                        int timeout = this.helper.getTimeout(request);
                        entry = wrapper.cacheResponse();
                        if (timeout == -2) {
                            Long lval = wrapper.getExpiresDateHeader();
                            if (lval == null) {
                                timeout = this.manager.getDefaultTimeout();
                                entry.computeExpireTime(timeout);
                            } else {
                                long expireTime = lval;
                                entry.setExpireTime(expireTime);
                            }
                        } else {
                            entry.computeExpireTime(timeout);
                        }
                        this.cache.put((Object)key, (Object)entry, entry.getSize());
                        this.cache.notifyRefresh(index);
                        needNotify = false;
                        this.writeBody(entry, response);
                    }
                    this.cache.remove((Object)key);
                }
                finally {
                    if (needNotify) {
                        this.cache.notifyRefresh(index);
                    }
                    if (wrapper != null) {
                        wrapper.clear();
                    }
                }
            }
        } else {
            if (isFine) {
                _logger.log(Level.FINE, CACHING_FILTER_PASS_THRU, new Object[]{request.getServletPath(), this.isEnabled});
            }
            request.removeAttribute("com.sun.ias.web.cachingFilterName");
            request.removeAttribute("com.sun.appserv.web.cachedServletName");
            request.removeAttribute("com.sun.appserv.web.cachedURLPattern");
            chain.doFilter(srequest, sresponse);
        }
    }

    private void sendCachedResponse(HttpCacheEntry entry, HttpServletResponse response) throws IOException {
        int i;
        ArrayList<Object> values;
        if (entry.statusCode != -1) {
            response.setStatus(entry.statusCode);
        }
        for (String name : entry.responseHeaders.keySet()) {
            values = entry.responseHeaders.get(name);
            for (i = 0; i < values.size(); ++i) {
                response.addHeader(name, (String)values.get(i));
            }
        }
        for (String name : entry.dateHeaders.keySet()) {
            values = entry.dateHeaders.get(name);
            for (i = 0; i < values.size(); ++i) {
                response.addDateHeader(name, (Long)values.get(i));
            }
        }
        for (int i2 = 0; i2 < entry.cookies.size(); ++i2) {
            response.addCookie(entry.cookies.get(i2));
        }
        if (entry.contentLength != -1) {
            response.setContentLength(entry.contentLength);
        }
        if (entry.contentType != null) {
            response.setContentType(entry.contentType);
        }
        if (entry.locale != null) {
            response.setLocale(entry.locale);
        }
        this.writeBody(entry, response);
    }

    private void writeBody(HttpCacheEntry entry, HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        out.write(entry.bytes);
    }

    private boolean waitForRefresh(HttpServletRequest req, String key, int index) {
        Object obj = req.getAttribute(PROCESSING_SET);
        HashSet processingSet = null;
        if (obj == null) {
            processingSet = new HashSet();
            req.setAttribute(PROCESSING_SET, processingSet);
        } else if (obj instanceof HashSet) {
            HashSet set;
            processingSet = set = (HashSet)obj;
        } else {
            throw new IllegalStateException();
        }
        if (processingSet.add(key)) {
            return this.cache.waitRefresh(index);
        }
        return false;
    }

    @Override
    public void cacheManagerEnabled() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, CACHING_FILTER_ENABLED_EVENT, this.filterName);
        }
        this.isEnabled = true;
    }

    @Override
    public void cacheManagerDisabled() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, CACHING_FILTER_DISABLED_EVENT, this.filterName);
        }
        this.isEnabled = false;
    }

    @Override
    public void destroy() {
    }
}

