/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.logging.Logger;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.se.discovery.url.BeanArchiveBuilder;
import org.jboss.weld.environment.se.discovery.url.FileSystemURLHandler;
import org.jboss.weld.environment.se.discovery.url.URLHandler;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.environment.se.util.SEReflections;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.reflection.Reflections;

public class URLScanner {
    private static final String JANDEX_ENABLED_FS_URL_HANDLER_CLASS_STRING = "org.jboss.weld.environment.se.discovery.url.JandexEnabledFileSystemURLHandler";
    private static final Logger log = Logger.getLogger(URLScanner.class);
    private static final String FILE = "file";
    private static final String SEPARATOR = "!/";
    private final String[] resources;
    private final ResourceLoader resourceLoader;
    private final Bootstrap bootstrap;
    private final Collection<BeanArchiveBuilder> builders = new ArrayList<BeanArchiveBuilder>();

    public URLScanner(ResourceLoader resourceLoader, Bootstrap bootstrap, String ... resources) {
        this.resources = resources;
        this.resourceLoader = resourceLoader;
        this.bootstrap = bootstrap;
    }

    public Collection<BeanArchiveBuilder> scan() {
        URLHandler handler = null;
        for (String resourceName : this.resources) {
            for (URL url : this.resourceLoader.getResources(resourceName)) {
                String urlPath;
                try {
                    urlPath = this.getUrlPath(resourceName, url);
                }
                catch (URISyntaxException e) {
                    WeldSELogger.LOG.couldNotReadResource(resourceName, e);
                    continue;
                }
                handler = Reflections.isClassLoadable((String)"org.jboss.jandex.Index", (ResourceLoader)this.resourceLoader) ? (URLHandler)SEReflections.newInstance(this.resourceLoader, JANDEX_ENABLED_FS_URL_HANDLER_CLASS_STRING, this.bootstrap) : new FileSystemURLHandler(this.bootstrap);
                this.builders.add(handler.handle(urlPath).setId(this.getId(urlPath)));
            }
        }
        return this.builders;
    }

    private String getUrlPath(String resourceName, URL url) throws URISyntaxException {
        String urlPath = url.toExternalForm();
        String urlType = this.getUrlType(urlPath);
        log.debugv("URL Type: {0}", (Object)urlType);
        boolean isFile = FILE.equals(urlType);
        boolean isJar = "jar".equals(urlType);
        if (isFile || isJar) {
            urlPath = url.toURI().getSchemeSpecificPart();
            if (isJar && urlPath.lastIndexOf(SEPARATOR) > 0) {
                urlPath = urlPath.substring(0, urlPath.lastIndexOf(SEPARATOR));
                String fileUrlType = "file:";
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring("file:".length());
                }
            } else {
                File dirOrArchive = new File(urlPath);
                if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                    dirOrArchive = dirOrArchive.getParentFile();
                }
                urlPath = dirOrArchive.getParent();
            }
        }
        return urlPath;
    }

    private String getId(String urlPath) {
        return urlPath;
    }

    private String getUrlType(String urlPath) {
        String urlType = FILE;
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        return urlType;
    }
}

