/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.jbatch.container.artifact.proxy.ChunkListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ItemProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriteListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.RetryProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryWriteListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipWriteListenerProxy;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.ChunkHelper;
import com.ibm.jbatch.container.impl.RetryHandler;
import com.ibm.jbatch.container.impl.SingleThreadedStepControllerImpl;
import com.ibm.jbatch.container.impl.SkipHandler;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.persistence.CheckpointAlgorithmFactory;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.CheckpointDataKey;
import com.ibm.jbatch.container.persistence.CheckpointManager;
import com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.ItemProcessor;
import com.ibm.jbatch.jsl.model.ItemReader;
import com.ibm.jbatch.jsl.model.ItemWriter;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;

public class ChunkStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = ChunkStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Chunk chunk = null;
    private ItemReaderProxy readerProxy = null;
    private ItemProcessorProxy processorProxy = null;
    private ItemWriterProxy writerProxy = null;
    private CheckpointAlgorithmProxy checkpointProxy = null;
    private CheckpointAlgorithm chkptAlg = null;
    private CheckpointManager checkpointManager;
    private ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private IPersistenceManagerService _persistenceManagerService = null;
    private SkipHandler skipHandler = null;
    CheckpointDataKey readerChkptDK;
    CheckpointDataKey writerChkptDK = null;
    CheckpointData readerChkptData = null;
    CheckpointData writerChkptData = null;
    List<ChunkListenerProxy> chunkListeners = null;
    List<SkipProcessListenerProxy> skipProcessListeners = null;
    List<SkipReadListenerProxy> skipReadListeners = null;
    List<SkipWriteListenerProxy> skipWriteListeners = null;
    List<RetryProcessListenerProxy> retryProcessListeners = null;
    List<RetryReadListenerProxy> retryReadListeners = null;
    List<RetryWriteListenerProxy> retryWriteListeners = null;
    List<ItemReadListenerProxy> itemReadListeners = null;
    List<ItemProcessListenerProxy> itemProcessListeners = null;
    List<ItemWriteListenerProxy> itemWriteListeners = null;
    private RetryHandler retryHandler;
    long readCount = 0L;
    long writeCount = 0L;
    long readSkipCount = 0L;
    long processSkipCount = 0L;
    long writeSkipCount = 0L;
    boolean rollbackRetry = false;

    public ChunkStepControllerImpl(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue) {
        super(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerStatusQueue);
    }

    private List<Object> readAndProcess(int chunkSize, ItemStatus theStatus) {
        logger.entering(sourceClass, "readAndProcess", new Object[]{chunkSize, theStatus});
        ArrayList<Object> chunkToWrite = new ArrayList<Object>();
        Object itemRead = null;
        Object itemProcessed = null;
        int readProcessedCount = 0;
        do {
            ItemStatus status = new ItemStatus();
            itemRead = this.readItem(status);
            if (status.isRollback()) {
                theStatus.setRollback(true);
                this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                break;
            }
            if (!status.isSkipped() && !status.isFinished()) {
                itemProcessed = this.processItem(itemRead, status);
                if (status.isRollback()) {
                    theStatus.setRollback(true);
                    this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    break;
                }
                if (!status.isSkipped() && !status.isFiltered()) {
                    chunkToWrite.add(itemProcessed);
                    ++readProcessedCount;
                }
            }
            theStatus.setFinished(status.isFinished());
            theStatus.setCheckPointed(this.checkpointManager.ApplyCheckPointPolicy());
            if (!this.stepContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) continue;
            theStatus.setFinished(true);
        } while ((readProcessedCount != chunkSize || this.checkpointProxy.getCheckpointType() == "custom") && !theStatus.isCheckPointed() && !theStatus.isFinished());
        logger.exiting(sourceClass, "readAndProcess", chunkToWrite);
        return chunkToWrite;
    }

    private Object readItem(ItemStatus status) {
        logger.entering(sourceClass, "readItem", status);
        Object itemRead = null;
        try {
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.beforeRead();
            }
            itemRead = this.readerProxy.readItem();
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.afterRead(itemRead);
            }
            status.setFinished(itemRead == null);
            if (!status.isFinished()) {
                this.stepContext.getMetric(Metric.MetricType.READ_COUNT).incValue();
            }
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.onReadError(e);
            }
            if (!this.rollbackRetry) {
                if (this.retryReadException(e)) {
                    for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                        readListenerProxy.onReadError(e);
                    }
                    if (!this.retryHandler.isRollbackException(e)) {
                        itemRead = this.readItem(status);
                    } else {
                        status.setRollback(true);
                        this.rollbackRetry = true;
                        this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    }
                }
                if (this.skipReadException(e)) {
                    status.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipReadException(e)) {
                status.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricType.READ_SKIP_COUNT).incValue();
            }
            if (this.retryReadException(e)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    itemRead = this.readItem(status);
                } else {
                    status.setRollback(true);
                    this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "readItem", itemRead == null ? "<null>" : itemRead);
        return itemRead;
    }

    private Object processItem(Object itemRead, ItemStatus status) {
        logger.entering(sourceClass, "processItem", new Object[]{itemRead, status});
        Object processedItem = null;
        if (this.processorProxy == null) {
            return itemRead;
        }
        try {
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.beforeProcess(itemRead);
            }
            processedItem = this.processorProxy.processItem(itemRead);
            if (processedItem == null) {
                this.stepContext.getMetric(Metric.MetricType.FILTER_COUNT).incValue();
                status.setFiltered(true);
            }
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.afterProcess(itemRead, processedItem);
            }
        }
        catch (Exception e) {
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.onProcessError(processedItem, e);
            }
            if (!this.rollbackRetry) {
                if (this.retryProcessException(e, itemRead)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                            processListenerProxy.beforeProcess(itemRead);
                        }
                        processedItem = this.processItem(itemRead, status);
                        if (processedItem == null) {
                            this.stepContext.getMetric(Metric.MetricType.FILTER_COUNT).incValue();
                            status.setFiltered(true);
                        }
                        for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                            processListenerProxy.afterProcess(itemRead, processedItem);
                        }
                    } else {
                        status.setRollback(true);
                        this.rollbackRetry = true;
                        this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    }
                }
                if (this.skipProcessException(e, itemRead)) {
                    status.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipProcessException(e, itemRead)) {
                status.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricType.PROCESS_SKIP_COUNT).incValue();
            }
            if (this.retryProcessException(e, itemRead)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                        processListenerProxy.beforeProcess(itemRead);
                    }
                    processedItem = this.processItem(itemRead, status);
                    if (processedItem == null) {
                        this.stepContext.getMetric(Metric.MetricType.FILTER_COUNT).incValue();
                        status.setFiltered(true);
                    }
                    for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                        processListenerProxy.afterProcess(itemRead, processedItem);
                    }
                } else {
                    status.setRollback(true);
                    this.rollbackRetry = true;
                    this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "processItem", processedItem == null ? "<null>" : processedItem);
        return processedItem;
    }

    private void writeChunk(List<Object> theChunk, ItemStatus status) {
        logger.entering(sourceClass, "writeChunk", theChunk);
        if (!theChunk.isEmpty()) {
            try {
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.beforeWrite(theChunk);
                }
                this.writerProxy.writeItems(theChunk);
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.afterWrite(theChunk);
                }
                this.stepContext.getMetric(Metric.MetricType.WRITE_COUNT).incValueBy(theChunk.size());
            }
            catch (Exception e) {
                this.stepContext.setException(e);
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.onWriteError(theChunk, e);
                }
                if (!this.rollbackRetry) {
                    if (this.retryWriteException(e, theChunk)) {
                        if (!this.retryHandler.isRollbackException(e)) {
                            this.writeChunk(theChunk, status);
                        } else {
                            this.rollbackRetry = true;
                            status.setRollback(true);
                            this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                        }
                    }
                    if (this.skipWriteException(e, theChunk)) {
                        this.stepContext.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                    }
                    throw new BatchContainerRuntimeException(e);
                }
                if (this.skipWriteException(e, theChunk)) {
                    this.stepContext.getMetric(Metric.MetricType.WRITE_SKIP_COUNT).incValueBy(1L);
                }
                if (this.retryWriteException(e, theChunk)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        status.setRetry(true);
                        this.writeChunk(theChunk, status);
                    } else {
                        this.rollbackRetry = true;
                        status.setRollback(true);
                        this.stepContext.getMetric(Metric.MetricType.ROLLBACK_COUNT).incValue();
                    }
                }
                throw new BatchContainerRuntimeException(e);
            }
            catch (Throwable e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        logger.exiting(sourceClass, "writeChunk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeChunk() {
        logger.entering(sourceClass, "invokeChunk2");
        int itemCount = ChunkHelper.getItemCount(this.chunk);
        int timeInterval = ChunkHelper.getTimeLimit(this.chunk);
        ArrayList<Object> chunkToWrite = new ArrayList();
        boolean checkPointed = true;
        boolean rollback = false;
        Throwable caughtThrowable = null;
        try {
            this.transactionManager.begin();
            this.openReaderAndWriter();
            this.transactionManager.commit();
            while (true) {
                if (checkPointed || rollback) {
                    if (this.checkpointProxy.getCheckpointType() == "custom") {
                        int newtimeOut = this.checkpointManager.checkpointTimeout();
                        this.transactionManager.setTransactionTimeout(newtimeOut);
                    }
                    this.transactionManager.begin();
                    for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                        chunkProxy.beforeChunk();
                    }
                    if (rollback) {
                        this.positionReaderAtCheckpoint();
                        this.positionWriterAtCheckpoint();
                        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, this.getCheckpointAlgorithm(itemCount, timeInterval), this.jobExecutionImpl.getExecutionId(), this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
                    }
                }
                ItemStatus status = new ItemStatus();
                if (rollback) {
                    rollback = false;
                }
                chunkToWrite = this.readAndProcess(itemCount, status);
                if (status.isRollback()) {
                    itemCount = 1;
                    rollback = true;
                    this.readerProxy.close();
                    this.writerProxy.close();
                    this.transactionManager.rollback();
                    continue;
                }
                this.writeChunk(chunkToWrite, status);
                if (status.isRollback()) {
                    itemCount = 1;
                    rollback = true;
                    this.readerProxy.close();
                    this.writerProxy.close();
                    this.transactionManager.rollback();
                    continue;
                }
                checkPointed = status.isCheckPointed();
                if (!status.isCheckPointed() && !status.isFinished()) continue;
                this.checkpointManager.checkpoint();
                for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                    chunkProxy.afterChunk();
                }
                this.persistUserData();
                this.chkptAlg.beginCheckpoint();
                this.transactionManager.commit();
                this.chkptAlg.endCheckpoint();
                this.invokeCollectorIfPresent();
                if (status.isFinished()) {
                    this.transactionManager.begin();
                    this.readerProxy.close();
                    this.writerProxy.close();
                    this.transactionManager.commit();
                    this.stepContext.getMetric(Metric.MetricType.COMMIT_COUNT).incValue();
                    break;
                }
                this.stepContext.getMetric(Metric.MetricType.COMMIT_COUNT).incValue();
            }
        }
        catch (Exception e) {
            caughtThrowable = e;
            logger.log(Level.SEVERE, "Failure in Read-Process-Write Loop", e);
            for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                try {
                    chunkProxy.onError(e);
                }
                catch (Exception e1) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e1.printStackTrace(pw);
                    logger.warning("Caught secondary exception when calling chunk listener onError() with stack trace: " + sw.toString() + "\n. Will continue to remaining chunk listeners (if any) and rethrow wrapping the primary exception.");
                }
            }
        }
        catch (Throwable t) {
            caughtThrowable = t;
            logger.log(Level.SEVERE, "Failure in Read-Process-Write Loop", t);
        }
        finally {
            if (caughtThrowable != null) {
                this.transactionManager.setRollbackOnly();
                logger.warning("Caught throwable in chunk processing. Attempting to close all readers and writers.");
                this.readerProxy.close();
                this.writerProxy.close();
                this.transactionManager.rollback();
                logger.exiting(sourceClass, "invokeChunk");
                throw new BatchContainerRuntimeException("Failure in Read-Process-Write Loop", caughtThrowable);
            }
            logger.finest("Exiting normally");
            logger.exiting(sourceClass, "invokeChunk");
        }
    }

    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        this.chunk = this.step.getChunk();
        this.initializeChunkArtifacts();
        this.invokeChunk();
    }

    private CheckpointAlgorithm getCheckpointAlgorithm(int itemCount, int timeInterval) {
        Object alg = null;
        if (this.checkpointProxy.getCheckpointType() == "item") {
            alg = new ItemCheckpointAlgorithm();
            ((ItemCheckpointAlgorithm)alg).setThresholds(itemCount, timeInterval);
        } else {
            alg = this.checkpointProxy;
        }
        return alg;
    }

    private void initializeChunkArtifacts() {
        InjectionReferences injectionRef;
        ItemWriter itemWriter;
        String sourceMethod = "initializeChunkArtifacts";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        int itemCount = ChunkHelper.getItemCount(this.chunk);
        int timeInterval = ChunkHelper.getTimeLimit(this.chunk);
        String checkpointPolicy = ChunkHelper.getCheckpointPolicy(this.chunk);
        ItemReader itemReader = this.chunk.getReader();
        List<Property> itemReaderProps = itemReader.getProperties() == null ? null : itemReader.getProperties().getPropertyList();
        try {
            InjectionReferences injectionRef2 = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemReaderProps);
            this.readerProxy = ProxyFactory.createItemReaderProxy(itemReader.getRef(), injectionRef2, this.stepContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created ItemReaderProxy for " + itemReader.getRef());
            }
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the ItemReader [" + itemReader.getRef() + "]", e);
        }
        ItemProcessor itemProcessor = this.chunk.getProcessor();
        if (itemProcessor != null) {
            List<Property> itemProcessorProps = itemProcessor.getProperties() == null ? null : itemProcessor.getProperties().getPropertyList();
            try {
                InjectionReferences injectionRef3 = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemProcessorProps);
                this.processorProxy = ProxyFactory.createItemProcessorProxy(itemProcessor.getRef(), injectionRef3, this.stepContext);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Created ItemProcessorProxy for " + itemProcessor.getRef());
                }
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the ItemProcessor [" + itemProcessor.getRef() + "]", e);
            }
        }
        List<Property> itemWriterProps = (itemWriter = this.chunk.getWriter()).getProperties() == null ? null : itemWriter.getProperties().getPropertyList();
        try {
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemWriterProps);
            this.writerProxy = ProxyFactory.createItemWriterProxy(itemWriter.getRef(), injectionRef, this.stepContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created ItemWriterProxy for " + itemWriter.getRef());
            }
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the ItemWriter [" + itemWriter.getRef() + "]", e);
        }
        try {
            List<Property> propList = null;
            if (this.chunk.getCheckpointAlgorithm() != null) {
                propList = this.chunk.getCheckpointAlgorithm().getProperties() == null ? null : this.chunk.getCheckpointAlgorithm().getProperties().getPropertyList();
            }
            InjectionReferences injectionRef4 = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            this.checkpointProxy = CheckpointAlgorithmFactory.getCheckpointAlgorithmProxy(this.step, injectionRef4, this.stepContext);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created CheckpointAlgorithmProxy for policy [" + checkpointPolicy + "]");
            }
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the CheckpointAlgorithm for policy [" + this.chunk.getCheckpointPolicy() + "]", e);
        }
        injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.chunkListeners = this.jobExecutionImpl.getListenerFactory().getChunkListeners(this.step, injectionRef, this.stepContext);
        this.skipProcessListeners = this.jobExecutionImpl.getListenerFactory().getSkipProcessListeners(this.step, injectionRef, this.stepContext);
        this.skipReadListeners = this.jobExecutionImpl.getListenerFactory().getSkipReadListeners(this.step, injectionRef, this.stepContext);
        this.skipWriteListeners = this.jobExecutionImpl.getListenerFactory().getSkipWriteListeners(this.step, injectionRef, this.stepContext);
        this.retryProcessListeners = this.jobExecutionImpl.getListenerFactory().getRetryProcessListeners(this.step, injectionRef, this.stepContext);
        this.retryReadListeners = this.jobExecutionImpl.getListenerFactory().getRetryReadListeners(this.step, injectionRef, this.stepContext);
        this.retryWriteListeners = this.jobExecutionImpl.getListenerFactory().getRetryWriteListeners(this.step, injectionRef, this.stepContext);
        this.itemReadListeners = this.jobExecutionImpl.getListenerFactory().getItemReadListeners(this.step, injectionRef, this.stepContext);
        this.itemProcessListeners = this.jobExecutionImpl.getListenerFactory().getItemProcessListeners(this.step, injectionRef, this.stepContext);
        this.itemWriteListeners = this.jobExecutionImpl.getListenerFactory().getItemWriteListeners(this.step, injectionRef, this.stepContext);
        if (this.checkpointProxy.getCheckpointType() == "item") {
            this.chkptAlg = new ItemCheckpointAlgorithm();
            ((ItemCheckpointAlgorithm)this.chkptAlg).setThresholds(itemCount, timeInterval);
        } else {
            this.chkptAlg = this.checkpointProxy;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Setting contexts for chunk artifacts");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Initialize checkpoint manager with item-count=" + itemCount);
        }
        logger.fine("Initialize checkpoint manager with time-interval=" + timeInterval);
        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, this.chkptAlg, this.jobExecutionImpl.getExecutionId(), this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
        this.skipHandler = new SkipHandler(this.chunk, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
        this.skipHandler.addSkipProcessListener(this.skipProcessListeners);
        this.skipHandler.addSkipReadListener(this.skipReadListeners);
        this.skipHandler.addSkipWriteListener(this.skipWriteListeners);
        this.retryHandler = new RetryHandler(this.chunk, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
        this.retryHandler.addRetryProcessListener(this.retryProcessListeners);
        this.retryHandler.addRetryReadListener(this.retryReadListeners);
        this.retryHandler.addRetryWriteListener(this.retryWriteListeners);
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    private void openReaderAndWriter() {
        String sourceMethod;
        block13: {
            block12: {
                sourceMethod = "openReaderAndWriter";
                if (logger.isLoggable(Level.FINE)) {
                    logger.entering(sourceClass, sourceMethod);
                }
                this._persistenceManagerService = this.servicesManager.getPersistenceManagerService();
                this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "READER");
                CheckpointData readerChkptData = this._persistenceManagerService.getCheckpointData(this.readerChkptDK);
                try {
                    if (readerChkptData != null) {
                        byte[] readertoken = readerChkptData.getRestartToken();
                        ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(readertoken);
                        TCCLObjectInputStream readerOIS = null;
                        try {
                            readerOIS = new TCCLObjectInputStream(readerChkptBA);
                            this.readerProxy.open((Serializable)readerOIS.readObject());
                            readerOIS.close();
                            break block12;
                        }
                        catch (Exception ex) {
                            throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                        }
                    }
                    readerChkptData = null;
                    this.readerProxy.open(null);
                }
                catch (ClassCastException e) {
                    logger.warning("Expected CheckpointData but found" + readerChkptData);
                    throw new IllegalStateException("Expected CheckpointData but found" + readerChkptData);
                }
            }
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "WRITER");
            CheckpointData writerChkptData = this._persistenceManagerService.getCheckpointData(this.writerChkptDK);
            try {
                if (writerChkptData != null) {
                    byte[] writertoken = writerChkptData.getRestartToken();
                    ByteArrayInputStream writerChkptBA = new ByteArrayInputStream(writertoken);
                    TCCLObjectInputStream writerOIS = null;
                    try {
                        writerOIS = new TCCLObjectInputStream(writerChkptBA);
                        this.writerProxy.open((Serializable)writerOIS.readObject());
                        writerOIS.close();
                        break block13;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                writerChkptData = null;
                this.writerProxy.open(null);
            }
            catch (ClassCastException e) {
                logger.warning("Expected Checkpoint but found" + writerChkptData);
                throw new IllegalStateException("Expected Checkpoint but found" + writerChkptData);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(BatchStatus.STOPPING);
    }

    boolean skipReadException(Exception e) {
        try {
            this.skipHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean retryReadException(Exception e) {
        try {
            this.retryHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean skipProcessException(Exception e, Object record) {
        try {
            this.skipHandler.handleExceptionWithRecordProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean retryProcessException(Exception e, Object record) {
        try {
            this.retryHandler.handleExceptionProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean skipWriteException(Exception e, List<Object> chunkToWrite) {
        try {
            this.skipHandler.handleExceptionWithRecordListWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean retryWriteException(Exception e, List<Object> chunkToWrite) {
        try {
            this.retryHandler.handleExceptionWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private void positionReaderAtCheckpoint() {
        block5: {
            this._persistenceManagerService = this.servicesManager.getPersistenceManagerService();
            this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "READER");
            CheckpointData readerData = this._persistenceManagerService.getCheckpointData(this.readerChkptDK);
            try {
                if (readerData != null) {
                    byte[] readertoken = readerData.getRestartToken();
                    ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(readertoken);
                    TCCLObjectInputStream readerOIS = null;
                    try {
                        readerOIS = new TCCLObjectInputStream(readerChkptBA);
                        this.readerProxy.open((Serializable)readerOIS.readObject());
                        readerOIS.close();
                        break block5;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                readerData = null;
                this.readerProxy.open(null);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + readerData);
            }
        }
    }

    private void positionWriterAtCheckpoint() {
        block5: {
            this._persistenceManagerService = this.servicesManager.getPersistenceManagerService();
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "WRITER");
            CheckpointData writerData = this._persistenceManagerService.getCheckpointData(this.writerChkptDK);
            try {
                if (writerData != null) {
                    byte[] writertoken = writerData.getRestartToken();
                    ByteArrayInputStream writerChkptBA = new ByteArrayInputStream(writertoken);
                    TCCLObjectInputStream writerOIS = null;
                    try {
                        writerOIS = new TCCLObjectInputStream(writerChkptBA);
                        this.writerProxy.open((Serializable)writerOIS.readObject());
                        writerOIS.close();
                        break block5;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                writerData = null;
                this.writerProxy.open(null);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + writerData);
            }
        }
    }

    private class ItemStatus {
        private boolean skipped = false;
        private boolean filtered = false;
        private boolean finished = false;
        private boolean checkPointed = false;
        private boolean retry = false;
        private boolean rollback = false;

        private ItemStatus() {
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        public boolean isCheckPointed() {
            return this.checkPointed;
        }

        public void setCheckPointed(boolean checkPointed) {
            this.checkPointed = checkPointed;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public boolean isRetry() {
            return this.retry;
        }

        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        public boolean isRollback() {
            return this.rollback;
        }

        public void setRollback(boolean rollback) {
            this.rollback = rollback;
        }
    }
}

