/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.naming.DefaultResourceProxy;
import org.glassfish.concurrent.config.ManagedThreadFactory;
import org.glassfish.concurrent.runtime.deployer.DefaultManagedThreadFactory;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-managed-thread-factories")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.managed.thread.factories")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-managed-thread-factories", description="List Managed Thread Factories")})
public class ListManagedThreadFactories
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListManagedThreadFactories.class);
    @Param(primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    private Domain domain;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private DefaultManagedThreadFactory defaultFactory;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Collection<ManagedThreadFactory> managedThreadFactories = this.domain.getResources().getResources(ManagedThreadFactory.class);
            ArrayList resourcesList = new ArrayList();
            List drps = this.habitat.getAllServices(DefaultResourceProxy.class, new Annotation[0]);
            for (ManagedThreadFactory managedThreadFactory : managedThreadFactories) {
                String jndiName = managedThreadFactory.getJndiName();
                if (!this.bindableResourcesHelper.resourceExists(jndiName, this.target)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(jndiName);
                HashMap<String, String> resourceNameMap = new HashMap<String, String>();
                String logicalName = DefaultResourceProxy.Util.getLogicalName((List)drps, (String)jndiName);
                if (logicalName != null) {
                    resourceNameMap.put("logical-jndi-name", logicalName);
                }
                resourceNameMap.put("name", jndiName);
                resourcesList.add(resourceNameMap);
            }
            Properties extraProperties = new Properties();
            extraProperties.put("managedThreadFactories", resourcesList);
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.managed.thread.factory.failed", "List managed thread factories failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

