/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.audit.impl;

import com.sun.messaging.jmq.jmsserver.audit.api.MQAuditService;
import com.sun.messaging.jmq.jmsserver.audit.impl.MQAuditSessionImpl;
import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.util.log.Logger;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="log")
@PerLookup
public class LogAuditSession
extends MQAuditSessionImpl {
    public LogAuditSession() {
        boolean bl = this.auditOn = MQAuditService.isAUDIT_LOGGING_LICENSED() && MQAuditService.logAuditEnabled();
        if (this.auditOn) {
            String value = CommGlobals.getConfig().getProperty("imq.log.level", "INFO");
            int setAt = 8;
            try {
                setAt = Logger.levelStrToInt((String)value);
            }
            catch (IllegalArgumentException e) {
                setAt = 8;
            }
            if (setAt > 8) {
                this.logger.updateProperty("imq.log.level", "INFO");
            }
        }
        this.logger.log(4, this + ":auditOn=" + this.auditOn);
    }

    @Override
    public void authentication(String user, String host, boolean success) {
        if (!this.auditOn) {
            return;
        }
        String status = success ? "success" : "failure";
        this.logger.log(8, "AUDIT action=authentication;user=" + user + ";" + "host=" + host + ";" + status);
    }

    @Override
    public void brokerOperation(String user, String host, String op) {
        if (!this.auditOn) {
            return;
        }
        this.logger.log(8, "AUDIT action=" + op + ";" + "user=" + user + ";" + "host=" + (host == null ? this.brokerHost : host) + ";" + "success");
    }

    @Override
    public void connectionAuth(String user, String host, String type, String name, boolean success) {
        if (!this.auditOn) {
            return;
        }
        String status = success ? "success" : "failure";
        this.logger.log(8, "AUDIT action=authorization;user=" + user + ";" + "host=" + host + ";" + "type=" + type + ";" + "name=" + name + ";" + status);
    }

    @Override
    public void destinationAuth(String user, String host, String type, String name, String op, boolean success) {
        if (!this.auditOn) {
            return;
        }
        String status = success ? "success" : "failure";
        this.logger.log(8, "AUDIT action=authorization;user=" + user + ";" + "host=" + host + ";" + "type=" + type + ";" + "name=" + name + ";" + "operation=" + op + ";" + status);
    }

    @Override
    public void storeOperation(String user, String host, String op) {
        if (!this.auditOn) {
            return;
        }
        this.logger.log(8, "AUDIT action=" + op + ";" + "user=" + user + ";" + "host=" + (host == null ? this.brokerHost : host) + ";" + "success");
    }

    @Override
    public void destinationOperation(String user, String host, String op, String type, String name) {
        if (!this.auditOn) {
            return;
        }
        this.logger.log(8, "AUDIT action=" + op + ";" + "user=" + user + ";" + "host=" + host + ";" + "type=" + type + ";" + "name=" + name + ";" + "success");
    }

    @Override
    public void durableSubscriberOperation(String user, String host, String op, String name, String clientID) {
        if (!this.auditOn) {
            return;
        }
        this.logger.log(8, "AUDIT action=" + op + ";" + "user=" + user + ";" + "host=" + host + ";" + "name=" + name + ";" + "clientID=" + clientID + ";" + "success");
    }
}

