/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.acl;

import com.sun.messaging.jmq.auth.api.server.model.AccessControlModel;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class JMQFileAccessControlModel
implements AccessControlModel {
    public static final String VERSION = "JMQFileAccessControlModel/100";
    public static final String TYPE = "file";
    public static final String PROP_FILENAME_SUFFIX = "file.filename";
    public static final String PROP_DIRPATH_SUFFIX = "file.dirpath";
    public static final String PROP_URL_SUFFIX = "file.url";
    public static final String DEFAULT_ACL_FILENAME = "accesscontrol.properties";
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    private static final String VERSION_PROPNAME = "version";
    private static final String ALLOW_SUFFIX = ".allow";
    private static final String DENY_SUFFIX = ".deny";
    private static final String USER_SUFFIX = ".user";
    private static final String GROUP_SUFFIX = ".group";
    private static final String ALL = "*";
    private static final String WILDCARD = "*";
    private static final int ALLOW_BIT = 0;
    private static final int DENY_BIT = 1;
    private String type;
    private Properties authProps;
    private String aclfname = null;
    private Properties acs = null;
    private long acsTimestamp = 0L;
    private String aclfileSave = null;
    private Class userClass = null;
    private Class groupClass = null;
    private static final int MAX_RECURSIONS = 25;
    private static final String LDAP_MULTILINE_SEPARATOR = "$";
    DocumentBuilder docBuilder = null;
    boolean doXMLOnly = false;

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void initialize(String type, Properties authProperties) throws AccessControlException {
        this.type = type;
        if (!type.equals(TYPE)) {
            Object[] args = new String[]{type, TYPE, this.getClass().getName()};
            String emsg = Globals.getBrokerResources().getKString("B4072", args);
            this.logger.log(32, emsg);
            throw new AccessControlException(emsg);
        }
        this.authProps = authProperties;
        String authtyp = this.authProps.getProperty("imq.authentication.type");
        assert (authtyp != null);
        String rep = this.authProps.getProperty("imq.authentication." + authtyp + ".user_repository");
        assert (rep != null);
        String uprop = "imq.user_repository." + rep + ".userPrincipalClass";
        String uclass = this.authProps.getProperty(uprop);
        String gprop = "imq.user_repository." + rep + ".groupPrincipalClass";
        String gclass = this.authProps.getProperty(gprop);
        try {
            if (uclass != null) {
                this.userClass = Class.forName(uclass);
            }
            if (gclass != null) {
                this.groupClass = Class.forName(gclass);
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.log(32, e.getMessage(), (Throwable)e);
            throw new AccessControlException("ClassNotFoundException: " + e.getMessage());
        }
        this.load();
    }

    private boolean travelChildren(Node elem, int cnt, URL au) throws Exception {
        NodeList nodes = elem.getChildNodes();
        if (DEBUG) {
            this.logger.log(8, "FileACL.travelChildren(" + elem + ", " + cnt + ")" + elem.getNodeType() + "#children:" + nodes.getLength());
        }
        if (cnt > 25) {
            throw new DOMException(2, "Maximum " + cnt + " nested elements exceeded: " + elem);
        }
        Node nod = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            nod = nodes.item(i);
            if (!this.travelChildren(nod, cnt + 1, au)) continue;
            return true;
        }
        ByteArrayInputStream bais = null;
        String data = elem.getNodeValue();
        if (data != null && !data.trim().equals("")) {
            String ver;
            if (DEBUG) {
                this.logger.log(8, "FileACL.travelChildren.load data: " + data);
            }
            this.acs = new Properties();
            bais = new ByteArrayInputStream(data.getBytes("UTF-8"));
            this.acs.load(bais);
            if (this.checkVersion(this.acs, au.toString(), false)) {
                return true;
            }
            if (this.acs.size() == 1 && (ver = this.acs.getProperty(VERSION_PROPNAME)) != null && data.contains(VERSION)) {
                this.acs.clear();
                this.acs = StringUtil.toProperties((String)data, (String)LDAP_MULTILINE_SEPARATOR, (Properties)this.acs);
                if (this.checkVersion(this.acs, au.toString(), false)) {
                    return true;
                }
            }
            this.acs = new Properties();
            bais.close();
        }
        return false;
    }

    private void loadAsXML(URL au) throws Exception {
        if (this.docBuilder == null) {
            this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        InputStream ins = null;
        try {
            ins = au.openStream();
            InputSource is = new InputSource(ins);
            Document doc = this.docBuilder.parse(is);
            Element root = doc.getDocumentElement();
            root.normalize();
            if (DEBUG) {
                this.logger.log(8, "FileACL.loadAsXML(" + au + "), root=" + root.getNodeName());
            }
            if (!this.travelChildren(root, 0, au)) {
                throw new DOMException(8, "FileACL: Expected data not found from " + au);
            }
        }
        catch (SAXParseException e) {
            this.acs = null;
            Exception x = e.getException();
            this.logger.log(32, "FileACL: parsing error: " + e.getMessage() + ", line " + e.getLineNumber() + ", uri " + e.getSystemId(), (Throwable)x);
            this.logger.logStack(32, "FileACL: error in processing " + au, (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAsProperties(URL au) throws Exception {
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            this.acs = new Properties();
            is = au.openStream();
            bis = new BufferedInputStream(is);
            this.acs.load(bis);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void load() throws AccessControlException {
        String aclurl = this.authProps.getProperty("imq.accesscontrol.file.url");
        String serviceLevelfn = this.authProps.getProperty("imq." + this.authProps.getProperty("imq.servicename") + "." + "accesscontrol" + "." + PROP_FILENAME_SUFFIX);
        if (serviceLevelfn != null) {
            aclurl = null;
        }
        if (aclurl != null) {
            try {
                URL au = new URL(aclurl);
                boolean ok = false;
                if (!this.doXMLOnly) {
                    this.loadAsProperties(au);
                    ok = this.checkVersion(this.acs, aclurl, false);
                }
                if (!ok) {
                    this.loadAsXML(au);
                    this.checkVersion(this.acs, aclurl, true);
                    this.doXMLOnly = true;
                }
                if (DEBUG) {
                    this.logger.log(8, "FileACL.loaded: " + this.acs);
                }
            }
            catch (Exception e) {
                this.acs = null;
                this.logger.log(32, e.getMessage(), (Throwable)e);
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4047", aclurl) + " - " + e.getMessage());
            }
            return;
        }
        String acl_loc = this.authProps.getProperty("imq.accesscontrol.file.dirpath", Globals.getInstanceEtcDir());
        this.aclfname = this.authProps.getProperty("imq.accesscontrol.file.filename", DEFAULT_ACL_FILENAME);
        if (this.aclfname == null) {
            String emsg = Globals.getBrokerResources().getKString("B4046", this.type);
            this.logger.log(32, emsg);
            throw new AccessControlException(emsg);
        }
        String aclfile = acl_loc + File.separator + this.aclfname;
        File file = null;
        long timestamp = 0L;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            file = new File(aclfile);
            timestamp = file.lastModified();
            if (this.acs != null && this.aclfileSave != null && aclfile.equals(this.aclfileSave) && timestamp > 0L && timestamp == this.acsTimestamp) {
                return;
            }
            if (DEBUG) {
                this.logger.log(8, "Loading access control " + aclfile + " ...");
            }
            this.acs = new Properties();
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            this.acs.load(bis);
            bis.close();
            fis.close();
            this.checkVersion(this.acs, aclfile, true);
            this.aclfileSave = aclfile;
            this.acsTimestamp = timestamp;
        }
        catch (IOException e) {
            this.acs = null;
            try {
                if (bis != null) {
                    bis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.logger.log(32, e.getMessage(), (Throwable)e);
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4047", aclfile) + " - " + e.getMessage());
        }
    }

    private boolean checkVersion(Properties acl, String aclfile, boolean throwexp) throws AccessControlException {
        String version = acl.getProperty(VERSION_PROPNAME);
        if (version == null || !version.equals(VERSION)) {
            version = version == null ? "null" : version;
            Object[] args = new String[]{VERSION_PROPNAME, version, aclfile + " " + acl.keySet(), VERSION, this.getClass().getName()};
            String emsg = Globals.getBrokerResources().getKString("B4073", args);
            if (throwexp) {
                this.logger.log(32, emsg);
                throw new AccessControlException(emsg);
            }
            if (DEBUG) {
                this.logger.log(8, emsg);
            }
            return false;
        }
        return true;
    }

    @Override
    public void checkConnectionPermission(Principal clientUser, String serviceName, String serviceType, Subject subject) throws AccessControlException {
        this.checkPermission(clientUser, subject, "connection", serviceType, null, false);
    }

    @Override
    public void checkDestinationPermission(Principal clientUser, String serviceName, String serviceType, Subject subject, String operation, String destination, String destinationType) throws AccessControlException {
        boolean supportWildDest = !DestType.isQueueStr((String)destinationType);
        this.checkPermission(clientUser, subject, destinationType, destination, operation, supportWildDest);
    }

    private void checkPermission(Principal clientUser, Subject subject, String prefix, String variant, String suffix, boolean wild) throws AccessControlException {
        Set groups = null;
        Set users = null;
        if (this.groupClass != null) {
            groups = subject.getPrincipals(this.groupClass);
        }
        if (this.userClass != null) {
            users = subject.getPrincipals(this.userClass);
        }
        if (users == null || users.size() == 0) {
            users = new HashSet();
            users.add(clientUser);
        }
        this.load();
        Principal user2 = null;
        StringBuffer exceptionMsg = null;
        boolean computed = false;
        for (Principal user2 : users) {
            if (user2 == null) continue;
            this.validate(user2.getName(), groups);
            ArrayList list = this.getRules(prefix, variant, suffix, wild);
            try {
                this.computePermission(clientUser.getName(), user2.getName(), groups, list, GROUP_SUFFIX);
                computed = true;
            }
            catch (AccessControlException e) {
                if (DEBUG) {
                    this.logger.log(8, clientUser + "[" + user2.getName() + "]AccessControlException: " + e.getMessage());
                }
                if (exceptionMsg == null) {
                    exceptionMsg = new StringBuffer();
                }
                exceptionMsg.append(e.getMessage());
                exceptionMsg.append(", ");
            }
        }
        if (exceptionMsg != null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4051", exceptionMsg));
        }
        if (!computed) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4048"));
        }
    }

    private void computePermission(String clientUser, String user, Set groups, ArrayList list, String grouptag) throws AccessControlException {
        BitSet inheritedbs = new BitSet(2);
        if (DEBUG) {
            this.logger.log(8, "ComputePermission for " + clientUser + "[" + user + "], list=" + list + ", groups=" + groups + ", grouptag=" + grouptag);
        }
        for (int i = 0; i < list.size(); ++i) {
            String rule = (String)list.get(i);
            HashMap allows = this.getRuleRightHand(rule + ALLOW_SUFFIX + USER_SUFFIX);
            HashMap denys = this.getRuleRightHand(rule + DENY_SUFFIX + USER_SUFFIX);
            BitSet ubsall = this.getPermission("*", allows, denys);
            BitSet ubs = this.getPermission(user, allows, denys);
            BitSet gbs = new BitSet(2);
            BitSet gbsall = new BitSet(2);
            if (groups != null && groups.size() > 0) {
                if (groups.size() >= Integer.MAX_VALUE) {
                    throw new AccessControlException(Globals.getBrokerResources().getString("B4117", "too many groups for user " + clientUser));
                }
                allows = this.getRuleRightHand(rule + ALLOW_SUFFIX + grouptag);
                denys = this.getRuleRightHand(rule + DENY_SUFFIX + grouptag);
                gbsall = this.getPermission("*", allows, denys);
                for (Principal group : groups) {
                    gbs.or(this.getPermission(group.getName(), allows, denys));
                }
            }
            if (DEBUG) {
                this.logger.log(8, "\t" + clientUser + "[" + user + "] computePermission:ubs=" + ubs);
                this.logger.log(8, "\t" + clientUser + "[" + user + "] computePermission:gbs=" + gbs);
                this.logger.log(8, "\t" + clientUser + "[" + user + "] computePermission:ubsall=" + ubsall);
                this.logger.log(8, "\t" + clientUser + "[" + user + "] computePermission:gbsall=" + gbsall);
            }
            this.overridePermission(gbs, ubs);
            this.overridePermission(gbsall, ubsall);
            this.overridePermission(gbsall, gbs);
            if (DEBUG) {
                this.logger.log(8, "computed permission:" + rule + ":bs=" + gbsall);
            }
            this.overridePermission(inheritedbs, gbsall);
            if (!DEBUG) continue;
            this.logger.log(8, "computed permission:total=" + inheritedbs);
        }
        if (inheritedbs.get(0) && !inheritedbs.get(1)) {
            return;
        }
        throw new AccessControlException(clientUser.equals(user) ? "" + clientUser : clientUser + " [" + user + "]");
    }

    private void overridePermission(BitSet basebs, BitSet bs) {
        if (bs.get(0) && bs.get(1)) {
            return;
        }
        if (bs.get(0)) {
            basebs.set(0);
            basebs.clear(1);
        }
        if (bs.get(1)) {
            basebs.set(1);
            basebs.clear(0);
        }
    }

    private BitSet getPermission(String name, HashMap allows, HashMap denys) {
        BitSet bs = new BitSet(2);
        if (allows != null && allows.get(name) != null) {
            bs.set(0);
        }
        if (denys != null && denys.get(name) != null) {
            bs.set(1);
        }
        if (bs.get(0) && bs.get(1)) {
            bs.clear(0);
            bs.clear(1);
        }
        return bs;
    }

    private ArrayList getRules(String prefix, String variant, String suffix, boolean wild) throws AccessControlException {
        String currentkey = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            String rule = null;
            if (variant == null && suffix != null) {
                rule = prefix + "." + suffix;
                list.add(rule);
                return list;
            }
            rule = prefix + "." + "*";
            if (suffix != null) {
                rule = rule + "." + suffix;
            }
            list.add(rule);
            if (variant != null && !variant.equals("*")) {
                rule = prefix + "." + variant;
                if (suffix != null) {
                    rule = rule + "." + suffix;
                }
                list.add(rule);
            }
            if (wild && variant != null && suffix != null) {
                Pattern pattern = Pattern.compile("(" + prefix + "\\." + "(.+)" + "\\." + suffix + ")" + "(\\" + ALLOW_SUFFIX + "|" + "\\" + DENY_SUFFIX + ")(\\" + USER_SUFFIX + "|" + "\\" + GROUP_SUFFIX + ")");
                Enumeration<?> enu = this.acs.propertyNames();
                Matcher matcher = null;
                String regEx = null;
                while (enu.hasMoreElements()) {
                    currentkey = (String)enu.nextElement();
                    matcher = pattern.matcher(currentkey);
                    if (!matcher.matches() || matcher.group(2).equals("*") || !Pattern.matches(regEx = DestinationUID.createRegExString(matcher.group(2)), variant)) continue;
                    list.add(matcher.group(1));
                }
            }
            return list;
        }
        catch (Exception e) {
            AccessControlException ae = new AccessControlException(e.toString() + (currentkey == null ? "" : " - " + currentkey));
            ae.initCause(e);
            throw ae;
        }
    }

    private HashMap getRuleRightHand(String propname) {
        String values;
        if (DEBUG) {
            this.logger.log(4, "check permission " + propname);
        }
        if ((values = this.acs.getProperty(propname)) == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(values, ",", false);
        HashMap<String, String> hp = new HashMap<String, String>();
        while (token.hasMoreElements()) {
            hp.put(token.nextToken().trim(), "");
        }
        if (hp.size() == 0) {
            return null;
        }
        return hp;
    }

    private void validate(String user, Set groups) throws AccessControlException {
        if (user == null) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4048"));
        }
        if (user.equals("*")) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4049", "*"));
        }
        if (groups != null) {
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                Principal group = (Principal)iter.next();
                if (group == null || group.getName() == null) {
                    iter.remove();
                    continue;
                }
                if (!group.getName().equals("*")) continue;
                throw new AccessControlException(Globals.getBrokerResources().getKString("B4069", "*"));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DEBUG = true;
        Properties prop = new Properties();
        prop.setProperty("imq.accesscontrol.file.filename", DEFAULT_ACL_FILENAME);
        JMQFileAccessControlModel m = new JMQFileAccessControlModel();
        m.initialize(TYPE, prop);
        String user = "akang";
        HashSet<String> groups = new HashSet<String>();
        groups.add("student");
        groups.add("Accounting Managers");
        ArrayList list = m.getRules("topic", "abc", "produce", true);
        System.out.println(list);
        m.computePermission(user, user, groups, list, GROUP_SUFFIX);
        System.out.println("--DONE--");
    }
}

