/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class GetLicenseHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG;
    private static boolean CAN_RECONNECT;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        if (DEBUG) {
            this.logger.log(1, "GetLicenseHandler: handle(" + con + ", " + PacketType.getString((int)msg.getPacketType()) + ")");
        }
        String reason = "";
        int status = 200;
        Packet pkt = new Packet(con.useDirectBuffers());
        pkt.setPacketType(77);
        pkt.setConsumerID(msg.getConsumerID());
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            LicenseBase license = Globals.getCurrentLicense(null);
            hash.put("JMQLicense", license.getProperty("imq.license_type"));
            hash.put("JMQLicenseDesc", license.getProperty("description"));
            Properties props = license.getProperties();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                hash.put(key, props.get(key));
            }
        }
        catch (BrokerException ex) {
            reason = ex.toString();
            status = 500;
        }
        hash.put("JMQStatus", status);
        if (status != 200) {
            hash.put("JMQReason", reason);
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        return true;
    }

    static {
        LicenseBase license;
        DEBUG = false;
        CAN_RECONNECT = false;
        try {
            license = Globals.getCurrentLicense(null);
        }
        catch (BrokerException ex) {
            // empty catch block
        }
        try {
            license = Globals.getCurrentLicense(null);
            CAN_RECONNECT = license.getBooleanProperty("imq.enable_failover", false);
        }
        catch (BrokerException ex) {
            CAN_RECONNECT = false;
        }
    }
}

