/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.plugin.spi.DestinationSpi;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;

public class VerifyDestinationHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable<String, Object> hash;
        Packet pkt;
        block21: {
            block20: {
                int status = 200;
                String reason = null;
                assert (msg.getPacketType() == 40);
                pkt = new Packet(con.useDirectBuffers());
                pkt.setConsumerID(msg.getConsumerID());
                pkt.setPacketType(41);
                hash = new Hashtable<String, Object>();
                Hashtable props = null;
                String selectorstr = null;
                int type = 0;
                try {
                    props = msg.getProperties();
                    String destination = (String)props.get("JMQDestination");
                    Integer inttype = (Integer)props.get("JMQDestType");
                    assert (destination != null);
                    type = inttype == null ? 0 : inttype;
                    selectorstr = (String)props.get("JMQSelector");
                    if (selectorstr != null) {
                        Selector selector = Selector.compile((String)selectorstr);
                        selector = null;
                    }
                    boolean notFound = false;
                    DestinationSpi d = null;
                    if (DestinationUID.isWildcard(destination)) {
                        pkt.setWildcard(true);
                        DestinationUID duid = DestinationUID.getUID(destination, type);
                        List[] ll = this.coreLifecycle.findMatchingIDs(con.getPartitionedStore(), duid);
                        List l = ll[0];
                        if (l.isEmpty()) {
                            notFound = true;
                        }
                    } else {
                        DestinationSpi[] ds = this.coreLifecycle.getDestination(con.getPartitionedStore(), destination, DestType.isQueue((int)type));
                        d = ds[0];
                        boolean bl = notFound = d == null;
                    }
                    if (notFound) {
                        status = 404;
                        reason = "destination not found";
                        hash.put("JMQCanCreate", this.coreLifecycle.canAutoCreate(DestType.isQueue((int)type)));
                    } else if (d != null) {
                        hash.put("JMQDestType", d.getType());
                    }
                }
                catch (SelectorFormatException ex) {
                    reason = ex.getMessage();
                    status = 400;
                    this.logger.log(16, "B2016", selectorstr, (Throwable)ex);
                }
                catch (IOException ex) {
                    this.logger.logStack(32, "B3100", (Object)"Unable to verify destination - no properties", (Throwable)ex);
                    reason = ex.getMessage();
                    status = 500;
                }
                catch (ClassNotFoundException ex) {
                    this.logger.logStack(32, "B3100", (Object)"Unable to verify destination -bad class", (Throwable)ex);
                    reason = ex.getMessage();
                    status = 500;
                }
                catch (BrokerException ex) {
                    reason = ex.getMessage();
                    status = ex.getStatusCode();
                    this.logger.logStack(4, "B3100", (Object)"Unable to verify destination ", (Throwable)ex);
                }
                catch (SecurityException ex) {
                    reason = ex.getMessage();
                    status = 403;
                    this.logger.log(16, ex.toString(), (Throwable)ex);
                }
                hash.put("JMQStatus", status);
                if (reason != null) {
                    hash.put("JMQReason", reason);
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block20;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block21;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        return true;
    }
}

