/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RedeliverHandler
extends PacketHandler {
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    static final int REDELIVER_BLOCK_SIZE = 40;
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    private DestinationList DL = Globals.getDestinationList();

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Hashtable props = null;
        try {
            props = msg.getProperties();
        }
        catch (Exception ex) {
            this.logger.logStack(8, "Unable to retrieve  properties from redeliver message " + msg, (Throwable)ex);
            props = new Hashtable();
        }
        boolean redeliver = false;
        TransactionUID tid = null;
        if (props != null) {
            long id;
            Object txnid;
            Boolean bool = (Boolean)props.get("JMQSetRedelivered");
            if (bool != null) {
                redeliver = bool;
            }
            if ((txnid = props.get("JMQTransactionID")) != null) {
                tid = txnid instanceof Integer ? new TransactionUID(((Integer)txnid).intValue()) : new TransactionUID((Long)txnid);
            }
            if (tid == null && (id = msg.getTransactionID()) != 0L) {
                tid = new TransactionUID(id);
            }
        }
        int size = msg.getMessageBodySize();
        int ackcount = size / 40;
        int mod = size % 40;
        if (ackcount == 0) {
            return true;
        }
        if (mod != 0) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Message Size: " + size + ". Not multiple of " + 40));
        }
        if (DEBUG) {
            this.logger.log(4, "RedeliverMessage: processing message {0} {1}", (Object)msg.toString(), (Object)con.getConnectionUID().toString());
        }
        DataInputStream is = new DataInputStream(msg.getMessageBodyStream());
        ConsumerUID[] ids = new ConsumerUID[ackcount];
        SysMessageID[] sysids = new SysMessageID[ackcount];
        try {
            for (int i = 0; i < ackcount; ++i) {
                ids[i] = new ConsumerUID(is.readLong());
                sysids[i] = new SysMessageID();
                sysids[i].readID((DataInput)is);
            }
            this.redeliver(ids, sysids, con, tid, redeliver);
        }
        catch (Exception ex) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Invalid Redeliver Packet", ex), ex);
        }
        return true;
    }

    public void redeliver(ConsumerUID[] ids, SysMessageID[] sysids, IMQConnection con, TransactionUID tid, boolean redeliver) throws BrokerException, IOException {
        SysMessageID sysid = null;
        HashSet<Session> sessions = new HashSet<Session>();
        HashMap cToM = new HashMap();
        HashMap<ConsumerUID, TreeSet<PacketReference>> noConsumerMap = new HashMap<ConsumerUID, TreeSet<PacketReference>>();
        HashMap<ConsumerUID, ConsumerUID> storedIDToConsumerUIDMap = new HashMap<ConsumerUID, ConsumerUID>();
        boolean position = false;
        for (int i = 0; i < ids.length; ++i) {
            LinkedHashSet<PacketReference> set;
            ConsumerUID id = ids[i];
            id.setConnectionUID(con.getConnectionUID());
            sysid = sysids[i];
            PacketReference ref = DestinationList.get(null, sysid, false);
            if (ref == null || ref.isInvalid()) continue;
            Session s = Session.getSession(id);
            Consumer c = null;
            if (s != null) {
                if (!sessions.contains(s)) {
                    s.pause("redeliver");
                    sessions.add(s);
                }
                c = (Consumer)s.getConsumerOnSession(id);
            }
            if (c == null) {
                ConsumerUID storedID;
                c = Consumer.getConsumer(id);
                if (c != null) {
                    this.logger.log(16, "Internal Error  consumer with id of " + id + " is unavailable " + " on session " + s + "[conuid,sess conuid] =" + "[" + con.getConnectionUID().longValue() + "," + (s == null ? 0L : s.getConnectionUID().longValue()) + "] consumer session is : " + (Object)((Object)c.getSessionUID()));
                    continue;
                }
                if (s != null && s.isClientAck(id) && !s.isTransacted() && redeliver && tid == null && (storedID = s.getStoredIDForDetatchedConsumer(id)) != null && !storedID.equals(id)) {
                    storedIDToConsumerUIDMap.put(id, storedID);
                    TreeSet<PacketReference> refset = (TreeSet<PacketReference>)noConsumerMap.get(id);
                    if (refset == null) {
                        refset = new TreeSet<PacketReference>(new RefCompare());
                        noConsumerMap.put(id, refset);
                    }
                    ref.removeInDelivery(storedID);
                    refset.add(ref);
                }
                this.logger.log(4, " consumer with id of " + id + " is unavailable " + " on session " + s + "[conuid,sess conuid] =" + "[" + con.getConnectionUID().longValue() + "," + (s == null ? 0L : s.getConnectionUID().longValue()) + "] it has been closed");
                continue;
            }
            if (redeliver && (tid != null || s.isTransacted())) {
                if (tid == null) {
                    tid = s.getCurrentTransactionID();
                }
                Globals.getDestinationList();
                TransactionList[] tls = DestinationList.getTransactionList(con.getPartitionedStore());
                TransactionList translist = tls[0];
                if (translist != null) {
                    if (this.checkRemovedConsumedMessage(ref, id, tid, translist, true)) {
                        if (!DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "Ignore redeliver request for [" + sysid + ":" + id + "], removed with transaction (rerouted)" + tid);
                        continue;
                    }
                    if (this.checkRemovedConsumedMessage(ref, id, tid, translist, false)) {
                        if (!DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "Ignore redeliver request for [" + sysid + ":" + id + "], removed with transaction " + tid);
                        continue;
                    }
                }
            }
            if ((set = (LinkedHashSet<PacketReference>)cToM.get(c)) == null) {
                set = new LinkedHashSet<PacketReference>();
                cToM.put(c, set);
            }
            if (!set.contains(ref)) {
                ref.removeInDelivery(c.getStoredConsumerUID() == null ? c.getConsumerUID() : c.getStoredConsumerUID());
                set.add(ref);
            } else if (DEBUG_CLUSTER_TXN) {
                this.logger.log(8, "Ignore duplicated redeliver request [" + sysid + ":" + id + "]");
            }
            if (redeliver) {
                ref.consumed(c.getStoredConsumerUID(), s.isDupsOK(c.getConsumerUID()), false);
                continue;
            }
            ref.removeDelivered(c.getStoredConsumerUID(), false);
        }
        for (Map.Entry entry : cToM.entrySet()) {
            Consumer c = (Consumer)entry.getKey();
            Set msgs = (Set)entry.getValue();
            c.pause("start redeliver");
            c.routeMessages(msgs, true);
            c.resume("end redeliver");
        }
        cToM.clear();
        if (noConsumerMap.size() > 0) {
            try {
                this.logger.log(4, "REDELIVER unacked for closed consumers: " + noConsumerMap);
                TransactionHandler.redeliverUnackedNoConsumer(noConsumerMap, storedIDToConsumerUIDMap, redeliver, null, null);
            }
            catch (Exception e) {
                this.logger.logStack(16, "Exception in redelivering unacked messages for closed consumers", (Throwable)e);
            }
        }
        for (Session s : sessions) {
            s.resume("redeliver");
        }
    }

    private boolean checkRemovedConsumedMessage(PacketReference ref, ConsumerUID id, TransactionUID tid, TransactionList translist, boolean rerouted) throws BrokerException {
        SysMessageID sysid = ref.getSysMessageID();
        HashMap cmap = translist.retrieveRemovedConsumedMessages(tid, rerouted);
        if (cmap != null && cmap.size() > 0) {
            List interests = (List)cmap.get(sysid);
            if (interests == null || interests.size() == 0) {
                return false;
            }
            for (int j = 0; j < interests.size(); ++j) {
                TransactionState ts;
                ConsumerUID intid = (ConsumerUID)interests.get(j);
                if (!intid.equals(id) || (ts = translist.retrieveState(tid)) == null || ts.getState() != 2) continue;
                if (!rerouted) {
                    TransactionHandler.releaseRemoteForActiveConsumer(ref, id, tid, translist);
                }
                return true;
            }
        }
        return false;
    }
}

