/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class PauseHandler
extends AdminCmdHandler {
    private static boolean DEBUG = PauseHandler.getDEBUG();

    public PauseHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Pausing: " + cmd_props);
        }
        String pauseTarget = (String)cmd_props.get("JMQPauseTarget");
        String service = (String)cmd_props.get("JMQServiceName");
        String destination = (String)cmd_props.get("JMQDestination");
        Integer type = (Integer)cmd_props.get("JMQDestType");
        Integer pauseType = (Integer)cmd_props.get("JMQDestState");
        int status = 200;
        String errMsg = null;
        assert (service == null || destination == null);
        if (pauseTarget == null) {
            pauseTarget = "JMQServiceName";
        }
        try {
            if ("JMQServiceName".equals(pauseTarget)) {
                if (service == null) {
                    this.logger.log(8, "B1252");
                } else {
                    this.logger.log(8, "B1124", (Object)service);
                }
                PauseHandler.pauseService(true, service);
            } else if ("JMQDestination".equals(pauseTarget)) {
                int pauseval;
                this.logger.log(8, "B1125", (Object)destination);
                int n = pauseval = pauseType == null ? 3 : pauseType;
                if (destination == null) {
                    Iterator[] itrs = DestinationList.getAllDestinations(null);
                    Iterator itr = itrs[0];
                    while (itr.hasNext()) {
                        Destination d = (Destination)itr.next();
                        if (d.isInternal() || d.isAdmin() || d.isTemporary()) continue;
                        d.pauseDestination(pauseval);
                    }
                } else {
                    Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue((int)type));
                    Destination d = ds[0];
                    if (d == null) {
                        String msg;
                        errMsg = msg = Globals.getBrokerResources().getString("B1126", (DestType.isQueue((int)type) ? " queue:" : " topic:") + destination);
                        status = 404;
                        this.logger.log(32, msg);
                    } else if (d.isInternal() || d.isAdmin()) {
                        errMsg = Globals.getBrokerResources().getString("B1127", (DestType.isQueue((int)type) ? " queue:" : " topic:") + destination);
                        this.logger.log(8, errMsg);
                        status = 500;
                    } else {
                        d.pauseDestination(pauseval);
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.log(32, "B3064", (Object)service, (Throwable)e);
            status = 500;
            errMsg = this.rb.getString("B3064", service) + ": " + e;
        }
        catch (BrokerException e) {
            this.logger.log(32, "B3064", (Object)service, (Throwable)e);
            status = 500;
            errMsg = this.rb.getString("B3064", service) + ": " + e;
        }
        catch (IllegalArgumentException e) {
            errMsg = e.getMessage();
            status = 404;
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        PauseHandler.setProperties(reply, 31, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }

    public static void pauseService(boolean pause, String serviceName) throws BrokerException, IllegalArgumentException {
        ServiceManager sm = Globals.getServiceManager();
        Object activeServices = null;
        BrokerResources rb = Globals.getBrokerResources();
        if (serviceName != null && sm.getService(serviceName) == null) {
            throw new IllegalArgumentException(rb.getString("B4057", serviceName));
        }
        if (pause) {
            if (serviceName == null) {
                sm.pauseAllActiveServices(0, true);
            } else {
                sm.pauseService(serviceName, true);
            }
        } else if (serviceName == null) {
            sm.resumeAllActiveServices(0);
        } else {
            sm.resumeService(serviceName);
        }
    }
}

