/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.DeleteAllMessages;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.Filter;
import java.util.Hashtable;

public class PurgeDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = PurgeDestinationHandler.getDEBUG();
    private Filter deleteAll = new DeleteAllMessages();

    public PurgeDestinationHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Purging: " + cmd_props);
        }
        assert (cmd_props != null);
        String destination = (String)cmd_props.get("JMQDestination");
        Integer destType = (Integer)cmd_props.get("JMQDestType");
        assert (destination != null);
        assert (destType != null);
        int status = 200;
        String errMsg = null;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else {
            String criteria_str = Globals.getBrokerResources().getKString("B1035");
            this.logger.log(8, "B1034", (Object)destination, (Object)criteria_str);
            try {
                Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue((int)destType));
                Destination d = null;
                for (int i = 0; i < ds.length; ++i) {
                    d = ds[i];
                    if (d == null) continue;
                    if (i == 0) {
                        Globals.getAuditSession().destinationOperation(con.getUserName(), con.remoteHostString(), "purge destination", d.isQueue() ? "queue" : "topic", d.getDestinationName());
                    }
                    d.purgeDestination();
                }
                if (d == null) {
                    errMsg = Globals.getBrokerResources().getKString("B3128", this.getDestinationType(destType), destination);
                    BrokerException e = new BrokerException(errMsg);
                    e.fillInStackTrace();
                    status = 500;
                    this.logger.log(16, "B2025", (Throwable)e);
                }
            }
            catch (BrokerException ex) {
                status = 500;
                errMsg = PurgeDestinationHandler.getMessageFromException(ex);
                this.logger.log(16, "B2025", (Throwable)ex);
            }
            catch (OutOfMemoryError err) {
                throw err;
            }
            catch (Throwable ex) {
                status = 500;
                errMsg = Globals.getBrokerResources().getString("B4117", ex);
                this.logger.logStack(16, "B2025", ex);
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        PurgeDestinationHandler.setProperties(reply, 33, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

