/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.PauseHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;
import java.util.Iterator;

public class ResumeHandler
extends AdminCmdHandler {
    private static boolean DEBUG = ResumeHandler.getDEBUG();

    public ResumeHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + "Resuming: " + cmd_props);
        }
        String pauseTarget = (String)cmd_props.get("JMQPauseTarget");
        String service = (String)cmd_props.get("JMQServiceName");
        String destination = (String)cmd_props.get("JMQDestination");
        Integer type = (Integer)cmd_props.get("JMQDestType");
        int status = 200;
        String errMsg = null;
        assert (service == null || destination == null);
        if (pauseTarget == null) {
            pauseTarget = "JMQServiceName";
        }
        try {
            if ("JMQServiceName".equals(pauseTarget)) {
                if (service == null) {
                    this.logger.log(8, "B1253");
                } else {
                    this.logger.log(8, "B1128", (Object)service);
                }
                PauseHandler.pauseService(false, service);
            } else if ("JMQDestination".equals(pauseTarget)) {
                this.logger.log(8, "B1129", (Object)destination);
                PauseHandler.pauseService(false, service);
                if (destination == null) {
                    Iterator[] itrs = DestinationList.getAllDestinations(null);
                    Iterator itr = itrs[0];
                    while (itr.hasNext()) {
                        Destination d = (Destination)itr.next();
                        if (!d.isPaused()) continue;
                        d.resumeDestination();
                    }
                } else {
                    Destination[] ds = DestinationList.getDestination(null, destination, DestType.isQueue((int)type));
                    Destination d = ds[0];
                    if (d != null) {
                        d.resumeDestination();
                    } else {
                        String msg;
                        errMsg = msg = Globals.getBrokerResources().getString("B1287", (DestType.isQueue((int)type) ? " queue:" : " topic:") + destination);
                        status = 404;
                        this.logger.log(32, msg);
                    }
                }
            }
        }
        catch (Exception e) {
            status = 500;
            errMsg = this.rb.getString("B4093", service, e.toString());
            this.logger.log(32, errMsg, (Throwable)e);
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        ResumeHandler.setProperties(reply, 37, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

