/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.license;

import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class LicenseBase {
    protected Properties props = new Properties();
    private boolean autoChecking = true;
    private int daysToTry = 0;
    private Date expirationDate = null;
    private Date startDate = null;
    protected static final long LICENSE_MAGIC_NUMBER = 1011902605893L;
    private static final String CURRENT_FILE_VERSION = "4";
    public static final String CURRENT_LICENSE_VERSION = "4.4 FCS";
    public static final String PROP_FILE_VERSION = "imq.file_version";
    public static final String PROP_LICENSE_VERSION = "imq.license_version";
    public static final String PROP_LICENSE_TYPE = "imq.license_type";
    public static final String PROP_DATE_STRING = "date_string";
    public static final String PROP_PRECEDENCE = "imq.precedence";
    public static final String PROP_DESCRIPTION = "description";
    protected static final String NONE_STRING = "NONE";
    protected static final String TRY_STRING = "TRY";
    protected static final String VALID_STRING = "VALID";
    protected static final String OPEN_BRACKET = "[";
    protected static final String CLOSE_BRACKET = "]";
    protected static final String DASH = "-";
    public static final String PROP_CLIENT_CONNLIMIT = "imq.max_client_conns";
    public static final String PROP_BROKER_CONNLIMIT = "imq.max_broker_conns";
    public static final String PROP_MAX_BACKUP_CONS = "imq.max_backup_cons";
    public static final String PROP_MAX_ACTIVE_CONS = "imq.max_active_cons";
    public static final String PROP_ENABLE_CLUSTER = "imq.enable_cluster";
    public static final String PROP_ENABLE_HTTP = "imq.enable_http";
    public static final String PROP_ENABLE_SSL = "imq.enable_ssl";
    public static final String PROP_ENABLE_SHAREDPOOL = "imq.enable_sharedpool";
    public static final String PROP_ENABLE_C_API = "imq.enable_c_api";
    public static final String PROP_ENABLE_FAILOVER = "imq.enable_failover";
    public static final String PROP_ENABLE_MONITORING = "imq.enable_monitoring";
    public static final String PROP_ENABLE_LOCALDEST = "imq.enable_localdest";
    public static final String PROP_ENABLE_DMQ = "imq.enable_dmq";
    public static final String PROP_ENABLE_CLIENTPING = "imq.enable_clientping";
    public static final String PROP_ENABLE_MSGBODY_COMPRESSION = "imq.enable_msgbody_compression";
    public static final String PROP_ENABLE_SHARED_SUB = "imq.enable_shared_sub";
    public static final String PROP_ENABLE_AUDIT_CCC = "imq.enable_audit_ccc";
    public static final String PROP_ENABLE_NO_ACK = "imq.enable_no_ack";
    public static final String PROP_ENABLE_RECONNECT = "imq.enable_reconnect";
    public static final String PROP_ENABLE_HA = "imq.enable_ha";
    protected static final BrokerResources br = CommGlobals.getBrokerResources();
    protected static final Logger logger = CommGlobals.getLogger();

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public int getIntProperty(String name, int defval) {
        try {
            return Integer.parseInt(this.getProperty(name));
        }
        catch (Exception e) {
            return defval;
        }
    }

    public boolean getBooleanProperty(String name, boolean defval) {
        try {
            return Boolean.valueOf(this.getProperty(name));
        }
        catch (Exception e) {
            return defval;
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public int getPrecedence() {
        int ret = 0;
        try {
            ret = Integer.parseInt(this.props.getProperty(PROP_PRECEDENCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean willExpire() {
        String dateString = this.props.getProperty(PROP_DATE_STRING);
        return dateString == null || !dateString.equals(NONE_STRING);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date d) {
        this.startDate = d;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date d) {
        this.expirationDate = d;
    }

    public int getDaysToTry() {
        return this.daysToTry;
    }

    public void setDaysToTry(int d) {
        this.daysToTry = d;
    }

    public boolean isLicenseFileRequired() {
        return true;
    }

    public void setAutoChecking(boolean autoChecking) {
        this.autoChecking = autoChecking;
    }

    public void superimpose(Properties newprops) throws BrokerException {
        Enumeration<?> names = newprops.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = newprops.getProperty(name);
            this.props.setProperty(name, value);
        }
        this.processLicenseInfo();
    }

    private void processLicenseInfo() throws BrokerException {
        if (!this.autoChecking) {
            return;
        }
        String fileVersion = this.props.getProperty(PROP_FILE_VERSION);
        if (fileVersion == null || !fileVersion.equals(CURRENT_FILE_VERSION)) {
            throw new BrokerException(br.getString("B3054"));
        }
        String licenseVersion = this.props.getProperty(PROP_LICENSE_VERSION);
        if (licenseVersion == null || !licenseVersion.equals(CURRENT_LICENSE_VERSION)) {
            throw new BrokerException(br.getString("B3054"));
        }
        this.parseDateString();
        this.checkValidity();
    }

    private void parseDateString() throws BrokerException {
        String dateString = this.props.getProperty(PROP_DATE_STRING);
        if (dateString == null) {
            throw new BrokerException(br.getString("B3054"));
        }
        if (!dateString.startsWith(NONE_STRING)) {
            if (dateString.startsWith(TRY_STRING)) {
                int oindex = dateString.indexOf(OPEN_BRACKET);
                int cindex = dateString.indexOf(CLOSE_BRACKET);
                int d = Integer.parseInt(dateString.substring(oindex + 1, cindex));
                this.setDaysToTry(d);
            } else if (dateString.startsWith(VALID_STRING)) {
                int oindex = dateString.indexOf(OPEN_BRACKET);
                int dashindex = dateString.indexOf(DASH);
                int cindex = dateString.indexOf(CLOSE_BRACKET);
                if (dashindex - oindex > 1) {
                    long start = Long.parseLong(dateString.substring(oindex + 1, dashindex));
                    this.setStartDate(new Date(start));
                }
                if (cindex - dashindex > 1) {
                    long end = Long.parseLong(dateString.substring(dashindex + 1, cindex));
                    this.setExpirationDate(new Date(end));
                }
            } else {
                throw new BrokerException(br.getString("B3054"));
            }
        }
    }

    private void checkValidity() throws BrokerException {
        if (!this.willExpire()) {
            return;
        }
        if (this.getExpirationDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getExpirationDate());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (cal.getTime().getTime() <= new Date().getTime()) {
                throw new BrokerException(br.getString("B3055", cal.getTime()));
            }
        } else if (this.getStartDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getStartDate());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (new Date().getTime() < cal.getTime().getTime()) {
                throw new BrokerException(br.getString("B3111", this.getStartDate()));
            }
        }
    }
}

