/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PingHandler
extends GPacketHandler {
    private static boolean DEBUG = false;
    private HashMap<BrokerAddress, AtomicInteger> pingLogging = new HashMap();

    public PingHandler(RaptorProtocol p) {
        super(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enablePingLogging(BrokerAddress addr) {
        AtomicInteger logreq;
        HashMap<BrokerAddress, AtomicInteger> hashMap = this.pingLogging;
        synchronized (hashMap) {
            logreq = this.pingLogging.get(addr);
            if (logreq == null) {
                this.pingLogging.put(addr, new AtomicInteger(2));
                return;
            }
        }
        logreq.compareAndSet(0, 2);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == 33) {
            this.logPing(33, sender);
            if (pkt.getBit(1)) {
                GPacket gp = GPacket.getInstance();
                gp.setType((short)34);
                gp.putProp((Object)"S", (Object)200);
                try {
                    this.c.unicast(sender, gp);
                }
                catch (IOException e) {}
            }
        } else if (pkt.getType() == 34) {
            this.logPing(34, sender);
        } else {
            this.logger.log(16, "PingHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logPing(int ptype, BrokerAddress sender) {
        AtomicInteger logreq;
        HashMap<BrokerAddress, AtomicInteger> hashMap = this.pingLogging;
        synchronized (hashMap) {
            logreq = this.pingLogging.get(sender);
        }
        if (logreq != null && logreq.get() > 0 || DEBUG) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(ptype), "", sender};
            this.logger.log(8, this.br.getKString("B1173", args));
            if (logreq != null && logreq.get() > 0) {
                logreq.decrementAndGet();
            }
        }
    }
}

