/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStoreUtil;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BrokerCurrentFile;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.security.SecureRandom;
import java.util.List;

public final class BrokerStateFile {
    public static final int FILE_MAGIC_NUMBER = -1161970725;
    private static final String DELETE_FILENAME = "delete";
    private static final String BROKERSTATE_FILENAME = "brokerstate";
    private static final String REP_HOSTPORT_FILENAME_PREFIX = "hostport.";
    BrokerResources br = Globals.getBrokerResources();
    Logger logger = Globals.getLogger();
    private File file = null;
    private RandomAccessFile raf = null;
    private FileLock lock = null;
    UID uid = null;
    String id = null;
    File envhome = null;

    public BrokerStateFile(File envtop, File bdbtop, boolean newstore, Object o, String instn, boolean readonly) throws Exception {
        String inst;
        if (newstore) {
            BrokerCurrentFile currentfile = (BrokerCurrentFile)o;
            UID u = null;
            String ebrokerid = null;
            File f = null;
            while ((f = new File(envtop, ebrokerid = MigratableStoreUtil.makeEffectiveBrokerID(instn, u = BrokerStateFile.genUID()))).exists()) {
                this.logger.log(16, this.br.getKString("B2252", f.getPath()));
            }
            this.uid = u;
            this.id = ebrokerid;
            currentfile.writeStoreSession(this.uid);
            if (!f.mkdir()) {
                String emsg = this.br.getKString("B3017", f.getPath());
                throw new IOException(emsg);
            }
            this.envhome = f;
        } else {
            UID uid;
            this.uid = uid = (UID)o;
            this.id = MigratableStoreUtil.makeEffectiveBrokerID(instn, uid);
            File f = new File(envtop, this.id);
            if (!f.exists()) {
                String emsg = this.br.getKString("B2253", f.getPath());
                throw new IOException(emsg);
            }
            this.envhome = f;
        }
        this.file = new File(bdbtop, BROKERSTATE_FILENAME);
        if (readonly) {
            this.raf = new RandomAccessFile(this.file, "r");
            this.lock = this.raf.getChannel().tryLock(0L, Long.MAX_VALUE, true);
        } else {
            this.raf = new RandomAccessFile(this.file, "rwd");
            this.lock = this.raf.getChannel().tryLock();
        }
        if (this.lock == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B4373", this.file.getPath()));
        }
        if (newstore) {
            this.writeNewStoreSession(instn, this.uid);
        }
        int state = this.readBrokerState();
        BrokerState st = null;
        try {
            st = BrokerState.getState(state);
        }
        catch (IndexOutOfBoundsException e) {
            String emsg = this.br.getKString("B1043", this.file.getPath());
            throw new IOException(emsg);
        }
        if (!newstore || Store.getDEBUG()) {
            this.logger.log(8, this.br.getKString("B1416", this.file.getPath(), st.toString()));
        }
        if (!(inst = this.readBrokerInstName()).equals(instn)) {
            Object[] args = new String[]{inst, this.file.getPath(), instn};
            String emsg = this.br.getKString("B4378", args);
            throw new IOException(emsg);
        }
    }

    private static UID genUID() {
        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1415"));
        SecureRandom srd = new SecureRandom();
        byte[] bs = new byte[2];
        long idlong = -1L;
        while (idlong < 0L) {
            srd.nextBytes(bs);
            short prefix = (short)(bs[0] << 8 | bs[1] & 0xFF);
            if (BDBStore.getDEBUG()) {
                Globals.getLogger().log(8, "Create new store session UID with prefix: " + prefix);
            }
            idlong = Math.abs(UniqueID.generateID((short)prefix));
        }
        return new UID(idlong);
    }

    protected void writeNewStoreSession(String instname, UID uid) throws Exception {
        if (this.raf == null || this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        byte[] data = instname.getBytes("UTF8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt(-1161970725);
        dos.writeInt(data.length);
        dos.write(data, 0, data.length);
        dos.writeLong(uid.longValue());
        dos.writeInt(0);
        dos.writeInt(-1161970725);
        dos.flush();
        bos.flush();
        byte[] bytes = bos.toByteArray();
        dos.close();
        this.raf.seek(0L);
        this.raf.write(bytes);
        this.raf.getChannel().force(false);
    }

    protected void writeBrokerState(BrokerState state, BrokerState expectedState) throws Exception {
        if (this.raf == null || this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        this.raf.seek(4L);
        int len = this.raf.readInt();
        this.raf.seek(8L + (long)len + 8L);
        int oldstate = this.raf.readInt();
        this.raf.seek(8L + (long)len + 8L);
        this.raf.writeInt(state.intValue());
        this.raf.getChannel().force(false);
    }

    protected int readBrokerState() throws Exception {
        if (this.raf == null || this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        this.raf.seek(4L);
        int len = this.raf.readInt();
        this.raf.seek(8L + (long)len + 8L);
        return this.raf.readInt();
    }

    protected long readBrokerStoreSession() throws Exception {
        if (this.raf == null || this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        this.raf.seek(4L);
        int len = this.raf.readInt();
        this.raf.seek(8L + (long)len);
        return this.raf.readLong();
    }

    protected String readBrokerInstName() throws Exception {
        if (this.raf == null || this.lock == null) {
            throw new IllegalStateException("Not initialized");
        }
        this.raf.seek(4L);
        int len = this.raf.readInt();
        this.raf.seek(8L);
        byte[] data = new byte[len];
        this.raf.readFully(data);
        return new String(data, "UTF8");
    }

    protected void close() {
        try {
            this.lock.release();
        }
        catch (Exception e) {
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B4374", this.file.getPath()));
        }
        try {
            this.raf.close();
        }
        catch (Exception e) {
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B4375", this.file.getPath()));
        }
    }

    protected static void removeEnvhome(File envtop, String ebrokerid) {
        File f = new File(envtop, ebrokerid);
        File nf = new File(envtop, ebrokerid + ".deleted");
        if (!f.renameTo(nf)) {
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2249", f.getPath(), nf.getPath()));
        }
    }

    protected static synchronized void writeRepHostPortFile(File parent, String instn, String hostport) throws IOException {
        if (!parent.exists() && !parent.mkdirs()) {
            String emsg = Globals.getBrokerResources().getKString("B3297", parent.getPath());
            throw new IOException(emsg);
        }
        File f = new File(parent, REP_HOSTPORT_FILENAME_PREFIX + instn);
        RandomAccessFile raf = new RandomAccessFile(f, "rwd");
        raf.seek(0L);
        raf.writeUTF(hostport);
        raf.getChannel().force(true);
        raf.close();
    }

    private static synchronized String readRepHostPortFile(File instf) throws IOException {
        if (!instf.exists()) {
            return null;
        }
        RandomAccessFile raf = new RandomAccessFile(instf, "r");
        raf.seek(0L);
        String hostport = raf.readUTF();
        raf.close();
        return hostport;
    }

    protected static String readHostFromRepHostPortFile(File parent, String instn) throws IOException {
        File f = new File(parent, REP_HOSTPORT_FILENAME_PREFIX + instn);
        String hostport = BrokerStateFile.readRepHostPortFile(f);
        if (hostport == null) {
            return null;
        }
        int index = hostport.lastIndexOf(":");
        if (index <= 0 || index == hostport.length() - 1) {
            throw new IOException("Unexpected hostport format stored in " + f.getPath());
        }
        return hostport.substring(0, index);
    }

    protected static Integer readPortFromRepHostPortFile(File parent, String instn) throws IOException {
        File f = new File(parent, REP_HOSTPORT_FILENAME_PREFIX + instn);
        String hostport = BrokerStateFile.readRepHostPortFile(f);
        if (hostport == null) {
            return null;
        }
        int index = hostport.lastIndexOf(":");
        if (index <= 0 || index == hostport.length() - 1) {
            throw new IOException("Unexpected hostport format stored in " + f.getPath());
        }
        int port = -1;
        try {
            port = Integer.parseInt(hostport.substring(index + 1));
            if (port <= 0) {
                throw new IOException("Invalid port number stored in " + f.getPath());
            }
        }
        catch (Exception e) {
            IOException ee = new IOException("Invalid port number stored in " + f.getPath());
            ee.initCause(e);
            throw ee;
        }
        return port;
    }

    protected static synchronized Integer readLastPortFromRepHostPortFile(File parent, List<Integer> ports) throws IOException {
        if (!parent.exists()) {
            return null;
        }
        String[] files = parent.list();
        if (files == null) {
            return null;
        }
        Integer port = null;
        int endport = -1;
        String f = null;
        File ff = null;
        for (int i = 0; i < files.length; ++i) {
            String instn;
            f = files[i];
            if (!files[i].startsWith(REP_HOSTPORT_FILENAME_PREFIX) || !(ff = new File(parent, f)).isFile() || (port = BrokerStateFile.readPortFromRepHostPortFile(parent, instn = f.substring(REP_HOSTPORT_FILENAME_PREFIX.length()))) == null) continue;
            ports.add(port);
            if (port <= endport) continue;
            endport = port;
        }
        if (endport == -1) {
            return null;
        }
        return endport;
    }
}

