/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.ConsumerUIDTupleBinding;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;

class InterestStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private Database db = null;
    private TupleBinding keyBinding = null;
    private EntryBinding dataBinding = null;

    protected InterestStore(BDBStore p) {
        this.db = p.getIntDatabase();
        this.keyBinding = new ConsumerUIDTupleBinding();
        this.dataBinding = new SerialBinding((ClassCatalog)p.getClassCatalog(), Consumer.class);
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("dbCount", String.valueOf(this.db.count()));
        t.put("dbConfig", String.valueOf(this.db.getConfig()));
        return t;
    }

    protected void storeInterest(Transaction txn, Consumer interest) throws BrokerException {
        ConsumerUID cuid = interest.getConsumerUID();
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.keyBinding.objectToEntry((Object)cuid, key);
            DatabaseEntry data = new DatabaseEntry();
            this.dataBinding.objectToEntry((Object)interest, data);
            OperationStatus status = this.db.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                String emsg = this.br.getKString("B3010", cuid, interest.getDestinationUID().getLongString());
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4012", cuid);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void removeInterest(Transaction txn, Consumer interest) throws BrokerException {
        ConsumerUID cuid = interest.getConsumerUID();
        boolean thrownotfound = false;
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.keyBinding.objectToEntry((Object)cuid, key);
            OperationStatus status = this.db.delete(txn, key);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3011", cuid, interest.getDestinationUID().getLongString());
                this.logger.log(32, emsg);
                thrownotfound = true;
                throw new DestinationNotFoundException(emsg);
            }
        }
        catch (Exception e) {
            if (e instanceof DestinationNotFoundException && thrownotfound) {
                throw (DestinationNotFoundException)e;
            }
            String emsg = this.br.getKString("B4034", cuid);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected Consumer[] getAllInterests(Transaction txn) throws BrokerException {
        ArrayList<Consumer> interests = new ArrayList<Consumer>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            ConsumerUID cuid = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cuid = (ConsumerUID)this.keyBinding.entryToObject(key);
                interests.add((Consumer)this.dataBinding.entryToObject(data));
            }
            cs.close();
            Consumer[] consumerArray = interests.toArray(new Consumer[interests.size()]);
            return consumerArray;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4035");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all interests from database: " + e.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction txn) throws BrokerException {
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cs.delete();
            }
            cs.close();
        }
        catch (Exception e) {
            String emsg = "Failed to clear all interests in store";
            this.logger.logStack(32, emsg, (Throwable)e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in clearing all interests from store: " + e.getMessage());
                }
            }
        }
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "InterestStore: closing with " + this.db.count() + " interests");
        }
    }
}

