/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.AutoClusterBrokerMap;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusterReason;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.util.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.persist.coherence.AutoClusterBrokerMapImpl")
@Singleton
public class AutoClusterBrokerMapImpl
extends HashMap
implements AutoClusterBrokerMap,
MemberListener {
    private static boolean DEBUG = false;
    private static final String MQ_BROKER_TABLE = "MQ_BROKER_TABLE";
    private static final int CACHE_LOCK_WAIT_DEFAULT = 15;
    private static final String CACHE_LOCK_WAIT_PROP = "imq.cluster.coherence.lockWait";
    private NamedCache brokerTable = null;
    private ClusterManagerImpl parent = null;

    public AutoClusterBrokerMapImpl() {
    }

    public AutoClusterBrokerMapImpl(ClusterManagerImpl p, MQAddress address) throws BrokerException {
        this.init(p, address);
    }

    @Override
    public void init(ClusterManager mgr, MQAddress address) throws BrokerException {
        this.parent = (ClusterManagerImpl)mgr;
        String clusterid = Globals.getClusterID();
        if (clusterid == null || clusterid.length() == 0) {
            throw new BrokerException("imq.cluster.clusterid must set");
        }
        String cname = "MQC" + Globals.getClusterID() + "CACHE:MQ_BROKER_TABLE";
        this.brokerTable = CacheFactory.getCache((String)cname);
        CacheService s = this.brokerTable.getCacheService();
        s.addMemberListener((MemberListener)this);
        String myid = s.getCluster().getLocalMember().getUid().toString();
        this.brokerTable.put((Object)myid, (Object)address.toString());
        this.updateMap(address);
    }

    private boolean isClusterMember(UID uid) {
        Cluster cl = this.brokerTable.getCacheService().getCluster();
        Member m2 = null;
        if (uid.equals((Object)cl.getLocalMember().getUid())) {
            return true;
        }
        for (Member m2 : cl.getMemberSet()) {
            if (!m2.getUid().equals((Object)uid)) continue;
            return true;
        }
        return false;
    }

    public void memberJoined(MemberEvent evt) {
        Globals.getLogger().log(8, "Cluster cache service event: " + evt);
    }

    public void memberLeaving(MemberEvent evt) {
        Globals.getLogger().log(8, "Cluster cache service event: " + evt);
    }

    public void memberLeft(MemberEvent evt) {
        Globals.getLogger().log(8, "Cluster cache service event: " + evt);
    }

    @Override
    public void updateMap() throws BrokerException {
        assert (Thread.holdsLock(this));
        this.updateMap(false);
    }

    private String getBrokerName(MQAddress addr) {
        assert (Thread.holdsLock(this));
        for (ClusteredBroker cb : this.values()) {
            if (!cb.getBrokerURL().equals((Object)addr)) continue;
            return cb.getBrokerName();
        }
        return null;
    }

    @Override
    public void updateMap(boolean all) throws BrokerException {
        assert (Thread.holdsLock(this));
        this.updateMap(null);
    }

    private void updateMap(MQAddress myaddr) throws BrokerException {
        Object map = null;
        String myid = this.brokerTable.getCacheService().getCluster().getLocalMember().getUid().toString();
        ArrayList<String> removes = new ArrayList<String>();
        LinkedHashMap<BrokerMQAddress, String> mi = new LinkedHashMap<BrokerMQAddress, String>();
        BrokerMQAddress addr = null;
        String id = null;
        String url = null;
        Object var9_9 = null;
        for (Map.Entry entry : this.brokerTable.entrySet()) {
            id = (String)entry.getKey();
            url = (String)entry.getValue();
            try {
                addr = BrokerMQAddress.createAddress(url);
            }
            catch (Exception e) {
                Globals.getLogger().log(16, "Unable to create broker address for broker " + url + ": " + e.getMessage(), (Throwable)e);
                continue;
            }
            if (mi.get((Object)addr) == null) {
                mi.put(addr, id);
                continue;
            }
            if (this.isClusterMember(new UID(id))) {
                mi.put(addr, id);
                continue;
            }
            if (myaddr != null && addr.equals(myaddr)) {
                removes.add(id);
                continue;
            }
            if (!DEBUG) continue;
            Globals.getLogger().log(8, "Ignore broker table cache entry " + url + "[" + id + "]");
        }
        String o = null;
        ClusteredBroker cb = null;
        for (Map.Entry entry : mi.entrySet()) {
            addr = (MQAddress)entry.getKey();
            id = (String)entry.getValue();
            o = this.getBrokerName(addr);
            if (o != null) continue;
            Globals.getLogger().log(8, "Auto-clustering with broker at " + (Object)((Object)addr) + "[" + id + "]");
            cb = this.parent.newClusteredBroker(addr, id.equals(myid), null);
            this.put(cb.getBrokerName(), cb);
            this.parent.brokerChanged(ClusterReason.ADDED, cb.getBrokerName(), null, cb, cb.getBrokerSessionUID(), null);
        }
        Iterator<Object> itr = this.values().iterator();
        while (itr.hasNext()) {
            cb = (ClusteredBroker)itr.next();
            if (mi.get(cb.getBrokerURL()) != null) continue;
            itr.remove();
            this.parent.brokerChanged(ClusterReason.REMOVED, cb.getBrokerName(), cb, null, cb.getBrokerSessionUID(), null);
        }
        itr = removes.iterator();
        while (itr.hasNext()) {
            this.brokerTable.remove((Object)((String)itr.next()));
            if (!DEBUG) continue;
            Globals.getLogger().log(8, "Cleanup broker table cache entry " + id + " of this broker");
        }
    }

    @Override
    public Object get(Object key) {
        assert (Thread.holdsLock(this));
        return this.get(key, false);
    }

    @Override
    public Object get(Object key, boolean update) {
        assert (Thread.holdsLock(this));
        Object o = super.get(key);
        if (o == null || update) {
            try {
                this.updateMap(true);
            }
            catch (Exception e) {
                Globals.getLogger().logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        return super.get(key);
    }
}

