/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.coherence.ConfigRecordStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.DestinationStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.PropertiesStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.TxnStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service(name="com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore")
@Singleton
public class CoherenceStore
extends Store
implements PartitionedStore {
    public static final int STORE_VERSION = 460;
    static final String COHERENCE_PROP_PREFIX = "imq.persist.coherence.";
    private static final ConsumerUID[] emptyiid = new ConsumerUID[0];
    private static final int[] emptystate = new int[0];
    private AtomicBoolean isClosed = new AtomicBoolean(true);
    private InterestStore intStore = null;
    private NamedCache dstCache = null;
    private DestinationStore dstStore = null;
    private MsgStore msgStore = null;
    private TxnStore txnStore = null;
    private ConfigRecordStore configStoreStore = null;
    private PropertiesStore propStore = null;
    private String cacheNamePrefix = null;
    private UID partitionid = PartitionedStore.DEFAULT_UID;

    public CoherenceStore() throws Exception {
        String brokerID = Globals.getBrokerID();
        if (brokerID == null || brokerID.length() == 0) {
            throw new BrokerException("imq.brokerid must set");
        }
        this.cacheNamePrefix = Globals.getClusterID() != null ? "C" + Globals.getClusterID() + "S" + brokerID + "CACHE" : "S" + brokerID + "CACHE";
        logger.logToAll(8, "Using coherence store with cache name prefix " + this.cacheNamePrefix);
        this.dstCache = CacheFactory.getCache((String)(this.cacheNamePrefix + "dstcache"));
        this.dstStore = new DestinationStore(this);
        this.msgStore = new MsgStore(this);
        this.intStore = new InterestStore(this);
        this.txnStore = new TxnStore(this);
        this.configStoreStore = new ConfigRecordStore(this);
        this.propStore = new PropertiesStore(this);
        this.isClosed.set(false);
    }

    protected String getCacheNamePrefix() {
        return this.cacheNamePrefix;
    }

    @Override
    public final int getStoreVersion() {
        return 460;
    }

    @Override
    public void close(boolean cleanup) {
        this.setClosedAndWait();
        this.dstStore.close(cleanup);
        this.msgStore.close(cleanup);
        this.intStore.close(cleanup);
        this.txnStore.close(cleanup);
        this.configStoreStore.close(cleanup);
        this.propStore.close(cleanup);
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.close(" + cleanup + ") done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll(boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.clearAll(" + sync + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.clearAll();
            this.intStore.clearAll();
            this.dstStore.clearAll(false);
            this.txnStore.clearAll();
            this.configStoreStore.clearAll();
            this.propStore.clearAll();
            if (Store.getDEBUG()) {
                logger.log(8, "CoherenceStore cleared");
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID dst, Packet message, ConsumerUID[] iids, int[] states, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.storeMessage(" + dst + ", " + message.getSysMessageID() + ", " + Arrays.toString(iids) + ", " + Arrays.toString(states) + ", " + sync + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (dst == null || message == null || iids == null || states == null) {
                throw new NullPointerException();
            }
            if (iids.length == 0 || iids.length != states.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeMessage(dst, message, iids, states);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID dst, Packet message, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeMessage() called for " + message.getSysMessageID());
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.storeMessage(dst, message, emptyiid, emptystate);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessage(DestinationUID dst, SysMessageID id, boolean sync, boolean onRollback) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeMessage() called for " + dst + ";" + id);
        }
        if (id == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeMessage(dst, id);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveMessage(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] ints, int[] states, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.moveMessage() called for: " + message.getSysMessageID() + " from " + from + " to " + to);
        }
        if (message == null || from == null || to == null) {
            throw new NullPointerException();
        }
        if (ints == null) {
            ints = emptyiid;
            states = emptystate;
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.moveMessage(message, from, to, ints, states);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMessages(Destination destination, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.removeAllMessages(Destination) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeAllMessages(destination.getDestinationUID(), sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration messageEnumeration(Destination dst) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.messageEnumeration(Destination) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgStore.messageEnumeration(dst.getDestinationUID());
            return enumeration;
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Packet getMessage(DestinationUID dst, String id) throws BrokerException {
        return this.getMessage(dst, SysMessageID.get((String)id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet getMessage(DestinationUID dst, SysMessageID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getMessage() called");
        }
        if (id == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Packet packet = this.msgStore.getMessage(dst, id);
            return packet;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterestStates(DestinationUID dst, SysMessageID mid, ConsumerUID[] iids, int[] states, boolean sync, Packet msg) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeInterestStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (mid == null || iids == null || states == null) {
                throw new NullPointerException();
            }
            if (iids.length == 0 || iids.length != states.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeInterestStates(dst, mid, iids, states, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID id, int state, boolean sync, TransactionUID txid, boolean isLastAck) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.updateInterestState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (mid == null || id == null) {
                throw new NullPointerException();
            }
            this.msgStore.updateInterestState(dst, mid, id, state, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInterestState(DestinationUID dst, SysMessageID mid, ConsumerUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getInterestState() called");
        }
        if (mid == null || id == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            int n = this.msgStore.getInterestState(dst, mid, id);
            return n;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getInterestStates(DestinationUID did, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getInterestStates() called");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getInterestStates(did, mid);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID dst, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getConsumerUIDs() called");
        }
        if (mid == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            ConsumerUID[] consumerUIDArray = this.msgStore.getConsumerUIDs(dst, mid);
            return consumerUIDArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMessageBeenAcked(DestinationUID dst, SysMessageID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.hasMessageBeenAcked() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            boolean bl = this.msgStore.hasMessageBeenAcked(dst, id);
            return bl;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeInterest() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.intStore.storeInterest(interest);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterest(Consumer interest, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.removeInterest() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.intStore.removeInterest(interest);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Consumer[] consumerArray = this.intStore.getAllInterests();
            return consumerArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDestination(Destination destination, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.storeDestination(" + destination + ", " + sync + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstStore.storeDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDestination(Destination destination, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.updateDestination(" + destination + ", " + sync + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstStore.updateDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDestination(Destination destination, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.removeDestination(" + destination + ", " + sync + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstStore.removeDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getDestination(DestinationUID id) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.getDestination(" + id + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            Destination destination = this.dstStore.getDestination(id);
            return destination;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.getAllDestinations()");
        }
        this.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.dstStore.getAllDestinations();
            return destinationArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransaction(TransactionUID id, TransactionState ts, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (id == null || ts == null) {
                throw new NullPointerException();
            }
            this.txnStore.storeTransaction(id, ts, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    public void removeTransaction(TransactionUID id, boolean sync) throws IOException, BrokerException {
        this.removeTransaction(id, false, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransaction(TransactionUID id, boolean removeAcks, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.removeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            if (removeAcks) {
                this.txnStore.removeTransactionAck(id);
            }
            this.txnStore.removeTransaction(id, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransactionState(TransactionUID id, TransactionState ts, boolean sync) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.updateTransactionState( id=" + id + ", ts=" + ts.getState() + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            this.txnStore.updateTransactionState(id, ts.getState(), sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void updateTransactionStateWithWork(TransactionUID id, TransactionState ts, TransactionWork txnwork, boolean sync) throws IOException, BrokerException {
        throw new UnsupportedOperationException("updateTransactionStateWithWork() not supported by " + this.getStoreType() + " store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnStore.getAllTransactionStates();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransactionAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeTransactionAck() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (tid == null || ack == null) {
                throw new NullPointerException();
            }
            this.txnStore.storeTransactionAck(tid, ack, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionAck(TransactionUID id, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.removeTransactionAck() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (id == null) {
                throw new NullPointerException();
            }
            this.txnStore.removeTransactionAck(id);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID tid) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (tid == null) {
                throw new NullPointerException();
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.txnStore.getTransactionAcks(tid);
            return transactionAcknowledgementArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnStore.getAllTransactionAcks();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTransaction(TransactionUID id, TransactionInfo txnInfo, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.storeTransaction(id, txnInfo, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeClusterTransaction(TransactionUID id, TransactionState ts, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeClusterTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.storeClusterTransaction(id, ts, txnBrokers, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransaction(TransactionUID id, TransactionBroker[] txnBrokers, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.updateClusterTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.updateClusterTransaction(id, txnBrokers, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.updateClusterTransactionBrokerState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            TransactionBroker[] transactionBrokerArray = this.txnStore.getClusterTransactionBrokers(id);
            return transactionBrokerArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransactionBrokerState(TransactionUID id, int expectedTxnState, TransactionBroker txnBroker, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.updateClusterTransactionBrokerState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.updateTransactionBrokerState(id, expectedTxnState, txnBroker, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeRemoteTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.storeRemoteTransaction(id, ts, txnAcks, txnHomeBroker, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getRemoteTransactionHomeBroker() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            BrokerAddress brokerAddress = this.txnStore.getRemoteTransactionHomeBroker(id);
            return brokerAddress;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllRemoteTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getAllRemoteTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnStore.getAllRemoteTransactionStates();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionState getTransactionState(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getTransactionState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            TransactionState transactionState = this.txnStore.getTransactionState(id);
            return transactionState;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionInfo getTransactionInfo(TransactionUID id) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getTransactionInfo() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            TransactionInfo transactionInfo = this.txnStore.getTransactionInfo(id);
            return transactionInfo;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTransactions(String brokerID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getTransactions() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Collection collection = this.txnStore.getAllTransactions();
            return collection;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperty(String name, Object value, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.updateProperty() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (name == null) {
                throw new NullPointerException();
            }
            this.propStore.updateProperty(name, value);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String name) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getProperty() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (name == null) {
                throw new NullPointerException();
            }
            Object object = this.propStore.getProperty(name);
            return object;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            String[] stringArray = this.propStore.getPropertyNames();
            return stringArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getAllProperties() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Properties properties = this.propStore.getProperties();
            return properties;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeConfigChangeRecord(long timestamp, byte[] recordData, boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.storeConfigChangeRecord() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (timestamp <= 0L) {
                logger.log(32, "B3074", (Object)timestamp);
                throw new BrokerException(br.getString("B3074", timestamp));
            }
            if (recordData == null) {
                throw new NullPointerException();
            }
            this.configStoreStore.storeConfigChangeRecord(timestamp, recordData, sync);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long timestamp) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getConfigChangeRecordsSince() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            ArrayList<ChangeRecordInfo> arrayList = this.configStoreStore.getConfigChangeRecordsSince(timestamp);
            return arrayList;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            List<ChangeRecordInfo> list = this.configStoreStore.getAllConfigRecords();
            return list;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllConfigChangeRecords(boolean sync) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.configStoreStore.clearAll();
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getMessageStorageInfo(Destination dst) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(8, "CoherenceStore.getMessageStorageInfo(" + dst + ")");
        }
        this.checkClosedAndSetInProgress();
        try {
            DestinationUID dstID = dst.getDestinationUID();
            HashMap<String, Number> data = new HashMap<String, Number>(2);
            data.put("numMsgs", this.msgStore.getMessageCount(dstID));
            data.put("totalMsgBytes", this.msgStore.getByteCount(dstID));
            HashMap<String, Number> hashMap = data;
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String getStoreType() {
        return "coherence";
    }

    @Override
    public boolean isJDBCStore() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "CoherenceStore.getStorageInfo(" + destination + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getStorageInfo(destination);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("CoherenceStore version", String.valueOf(460));
        t.putAll(this.dstStore.getDebugState());
        t.putAll(this.msgStore.getDebugState());
        t.putAll(this.intStore.getDebugState());
        t.putAll(this.txnStore.getDebugState());
        t.putAll(this.propStore.getDebugState());
        t.putAll(this.configStoreStore.getDebugState());
        return t;
    }

    public void compactDestination(Destination destination) throws BrokerException {
    }

    MsgStore getMsgStore() {
        return this.msgStore;
    }

    protected DestinationStore getDstStore() {
        return this.dstStore;
    }

    @Override
    protected void setClosedAndWait() {
        this.isClosed.set(true);
    }

    @Override
    protected void checkClosedAndSetInProgress() throws BrokerException {
        if (this.isClosed.get()) {
            logger.log(32, "B3102");
            throw new BrokerException(br.getString("B3102"));
        }
    }

    @Override
    protected void setInProgress(boolean flag) {
    }

    protected NamedCache getDstCache() {
        return this.dstCache;
    }

    @Override
    public LoadException getLoadDestinationException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionAckException() {
        return null;
    }

    @Override
    public int[] getTransactionUsageInfo(TransactionUID txnID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public long getTransactionAccessedTime(TransactionUID txnID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateTransactionAccessedTime(TransactionUID txnID, long timestamp) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public void updateRemoteTransaction(TransactionUID txnUID, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    public void updateInterestState(DestinationUID dID, SysMessageID mID, ConsumerUID iID, int state, boolean sync) throws BrokerException {
        this.updateInterestState(dID, mID, iID, state, sync, null, false);
    }

    public void storeInterestStates(DestinationUID dID, SysMessageID mID, ConsumerUID[] iIDs, int[] states, boolean sync) throws BrokerException {
        this.storeInterestStates(dID, mID, iIDs, states, sync, null);
    }

    @Override
    public void removeMessage(DestinationUID dID, SysMessageID mID, boolean sync) throws IOException, BrokerException {
        this.removeMessage(dID, mID, sync, false);
    }

    @Override
    public void closeEnumeration(Enumeration en) {
    }

    public String toString() {
        return "[" + this.getStoreType() + "]";
    }

    public int hashCode() {
        return this.partitionid.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof PartitionedStore)) {
            return false;
        }
        return this.getPartitionID().equals((Object)((PartitionedStore)anObject).getPartitionID());
    }

    @Override
    public void init(Store store, UID id, boolean isPrimary) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.getStoreType() + " store");
    }

    @Override
    public UID getPartitionID() {
        return this.partitionid;
    }

    @Override
    public boolean isPrimaryPartition() {
        return true;
    }

    @Override
    public List<PartitionedStore> getAllStorePartitions() throws BrokerException {
        ArrayList<PartitionedStore> list = new ArrayList<PartitionedStore>();
        list.add(this);
        return list;
    }

    @Override
    public PartitionedStore getPrimaryPartition() throws BrokerException {
        return this;
    }
}

