/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.MessageInfo;
import com.sun.messaging.jmq.jmsserver.persist.coherence.StoreEntryProcessor;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DstMsgStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    DestinationUID myDestination = null;
    private int msgCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();
    private CoherenceStore store = null;
    private NamedCache mymsgCache = null;

    DstMsgStore(CoherenceStore s, DestinationUID duid) {
        this.store = s;
        this.mymsgCache = CacheFactory.getCache((String)(this.store.getCacheNamePrefix() + duid.toString()));
        this.myDestination = duid;
        this.initCounts();
    }

    protected MessageInfo storeMessage(Packet message, ConsumerUID[] iids, int[] states) throws IOException, BrokerException {
        String id = message.getSysMessageID().getUniqueName();
        MessageInfo info = new MessageInfo(this, message, iids, states);
        Object o = null;
        try {
            o = this.mymsgCache.invoke((Object)id, (InvocableMap.EntryProcessor)new StoreEntryProcessor(info));
        }
        catch (Exception e) {
            throw new BrokerException("Failed store message " + id, e);
        }
        if (o.equals(false)) {
            String emsg = this.br.getString("B3008", id, this.myDestination);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        int msgsize = message.getPacketSize();
        this.incrMsgCount(msgsize);
        return info;
    }

    protected void removeMessage(SysMessageID mid) throws IOException, BrokerException {
        String id = mid.getUniqueName();
        MessageInfo oldmsg = (MessageInfo)this.mymsgCache.remove((Object)id);
        if (oldmsg == null) {
            String emsg = this.br.getString("B3007", mid, this.myDestination);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        this.decrMsgCount(oldmsg.getSize());
    }

    protected void removeAllMessages(boolean sync) throws IOException, BrokerException {
        this.mymsgCache.destroy();
        this.clearCounts();
    }

    protected Enumeration messageEnumeration() {
        return new MsgEnumeration(this, this.getMessageIterator());
    }

    protected int getMessageCount() throws BrokerException {
        return this.msgCount;
    }

    protected long getByteCount() throws BrokerException {
        return this.byteCount;
    }

    protected void close() {
        this.mymsgCache.release();
    }

    protected MessageInfo getMessageInfo(SysMessageID mid) throws BrokerException {
        String id = mid.getUniqueName();
        MessageInfo info = (MessageInfo)this.mymsgCache.get((Object)id);
        if (info == null) {
            String emsg = this.br.getString("B3007", mid, this.myDestination);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return info;
    }

    private Iterator getMessageIterator() {
        return this.mymsgCache.keySet(null).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrMsgCount(int msgSize) {
        Object object = this.countLock;
        synchronized (object) {
            ++this.msgCount;
            this.byteCount += (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrMsgCount(int msgSize) {
        Object object = this.countLock;
        synchronized (object) {
            --this.msgCount;
            this.byteCount -= (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        Object object = this.countLock;
        synchronized (object) {
            this.msgCount = 0;
            this.byteCount = 0L;
        }
    }

    private void initCounts() {
        this.msgCount = this.mymsgCache.size();
        Iterator itr = this.mymsgCache.getAll((Collection)this.mymsgCache.keySet()).values().iterator();
        this.byteCount = 0L;
        while (itr.hasNext()) {
            this.byteCount += (long)((MessageInfo)itr.next()).getSize();
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put(this.myDestination + ":messages in store ", String.valueOf(this.msgCount));
        return t;
    }

    protected void storeInterestStates(SysMessageID mid, ConsumerUID[] iids, int[] states) throws IOException, BrokerException {
        String id = mid.getUniqueName();
        Object o = null;
        try {
            o = this.mymsgCache.invoke((Object)id, (InvocableMap.EntryProcessor)new StoreInterestStatesProcessor(iids, states));
        }
        catch (Exception e) {
            throw new BrokerException("Failed to store insterest states for message " + id, e);
        }
        if (o.equals(false)) {
            throw new BrokerException("Message info for " + id + " not found in store for storing interest states");
        }
    }

    protected void updateInterestState(SysMessageID mid, ConsumerUID iid, int state) throws IOException, BrokerException {
        String id = mid.getUniqueName();
        Object o = null;
        try {
            o = this.mymsgCache.invoke((Object)id, (InvocableMap.EntryProcessor)new UpdateInterestStateProcessor(iid, state));
        }
        catch (Exception e) {
            throw new BrokerException("Failed to update interest state for message " + id, e);
        }
        if (o.equals(false)) {
            throw new BrokerException("Message info for " + id + " not found in store on updating interest state for " + iid);
        }
    }

    protected boolean containsMsg(SysMessageID mid) {
        return this.mymsgCache.containsKey((Object)mid.getUniqueName());
    }

    protected Packet getMessage(SysMessageID mid) throws IOException, BrokerException {
        MessageInfo msginfo = (MessageInfo)this.mymsgCache.get((Object)mid.getUniqueName());
        if (msginfo == null) {
            String emsg = this.br.getString("B3007", mid, this.myDestination);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return msginfo.getMessage();
    }

    private static class UpdateInterestStateProcessor
    extends AbstractProcessor {
        ConsumerUID iid = null;
        int state = 0;

        public UpdateInterestStateProcessor() {
        }

        public UpdateInterestStateProcessor(ConsumerUID iid, int state) {
            this.iid = iid;
            this.state = state;
        }

        public Object process(InvocableMap.Entry entry) {
            if (!entry.isPresent()) {
                return false;
            }
            MessageInfo o = (MessageInfo)entry.getValue();
            try {
                o.updateState(this.iid, this.state);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            entry.setValue((Object)o);
            return true;
        }
    }

    private static class StoreInterestStatesProcessor
    extends AbstractProcessor {
        ConsumerUID[] iids = null;
        int[] states = null;

        public StoreInterestStatesProcessor() {
        }

        public StoreInterestStatesProcessor(ConsumerUID[] iids, int[] states) {
            this.iids = iids;
            this.states = states;
        }

        public Object process(InvocableMap.Entry entry) {
            if (!entry.isPresent()) {
                return false;
            }
            MessageInfo o = (MessageInfo)entry.getValue();
            try {
                o.storeStates(this.iids, this.states);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            entry.setValue((Object)o);
            return true;
        }
    }

    private static class MsgEnumeration
    implements Enumeration {
        DstMsgStore parent = null;
        Iterator itr = null;
        Object objToReturn = null;

        MsgEnumeration(DstMsgStore p, Iterator i) {
            this.parent = p;
            this.itr = i;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.itr.hasNext()) {
                this.objToReturn = this.itr.next();
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object result = null;
                if (this.objToReturn instanceof String) {
                    try {
                        result = this.parent.getMessage(SysMessageID.get((String)((String)this.objToReturn)));
                    }
                    catch (IOException e) {
                        this.parent.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.myDestination, (Throwable)e);
                        throw new NoSuchElementException();
                    }
                    catch (BrokerException e) {
                        this.parent.logger.log(32, "B4005", this.objToReturn, (Object)this.parent.myDestination, (Throwable)e);
                        throw new NoSuchElementException();
                    }
                } else {
                    result = this.objToReturn;
                }
                this.objToReturn = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

