/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class PropertiesStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private NamedCache propcache = null;

    PropertiesStore(CoherenceStore s) {
        this.propcache = CacheFactory.getCache((String)(s.getCacheNamePrefix() + "propcache"));
    }

    protected void updateProperty(String name, Object value) throws BrokerException {
        try {
            boolean updated = false;
            if (value == null) {
                Object old = this.propcache.remove((Object)name);
                updated = old != null;
            } else {
                this.propcache.put((Object)name, value);
                updated = true;
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4112", (Object)name);
            throw new BrokerException(this.br.getString("B4112", name), e);
        }
    }

    protected Object getProperty(String name) throws BrokerException {
        return this.propcache.get((Object)name);
    }

    protected String[] getPropertyNames() throws BrokerException {
        Set keys = this.propcache.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    protected Properties getProperties() throws BrokerException {
        Properties props = new Properties();
        for (Map.Entry e : this.propcache.entrySet()) {
            props.put(e.getKey(), e.getValue());
        }
        return props;
    }

    protected void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "PropertiesStore.clearAll()");
        }
        this.propcache.destroy();
    }

    protected void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(8, "PropertiesStore.close(" + cleanup + ")" + this.propcache.size() + " properties");
        }
        this.propcache.release();
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Properties", String.valueOf(this.propcache.size()));
        return t;
    }
}

