/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.StoreEntryProcessor;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TxnStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private HashMap emptyHashMap = new HashMap();
    private TransactionAcknowledgement[] emptyAckArray = new TransactionAcknowledgement[0];
    private NamedCache txncache = null;
    private NamedCache txnackcache = null;

    TxnStore(CoherenceStore s) {
        this.txncache = CacheFactory.getCache((String)(s.getCacheNamePrefix() + "txn"));
        this.txnackcache = CacheFactory.getCache((String)(s.getCacheNamePrefix() + "txnack"));
    }

    protected void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TxnStore.close(" + cleanup + "), " + this.txncache.size() + " transactions, " + this.txnackcache.size() + " transaction acks ");
        }
        try {
            this.txncache.release();
        }
        catch (Throwable t) {
            this.logger.logStack(16, "Releasing transaction cache " + this.txncache + " failed", t);
        }
        try {
            this.txnackcache.release();
        }
        catch (Throwable t) {
            this.logger.logStack(16, "Releasing transaction ack cache " + this.txnackcache + " failed", t);
        }
    }

    protected void storeTransaction(TransactionUID tid, TransactionState ts, boolean sync) throws IOException, BrokerException {
        String id = tid.toString();
        Object o = null;
        try {
            o = this.txncache.invoke((Object)id, (InvocableMap.EntryProcessor)new StoreEntryProcessor(new TransactionInfo(new TransactionState(ts))));
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4019", id);
            this.logger.log(32, emsg, (Throwable)e);
            throw new BrokerException(emsg, e);
        }
        if (o.equals(false)) {
            String emsg = this.br.getKString("B3015", id);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }

    protected void storeClusterTransaction(TransactionUID tid, TransactionState ts, TransactionBroker[] brokers, boolean sync) throws BrokerException {
        String id = tid.toString();
        TransactionInfo txninfo = new TransactionInfo(new TransactionState(ts), null, brokers, 2);
        Object o = null;
        try {
            o = this.txncache.invoke((Object)id, (InvocableMap.EntryProcessor)new StoreEntryProcessor(txninfo));
        }
        catch (Exception e) {
            String msg = id + " " + txninfo;
            String emsg = this.br.getKString("B4019", msg);
            this.logger.log(32, emsg, (Throwable)e);
            throw new BrokerException(emsg, e);
        }
        if (o.equals(false)) {
            String emsg = this.br.getKString("B3015", id);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }

    protected void storeRemoteTransaction(TransactionUID tid, TransactionState ts, TransactionAcknowledgement[] acks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        String id = tid.toString();
        TransactionInfo txninfo = null;
        boolean ackstored = false;
        this.txncache.lock((Object)id, -1L);
        try {
            if (this.txncache.containsKey((Object)id)) {
                this.logger.log(32, "B3015", (Object)id);
                throw new BrokerException(this.br.getString("B3015", id));
            }
            if (acks != null && acks.length > 0) {
                this.storeTransactionAcks(tid, acks);
                ackstored = true;
            }
            txninfo = new TransactionInfo(new TransactionState(ts), txnHomeBroker, null, 3);
            this.txncache.put((Object)id, (Object)txninfo);
        }
        catch (RuntimeException e) {
            String msg = txninfo != null ? id + " " + txninfo.toString() : id;
            this.logger.log(32, "B4019", (Object)msg, (Throwable)e);
            try {
                if (ackstored) {
                    this.removeTransactionAck(tid);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new BrokerException(this.br.getString("B4019", msg), e);
        }
        finally {
            this.txncache.unlock((Object)id);
        }
    }

    protected void storeTransaction(TransactionUID tid, TransactionInfo txninfo, boolean sync) throws BrokerException {
        String id = tid.toString();
        Object o = null;
        try {
            o = this.txncache.invoke((Object)id, (InvocableMap.EntryProcessor)new StoreEntryProcessor(txninfo));
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4019", id);
            this.logger.log(32, emsg, (Throwable)e);
            throw new BrokerException(emsg, e);
        }
        if (o.equals(false)) {
            String emsg = this.br.getKString("B3015", id);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }

    protected void removeTransaction(TransactionUID tid, boolean sync) throws BrokerException {
        String id = tid.toString();
        try {
            Object txninfo = this.txncache.remove((Object)id);
            if (txninfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4138", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4138", id), e);
        }
    }

    protected void updateTransactionState(TransactionUID tid, int ts, boolean sync) throws IOException, BrokerException {
        String id = tid.toString();
        this.txncache.lock((Object)id, -1L);
        try {
            TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
            if (txninfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            TransactionState txnState = txninfo.getTransactionState();
            if (txnState.getState() != ts) {
                txnState.setState(ts);
                this.txncache.put((Object)id, (Object)txninfo);
            }
        }
        catch (Exception e) {
            this.logger.log(32, "B4137", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4137", id), e);
        }
        finally {
            this.txncache.unlock((Object)id);
        }
    }

    protected void updateClusterTransaction(TransactionUID tid, TransactionBroker[] brokers, boolean sync) throws BrokerException {
        String id = tid.toString();
        try {
            TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
            if (txninfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            txninfo.setType(2);
            txninfo.setTransactionBrokers(brokers);
            this.txncache.put((Object)id, (Object)txninfo);
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
        finally {
            this.txncache.unlock((Object)id);
        }
    }

    protected void updateTransactionBrokerState(TransactionUID tid, int expectedTxnState, TransactionBroker txnBkr, boolean sync) throws BrokerException {
        String id = tid.toString();
        this.txncache.lock((Object)id, -1L);
        try {
            TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
            if (txninfo == null) {
                this.logger.log(32, "B3016", (Object)id);
                throw new BrokerException(this.br.getString("B3016", id), 404);
            }
            TransactionState txnState = txninfo.getTransactionState();
            if (txnState.getState() != expectedTxnState) {
                Object[] args = new Object[]{txnBkr, id, TransactionState.toString(expectedTxnState), TransactionState.toString(txnState.getState())};
                throw new BrokerException(this.br.getKString("B3219", args), 409);
            }
            txninfo.updateBrokerState(txnBkr);
            this.txncache.put((Object)id, (Object)txninfo);
        }
        catch (Exception e) {
            this.logger.log(32, "B4019", (Object)id, (Throwable)e);
            throw new BrokerException(this.br.getString("B4019", id), e);
        }
        finally {
            this.txncache.unlock((Object)id);
        }
    }

    protected TransactionState getTransactionState(TransactionUID tid) throws BrokerException {
        String id = tid.toString();
        TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
        if (txninfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return new TransactionState(txninfo.getTransactionState());
    }

    protected int getTransactionStateValue(TransactionUID tid) throws BrokerException {
        TransactionState txnState;
        String id = tid.toString();
        TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
        if (txninfo != null && (txnState = txninfo.getTransactionState()) != null) {
            return txnState.getState();
        }
        return -1;
    }

    protected TransactionInfo getTransactionInfo(TransactionUID tid) throws BrokerException {
        String id = tid.toString();
        TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
        if (txninfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return (TransactionInfo)txninfo.clone();
    }

    protected BrokerAddress getRemoteTransactionHomeBroker(TransactionUID tid) throws BrokerException {
        String id = tid.toString();
        TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
        if (txninfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        return txninfo.getTransactionHomeBroker();
    }

    protected TransactionBroker[] getClusterTransactionBrokers(TransactionUID tid) throws BrokerException {
        String id = tid.toString();
        TransactionInfo txninfo = (TransactionInfo)this.txncache.get((Object)id);
        if (txninfo == null) {
            this.logger.log(32, "B3016", (Object)id);
            throw new BrokerException(this.br.getString("B3016", id), 404);
        }
        TransactionBroker[] txnBrokers = txninfo.getTransactionBrokers();
        if (txnBrokers != null) {
            txnBrokers = (TransactionBroker[])txnBrokers.clone();
        }
        return txnBrokers;
    }

    protected HashMap getAllTransactionStates() throws IOException {
        HashMap map = new HashMap(this.txncache.size());
        for (Map.Entry entry : this.txncache.entrySet()) {
            TransactionInfo txninfo = (TransactionInfo)entry.getValue();
            int type = txninfo.getType();
            if (type != 1 && type != 2) continue;
            map.put(entry.getKey(), new TransactionInfo(txninfo));
        }
        return map;
    }

    protected HashMap getAllRemoteTransactionStates() throws IOException {
        HashMap map = new HashMap(this.txncache.size());
        for (Map.Entry entry : this.txncache.entrySet()) {
            TransactionInfo txninfo = (TransactionInfo)entry.getValue();
            int type = txninfo.getType();
            if (type != 3) continue;
            map.put(entry.getKey(), txninfo.getTransactionState());
        }
        return map;
    }

    protected Collection getAllTransactions() {
        return this.txncache.keySet();
    }

    protected void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TxnStore.clearAll()");
        }
        try {
            this.txncache.destroy();
        }
        catch (Throwable t) {
            this.logger.logStack(16, "Destroying transaction cache " + this.txncache + " failed", t);
        }
        try {
            this.txnackcache.destroy();
        }
        catch (Throwable t) {
            this.logger.logStack(16, "Destroying transaction ack cache " + this.txnackcache + " failed", t);
        }
    }

    protected void clear(int state, boolean sync) throws BrokerException {
        boolean error = false;
        RuntimeException exception = null;
        Iterator itr = this.txncache.entrySet().iterator();
        while (itr.hasNext()) {
            try {
                Map.Entry entry = (Map.Entry)itr.next();
                TransactionUID tid = (TransactionUID)entry.getKey();
                TransactionState ts = (TransactionState)entry.getValue();
                if (ts.getState() == state) continue;
                itr.remove();
                this.removeTransactionAck(tid);
            }
            catch (RuntimeException e) {
                error = true;
                exception = e;
                this.logger.log(32, "B4139", (Object)state, (Throwable)e);
            }
        }
        if (!error) {
            for (TransactionUID tid : this.txnackcache.keySet()) {
                TransactionInfo txnInfo = (TransactionInfo)this.txncache.get((Object)tid.toString());
                if (txnInfo != null && txnInfo.getTransactionStateValue() == state) continue;
                this.removeTransactionAck(tid);
            }
        }
        if (error) {
            this.clearAll();
            throw new BrokerException(this.br.getString("B4139", state), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeTransactionAck(TransactionUID tid, TransactionAcknowledgement ack, boolean sync) throws BrokerException {
        String id = tid.toString();
        this.txncache.lock((Object)id, -1L);
        try {
            if (!this.txncache.containsKey((Object)id)) {
                this.logger.log(32, "B3016", (Object)tid.toString());
                throw new BrokerException(this.br.getString("B3016", tid.toString()));
            }
            this.txnackcache.lock((Object)id, -1L);
            try {
                boolean putIfAbsent = false;
                HashSet acks = (HashSet)this.txnackcache.get((Object)id);
                if (acks == null) {
                    putIfAbsent = true;
                    acks = new HashSet();
                    acks.add(ack);
                    acks = (HashSet)this.txnackcache.put((Object)id, acks);
                    if (acks != null) {
                        acks = (HashSet)this.txnackcache.get((Object)id);
                        acks.add(ack);
                        this.txnackcache.put((Object)id, (Object)acks);
                    }
                } else {
                    if (acks.contains(ack)) {
                        this.logger.log(32, "B3062", (Object)ack, (Object)tid);
                        throw new BrokerException(this.br.getString("B3062", ack, tid));
                    }
                    acks.add(ack);
                    this.txnackcache.put((Object)id, acks);
                }
            }
            catch (RuntimeException e) {
                this.logger.log(32, "B4056", (Object)ack.toString(), (Object)tid.toString());
                throw new BrokerException(this.br.getString("B4056", ack.toString(), tid.toString()), e);
            }
            finally {
                this.txnackcache.unlock((Object)id);
            }
        }
        finally {
            this.txncache.unlock((Object)id);
        }
    }

    protected void storeTransactionAcks(TransactionUID tid, TransactionAcknowledgement[] txnAcks) throws BrokerException {
        String id = tid.toString();
        List<TransactionAcknowledgement> ackList = Arrays.asList(txnAcks);
        this.txnackcache.lock((Object)id, -1L);
        try {
            boolean putIfAbsent = false;
            HashSet<TransactionAcknowledgement> acks = (HashSet<TransactionAcknowledgement>)this.txnackcache.get((Object)tid);
            if (acks == null) {
                acks = new HashSet<TransactionAcknowledgement>(ackList.size());
                acks.addAll(ackList);
                this.txnackcache.put((Object)id, acks);
            } else {
                acks.addAll(ackList);
                this.txnackcache.put((Object)id, acks);
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4056", (Object)ackList.toString(), (Object)tid.toString());
            throw new BrokerException(this.br.getString("B4056", ackList.toString(), tid.toString()), e);
        }
        finally {
            this.txnackcache.unlock((Object)id);
        }
    }

    protected void removeTransactionAck(TransactionUID tid) throws BrokerException {
        String id = tid.toString();
        try {
            HashSet acks = (HashSet)this.txnackcache.remove((Object)id);
            if (acks != null) {
                acks.clear();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4060", (Object)tid.toString());
            throw new BrokerException(this.br.getString("B4060", tid.toString()), e);
        }
    }

    protected TransactionAcknowledgement[] getTransactionAcks(TransactionUID tid) throws BrokerException {
        String id = tid.toString();
        HashSet acks = (HashSet)this.txnackcache.get((Object)id);
        if (acks != null) {
            return acks.toArray(this.emptyAckArray);
        }
        return this.emptyAckArray;
    }

    protected HashMap getAllTransactionAcks() {
        if (this.txnackcache.size() == 0) {
            return this.emptyHashMap;
        }
        HashMap allacks = new HashMap(this.txnackcache.size());
        Set entries = this.txnackcache.entrySet();
        for (Map.Entry entry : entries) {
            HashSet set = (HashSet)entry.getValue();
            TransactionAcknowledgement[] acks = set.toArray(this.emptyAckArray);
            allacks.put(entry.getKey(), acks);
        }
        return allacks;
    }

    protected int getNumberOfTxnAcks() {
        int size = 0;
        for (Map.Entry entry : this.txnackcache.entrySet()) {
            HashSet acks = (HashSet)entry.getValue();
            size += acks.size();
        }
        return size;
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Transactions", String.valueOf(this.txncache.size()));
        t.put("TransacionAcks", String.valueOf(this.txnackcache.size()));
        return t;
    }
}

